/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.util.scanner;

import com.calemi.ccore.api.block.scanner.BlockScanner;
import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.NexusPortalBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;

public class PortalScanner
extends BlockScanner {
    private final Direction.Axis axis;
    private final boolean scanDifferentColors;

    public PortalScanner(BlockLocation origin, Direction.Axis axis, boolean scanDifferentColors, int maxCollectionSize) {
        super(origin, maxCollectionSize);
        this.axis = axis;
        this.scanDifferentColors = scanDifferentColors;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public boolean shouldCollect(BlockPos scannedBlockPos) {
        boolean bl;
        if (!this.scanDifferentColors) {
            return this.getLevel().getBlockState(scannedBlockPos).getBlock().equals(this.getLevel().getBlockState(this.getOriginPosition()).getBlock());
        }
        Block block = this.getLevel().getBlockState(scannedBlockPos).getBlock();
        if (block instanceof NexusPortalBlock) {
            NexusPortalBlock portalBlock = (NexusPortalBlock)block;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean branchOnFailedCollect() {
        return false;
    }

    public List<BlockPos> nextPositionsToScan(BlockPos prevBlockPos) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.axis.isVertical()) {
            positions.add(prevBlockPos.relative(Direction.NORTH));
            positions.add(prevBlockPos.relative(Direction.SOUTH));
            positions.add(prevBlockPos.relative(Direction.EAST));
            positions.add(prevBlockPos.relative(Direction.WEST));
            return positions;
        }
        positions.add(prevBlockPos.relative(Direction.UP));
        positions.add(prevBlockPos.relative(Direction.DOWN));
        positions.add(prevBlockPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
        positions.add(prevBlockPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
        return positions;
    }
}

