/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.util.scanner;

import com.calemi.ccore.api.block.scanner.BlockScanner;
import com.calemi.ccore.api.location.BlockLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class PortalSpaceScanner
extends BlockScanner {
    private final Direction.Axis axis;

    public PortalSpaceScanner(BlockLocation origin, Direction.Axis axis, int maxCollectionSize) {
        super(origin, maxCollectionSize);
        this.axis = axis;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public boolean shouldCollect(BlockPos scannedBlockPos) {
        BlockState state = this.getLevel().getBlockState(scannedBlockPos);
        if (!state.isAir() && !state.isCollisionShapeFullBlock((BlockGetter)this.getLevel(), scannedBlockPos)) {
            this.setHalted(true);
            return false;
        }
        return state.isAir();
    }

    public boolean branchOnFailedCollect() {
        return false;
    }

    public List<BlockPos> nextPositionsToScan(BlockPos prevBlockPos) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.axis.isVertical()) {
            positions.add(prevBlockPos.relative(Direction.NORTH));
            positions.add(prevBlockPos.relative(Direction.SOUTH));
            positions.add(prevBlockPos.relative(Direction.EAST));
            positions.add(prevBlockPos.relative(Direction.WEST));
            return positions;
        }
        positions.add(prevBlockPos.relative(Direction.UP));
        positions.add(prevBlockPos.relative(Direction.DOWN));
        positions.add(prevBlockPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
        positions.add(prevBlockPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
        return positions;
    }
}

