/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.world.dimension;

import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.world.biome.NexusBiomes;
import com.calemi.nexus.world.noise.NexusNoiseSettings;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class NexusDimensions {
    public static final ResourceLocation NEXUS_RL = NexusRef.rl("the_nexus");
    public static final ResourceKey<DimensionType> NEXUS_DIMENSION_TYPE = NexusRef.createKey(NEXUS_RL, Registries.DIMENSION_TYPE);
    public static final ResourceKey<Level> NEXUS_LEVEL = NexusRef.createKey(NEXUS_RL, Registries.DIMENSION);
    public static final ResourceKey<LevelStem> NEXUS_LEVEL_STEM = NexusRef.createKey(NEXUS_RL, Registries.LEVEL_STEM);

    public static void bootstrapDimensionType(BootstrapContext<DimensionType> context) {
        context.register(NEXUS_DIMENSION_TYPE, (Object)NexusDimensions.nexusDimensionType());
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> context) {
        HolderGetter dimensionTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter noiseSettings = context.lookup(Registries.NOISE_SETTINGS);
        context.register(NEXUS_LEVEL_STEM, (Object)NexusDimensions.nexusLevelStem((HolderGetter<DimensionType>)dimensionTypes, (HolderGetter<Biome>)biomes, (HolderGetter<NoiseGeneratorSettings>)noiseSettings));
    }

    private static DimensionType nexusDimensionType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, false, false, 0, 256, 256, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.OVERWORLD_EFFECTS, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)0), 0));
    }

    public static LevelStem nexusLevelStem(HolderGetter<DimensionType> dimensionTypes, HolderGetter<Biome> biomes, HolderGetter<NoiseGeneratorSettings> noiseSettings) {
        FixedBiomeSource source = new FixedBiomeSource((Holder)biomes.getOrThrow(NexusBiomes.CHRONOWARPED_FIELDS));
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)source, (Holder)noiseSettings.getOrThrow(NexusNoiseSettings.NEXUS));
        return new LevelStem((Holder)dimensionTypes.getOrThrow(NEXUS_DIMENSION_TYPE), (ChunkGenerator)chunkGenerator);
    }
}

