/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.world.feature;

import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.world.feature.configured.ChasmConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class ChasmFeature
extends Feature<ChasmConfiguration> {
    public ChasmFeature(Codec<ChasmConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ChasmConfiguration> context) {
        int radiusXZ = context.random().nextIntBetweenInclusive(((ChasmConfiguration)context.config()).radiusMinXZ(), ((ChasmConfiguration)context.config()).radiusMaxXZ());
        int radiusY = context.random().nextIntBetweenInclusive(((ChasmConfiguration)context.config()).radiusMinY(), ((ChasmConfiguration)context.config()).radiusMaxY());
        int centerX = context.origin().getX();
        int centerZ = context.origin().getZ();
        for (int x = -radiusXZ; x <= radiusXZ; ++x) {
            for (int z = -radiusXZ; z <= radiusXZ; ++z) {
                for (int y = 10; y >= -radiusY; --y) {
                    Vec3 localPos = new Vec3((double)(x - context.origin().getX()), (double)(y - context.origin().getY()), (double)(z - context.origin().getZ()));
                    BlockPos pos = context.origin().offset(x, y, z);
                    if (this.checkRadius(x, y, z, radiusXZ, radiusY) && this.shouldReplaceWithStone(context.level(), pos) && context.random().nextDouble() <= 0.25) {
                        context.level().setBlock(pos, Blocks.TUFF.defaultBlockState(), 3);
                    }
                    if (!this.checkRadius(x, y, z, radiusXZ - 3, radiusY)) continue;
                    if (this.shouldReplaceWithStone(context.level(), pos)) {
                        Block wallBlock = Blocks.TUFF;
                        if (context.random().nextDouble() <= 0.25) {
                            wallBlock = (Block)NexusBlocks.WARPSLATE.get();
                        } else if (context.random().nextDouble() <= 0.25) {
                            wallBlock = Blocks.CALCITE;
                        } else if (context.random().nextDouble() <= 0.05) {
                            wallBlock = (Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get();
                        }
                        context.level().setBlock(pos, wallBlock.defaultBlockState(), 3);
                    }
                    if (!this.checkRadius(x, y, z, radiusXZ - 4, radiusY)) continue;
                    Block airBlock = Blocks.AIR;
                    if (this.shouldReplaceWithStone(context.level(), pos) && context.random().nextDouble() <= 0.25) {
                        airBlock = Blocks.TUFF;
                    }
                    context.level().setBlock(pos, airBlock.defaultBlockState(), 3);
                    if (!this.checkRadius(x, y, z, radiusXZ - 5, radiusY)) continue;
                    context.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
        return true;
    }

    private boolean shouldReplaceWithStone(WorldGenLevel level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        return block.equals(NexusBlocks.CHRONOWARPED_GRASS.get()) || block.equals(NexusBlocks.CHRONOWARPED_DIRT.get()) || block.equals(NexusBlocks.CHRONOWARPED_SAND.get()) || block.equals(Blocks.CALCITE) || block.equals(NexusBlocks.WARPSLATE.get()) || block.equals(Blocks.WATER);
    }

    private boolean checkRadius(int x, int y, int z, int radiusXZ, int radiusY) {
        return (double)(x * x) / (double)(radiusXZ * radiusXZ) + (double)(y * y) / (double)(radiusY * radiusY) + (double)(z * z) / (double)(radiusXZ * radiusXZ) <= 1.0;
    }
}

