/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.world.feature.configured;

import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.world.feature.NexusFeatures;
import com.calemi.nexus.world.feature.configured.ChasmConfiguration;
import com.calemi.nexus.world.feature.configured.CrystalClusterConfiguration;
import com.calemi.nexus.world.feature.tree.WarpblossomFoliagePlacer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class NexusConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> WARPBLOSSOM_CONFIGURED_KEY = NexusRef.createKey("warpblossom", Registries.CONFIGURED_FEATURE);
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_PURPLE_PETAL_CONFIGURED_KEY = NexusRef.createKey("flower_purple_petal", Registries.CONFIGURED_FEATURE);
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMETHYST_CLUSTER_CONFIGURED_KEY = NexusRef.createKey("amethyst_cluster", Registries.CONFIGURED_FEATURE);
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHRONO_CLUSTER_CONFIGURED_KEY = NexusRef.createKey("chrono_cluster", Registries.CONFIGURED_FEATURE);
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHASM_CONFIGURED_KEY = NexusRef.createKey("chasm", Registries.CONFIGURED_FEATURE);

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        NexusConfiguredFeatures.register(context, WARPBLOSSOM_CONFIGURED_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)NexusBlocks.WARPBLOSSOM_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(4, 8, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)NexusBlocks.WARPBLOSSOM_LEAVES.get())), (FoliagePlacer)new WarpblossomFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)NexusBlocks.CHRONOWARPED_DIRT.get()))).forceDirt().build());
        SimpleWeightedRandomList.Builder flowerPurplePetalBuilder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                flowerPurplePetalBuilder.add((Object)((BlockState)((BlockState)((Block)NexusBlocks.PURPLE_PETALS.get()).defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        NexusConfiguredFeatures.register(context, FLOWER_PURPLE_PETAL_CONFIGURED_KEY, Feature.FLOWER, new RandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(flowerPurplePetalBuilder)))));
        NexusConfiguredFeatures.registerCluster(context, AMETHYST_CLUSTER_CONFIGURED_KEY, Blocks.SMALL_AMETHYST_BUD, Blocks.MEDIUM_AMETHYST_BUD, Blocks.LARGE_AMETHYST_BUD, Blocks.AMETHYST_CLUSTER, Blocks.BUDDING_AMETHYST);
        NexusConfiguredFeatures.registerCluster(context, CHRONO_CLUSTER_CONFIGURED_KEY, (Block)NexusBlocks.SMALL_CHRONO_BUD.get(), (Block)NexusBlocks.MEDIUM_CHRONO_BUD.get(), (Block)NexusBlocks.LARGE_CHRONO_BUD.get(), (Block)NexusBlocks.CHRONO_CLUSTER.get(), (Block)NexusBlocks.BUDDING_CHRONO.get());
        NexusConfiguredFeatures.register(context, CHASM_CONFIGURED_KEY, (Feature)NexusFeatures.CHASM.get(), new ChasmConfiguration(7, 14, 80, 100));
    }

    private static void registerCluster(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureRK, Block smallBud, Block mediumBud, Block largeBud, Block cluster, Block budding) {
        SimpleWeightedRandomList.Builder chronoBuilder = SimpleWeightedRandomList.builder();
        chronoBuilder.add((Object)smallBud.defaultBlockState(), 2);
        chronoBuilder.add((Object)mediumBud.defaultBlockState(), 2);
        chronoBuilder.add((Object)largeBud.defaultBlockState(), 2);
        chronoBuilder.add((Object)cluster.defaultBlockState(), 1);
        context.register(configuredFeatureRK, (Object)new ConfiguredFeature((Feature)NexusFeatures.CRYSTAL_CLUSTER.get(), (FeatureConfiguration)new CrystalClusterConfiguration((BlockStateProvider)new WeightedStateProvider(chronoBuilder), (BlockStateProvider)BlockStateProvider.simple((BlockState)budding.defaultBlockState()), 0.05)));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }
}

