/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.world.feature.placed;

import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.world.feature.configured.NexusConfiguredFeatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class NexusPlacedFeatures {
    public static final ResourceKey<PlacedFeature> WARPBLOSSOM_PLACED_KEY = NexusPlacedFeatures.registerKey("warpblossom");
    public static final ResourceKey<PlacedFeature> FLOWER_PURPLE_PETAL_PLACED_KEY = NexusPlacedFeatures.registerKey("flower_purple_petal");
    public static final ResourceKey<PlacedFeature> AMETHYST_CLUSTER_PLACED_KEY = NexusPlacedFeatures.registerKey("amethyst_cluster");
    public static final ResourceKey<PlacedFeature> AMETHYST_CLUSTER_SUBMERGED_PLACED_KEY = NexusPlacedFeatures.registerKey("amethyst_cluster_submerged");
    public static final ResourceKey<PlacedFeature> CHRONO_CLUSTER_PLACED_KEY = NexusPlacedFeatures.registerKey("chrono_cluster");
    public static final ResourceKey<PlacedFeature> CHRONO_CLUSTER_SUBMERGED_PLACED_KEY = NexusPlacedFeatures.registerKey("chrono_cluster_submerged");
    public static final ResourceKey<PlacedFeature> CHASM = NexusPlacedFeatures.registerKey("chasm");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        NexusPlacedFeatures.register(context, WARPBLOSSOM_PLACED_KEY, configuredFeatures.getOrThrow(NexusConfiguredFeatures.WARPBLOSSOM_CONFIGURED_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.05f, (int)0), (Block)((Block)NexusBlocks.WARPBLOSSOM_SAPLING.get())));
        ArrayList<PlacementModifier> flowerPurplePetalModifiers = new ArrayList<PlacementModifier>();
        flowerPurplePetalModifiers.add((PlacementModifier)NoiseThresholdCountPlacement.of((double)-0.8, (int)0, (int)2));
        flowerPurplePetalModifiers.add((PlacementModifier)InSquarePlacement.spread());
        flowerPurplePetalModifiers.add(PlacementUtils.HEIGHTMAP);
        flowerPurplePetalModifiers.add((PlacementModifier)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])new Block[]{(Block)NexusBlocks.CHRONOWARPED_GRASS.get()})));
        flowerPurplePetalModifiers.add((PlacementModifier)BiomeFilter.biome());
        NexusPlacedFeatures.register(context, FLOWER_PURPLE_PETAL_PLACED_KEY, configuredFeatures.getOrThrow(NexusConfiguredFeatures.FLOWER_PURPLE_PETAL_CONFIGURED_KEY), flowerPurplePetalModifiers);
        NexusPlacedFeatures.registerCluster(context, AMETHYST_CLUSTER_PLACED_KEY, NexusConfiguredFeatures.AMETHYST_CLUSTER_CONFIGURED_KEY, false, 2, 0.0);
        NexusPlacedFeatures.registerCluster(context, AMETHYST_CLUSTER_SUBMERGED_PLACED_KEY, NexusConfiguredFeatures.AMETHYST_CLUSTER_CONFIGURED_KEY, true, 3, 0.0);
        NexusPlacedFeatures.registerCluster(context, CHRONO_CLUSTER_PLACED_KEY, NexusConfiguredFeatures.CHRONO_CLUSTER_CONFIGURED_KEY, false, 1, -0.25);
        NexusPlacedFeatures.registerCluster(context, CHRONO_CLUSTER_SUBMERGED_PLACED_KEY, NexusConfiguredFeatures.CHRONO_CLUSTER_CONFIGURED_KEY, true, 2, 0.25);
        ArrayList<PlacementModifier> chasmModifiers = new ArrayList<PlacementModifier>();
        chasmModifiers.add((PlacementModifier)RarityFilter.onAverageOnceEvery((int)300));
        chasmModifiers.add((PlacementModifier)InSquarePlacement.spread());
        chasmModifiers.add(PlacementUtils.HEIGHTMAP);
        chasmModifiers.add((PlacementModifier)BiomeFilter.biome());
        NexusPlacedFeatures.register(context, CHASM, configuredFeatures.getOrThrow(NexusConfiguredFeatures.CHASM_CONFIGURED_KEY), chasmModifiers);
    }

    private static void registerCluster(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> placedFeatureRK, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureRK, boolean submerged, int count, double noiseLevel) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ArrayList<PlacementModifier> modifiers = new ArrayList<PlacementModifier>();
        modifiers.add((PlacementModifier)NoiseThresholdCountPlacement.of((double)noiseLevel, (int)0, (int)count));
        modifiers.add((PlacementModifier)InSquarePlacement.spread());
        if (submerged) {
            modifiers.add(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR);
            modifiers.add((PlacementModifier)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER}), (BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, -1, 0), (Direction)Direction.UP))));
        } else {
            modifiers.add(PlacementUtils.HEIGHTMAP);
            modifiers.add((PlacementModifier)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, -1, 0), (Direction)Direction.UP)));
        }
        modifiers.add((PlacementModifier)BiomeFilter.biome());
        NexusPlacedFeatures.register(context, placedFeatureRK, configuredFeatures.getOrThrow(configuredFeatureRK), modifiers);
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)NexusRef.rl(name));
    }

    public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> config, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(config, List.copyOf(modifiers)));
    }
}

