/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.world.noise;

import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.main.NexusRef;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NexusNoiseSettings {
    public static final ResourceKey<NoiseGeneratorSettings> NEXUS = NexusRef.createKey("the_nexus", Registries.NOISE_SETTINGS);

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunctions = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noise = context.lookup(Registries.NOISE);
        context.register(NEXUS, (Object)NexusNoiseSettings.nexusNoiseSettings((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
    }

    private static NoiseGeneratorSettings nexusNoiseSettings(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        return new NoiseGeneratorSettings(new NoiseSettings(0, 80, 1, 1), ((Block)NexusBlocks.WARPSLATE.get()).defaultBlockState(), Blocks.WATER.defaultBlockState(), NexusNoiseSettings.createNoiseRouter(densityFunctions, noise, NexusNoiseSettings.createFinalDensity(densityFunctions, noise)), NexusNoiseSettings.createSurfaceRules(), List.of(), 63, true, false, false, false);
    }

    private static NoiseRouter createNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise, DensityFunction finalDensity) {
        DensityFunction depthFunction = NexusNoiseSettings.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld/depth")));
        DensityFunction erosionFunction = NexusNoiseSettings.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld/erosion")));
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), erosionFunction, depthFunction, DensityFunctions.zero(), DensityFunctions.zero(), finalDensity, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static DensityFunction createFinalDensity(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction flatDensity = DensityFunctions.yClampedGradient((int)55, (int)80, (double)1.0, (double)-1.0);
        DensityFunction noiseDensity = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.SURFACE), (double)1.0, (double)0.0);
        return DensityFunctions.add((DensityFunction)flatDensity, (DensityFunction)noiseDensity);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.getOrThrow(key));
    }

    private static SurfaceRules.RuleSource createSurfaceRules() {
        SurfaceRules.RuleSource floorBedrock = NexusNoiseSettings.createBedrockLayerRuleSource(Blocks.BEDROCK, 0, 5);
        SurfaceRules.RuleSource transitionSeaDirt = NexusNoiseSettings.createBedrockLayerRuleSource((Block)NexusBlocks.CHRONOWARPED_DIRT.get(), 57, 63);
        SurfaceRules.ConditionSource seaFloorDirtCondition = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)57), (int)1));
        SurfaceRules.RuleSource seaFloorDirtResult = SurfaceRules.state((BlockState)((Block)NexusBlocks.CHRONOWARPED_DIRT.get()).defaultBlockState());
        SurfaceRules.RuleSource seaFloorDirt = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)seaFloorDirtCondition, (SurfaceRules.RuleSource)seaFloorDirtResult);
        SurfaceRules.RuleSource transitionSeaSand = NexusNoiseSettings.createBedrockLayerRuleSource((Block)NexusBlocks.CHRONOWARPED_SAND.get(), 62, 65);
        SurfaceRules.ConditionSource seaCondition = SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)5, (CaveSurface)CaveSurface.FLOOR);
        SurfaceRules.RuleSource seaResult = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{transitionSeaDirt, seaFloorDirt, transitionSeaSand});
        SurfaceRules.RuleSource sea = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)seaCondition, (SurfaceRules.RuleSource)seaResult);
        SurfaceRules.RuleSource layerTopGrass = NexusNoiseSettings.createSurfaceLayerRuleSource((Block)NexusBlocks.CHRONOWARPED_GRASS.get(), false, 0);
        SurfaceRules.RuleSource layerSurfaceDirt = NexusNoiseSettings.createSurfaceLayerRuleSource((Block)NexusBlocks.CHRONOWARPED_DIRT.get(), true, 0);
        SurfaceRules.RuleSource layerSurfaceCalcite = NexusNoiseSettings.createSurfaceLayerRuleSource(Blocks.CALCITE, true, 10);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{floorBedrock, sea, layerTopGrass, layerSurfaceDirt, layerSurfaceCalcite});
    }

    private static SurfaceRules.ConditionSource createBedrockLayerCondition(int absoluteMin, int absoluteMax) {
        return SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.absolute((int)absoluteMin), (VerticalAnchor)VerticalAnchor.absolute((int)absoluteMax));
    }

    private static SurfaceRules.RuleSource createBedrockLayerRuleSource(Block block, int absoluteMin, int absoluteMax) {
        SurfaceRules.ConditionSource condition = NexusNoiseSettings.createBedrockLayerCondition(absoluteMin, absoluteMax);
        SurfaceRules.RuleSource result = SurfaceRules.state((BlockState)block.defaultBlockState());
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)result);
    }

    private static SurfaceRules.RuleSource createSurfaceLayerRuleSource(Block block, boolean addSurfaceDepth, int secondaryDepthRange) {
        SurfaceRules.ConditionSource condition = SurfaceRules.stoneDepthCheck((int)0, (boolean)addSurfaceDepth, (int)secondaryDepthRange, (CaveSurface)CaveSurface.FLOOR);
        SurfaceRules.RuleSource result = SurfaceRules.state((BlockState)block.defaultBlockState());
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)result);
    }
}

