/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.zoom.Zoom;
import io.github.ennuil.ok_zoomer.zoom.overlays.ZoomOverlay;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    private float translation = 0.0f;
    @Unique
    private float scale = 0.0f;

    @Inject(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/DeltaTracker;getGameTimeDeltaTicks()F")})
    private void injectZoomOverlay(GuiGraphics graphics, DeltaTracker deltaTracker, CallbackInfo ci, @Share(value="cancelOverlay") LocalBooleanRef cancelOverlay) {
        cancelOverlay.set(false);
        if (Zoom.getZoomOverlay() != null) {
            ZoomOverlay overlay = Zoom.getZoomOverlay();
            overlay.tickBeforeRender(deltaTracker);
            if (overlay.getActive()) {
                cancelOverlay.set(overlay.cancelOverlayRendering());
                overlay.renderOverlay(graphics, deltaTracker, Zoom.getTransitionMode());
            }
        }
    }

    @ModifyExpressionValue(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/CameraType;isFirstPerson()Z")})
    private boolean cancelOverlay(boolean original, @Share(value="cancelOverlay") LocalBooleanRef cancelOverlay) {
        return original && !cancelOverlay.get();
    }

    @ModifyExpressionValue(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isScoping()Z")})
    private boolean activateSpyglassOverlay(boolean isScoping) {
        block3: {
            switch ((ConfigEnums.SpyglassModes)OkZoomerConfigManager.CONFIG.features.spyglassMode.value()) {
                case REPLACE_ZOOM: 
                case BOTH: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            return false;
        }
        return isScoping;
    }

    @WrapMethod(method={"render"})
    private void zoomGui(GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        if (((Boolean)OkZoomerConfigManager.CONFIG.features.persistentInterface.value()).booleanValue() || !Zoom.getTransitionMode().getActive()) {
            original.call(new Object[]{graphics, deltaTracker});
        } else {
            float fov = Zoom.getTransitionMode().applyZoom(1.0f, deltaTracker.getGameTimeDeltaPartialTick(true));
            this.translation = 2.0f / (1.0f / fov - 1.0f);
            this.scale = 1.0f / fov;
            graphics.pose().pushPose();
            graphics.pose().translate(-((float)graphics.guiWidth() / this.translation), -((float)graphics.guiHeight() / this.translation), 0.0f);
            graphics.pose().scale(this.scale, this.scale, 1.0f);
            original.call(new Object[]{graphics, deltaTracker});
            graphics.pose().popPose();
        }
    }

    @WrapMethod(method={"renderCrosshair"})
    private void hideCrosshair(GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        boolean persistentInterface = (Boolean)OkZoomerConfigManager.CONFIG.features.persistentInterface.value();
        boolean hideCrosshair = (Boolean)OkZoomerConfigManager.CONFIG.tweaks.hideCrosshair.value();
        if (persistentInterface || hideCrosshair || !Zoom.isTransitionActive()) {
            if (hideCrosshair) {
                float fade = 1.0f - Zoom.getTransitionMode().getFade(deltaTracker.getGameTimeDeltaPartialTick(true));
                RenderSystem.setShaderColor((float)fade, (float)fade, (float)fade, (float)fade);
            }
            original.call(new Object[]{graphics, deltaTracker});
            if (hideCrosshair) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            Matrix4f lastPose = graphics.pose().last().pose();
            graphics.pose().popPose();
            graphics.pose().popPose();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, lastPose.getTranslation((Vector3f)new Vector3f()).z);
            original.call(new Object[]{graphics, deltaTracker});
            graphics.pose().pushPose();
            graphics.pose().translate(-((float)graphics.guiWidth() / this.translation), -((float)graphics.guiHeight() / this.translation), 0.0f);
            graphics.pose().scale(this.scale, this.scale, 1.0f);
        }
    }

    @WrapOperation(method={"method_55807", "lambda$new$6"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/DebugScreenOverlay;render(Lnet/minecraft/client/gui/GuiGraphics;)V")}, allow=1)
    private void ensureDebugHudVisibility(DebugScreenOverlay instance, GuiGraphics graphics, Operation<Void> original, @Local(argsOnly=true) DeltaTracker deltaTracker) {
        if (((Boolean)OkZoomerConfigManager.CONFIG.features.persistentInterface.value()).booleanValue() || !Zoom.getTransitionMode().getActive()) {
            original.call(new Object[]{instance, graphics});
        } else {
            Matrix4f lastPose = graphics.pose().last().pose();
            graphics.pose().popPose();
            graphics.pose().popPose();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, lastPose.getTranslation((Vector3f)new Vector3f()).z);
            original.call(new Object[]{instance, graphics});
            graphics.pose().pushPose();
            graphics.pose().translate(-((float)graphics.guiWidth() / this.translation), -((float)graphics.guiHeight() / this.translation), 0.0f);
            graphics.pose().scale(this.scale, this.scale, 1.0f);
        }
    }
}

