/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.netty.handler.codec.http.websocketx;

import com.github.steveice10.netty.channel.ChannelHandlerContext;
import com.github.steveice10.netty.channel.ChannelPipeline;
import com.github.steveice10.netty.handler.codec.http.HttpHeaders;
import com.github.steveice10.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.github.steveice10.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketCloseFrameHandler;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import com.github.steveice10.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.github.steveice10.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.util.List;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketClientProtocolConfig clientConfig;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    public WebSocketClientProtocolHandler(WebSocketClientProtocolConfig clientConfig) {
        super(ObjectUtil.checkNotNull(clientConfig, "clientConfig").dropPongFrames());
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(clientConfig.webSocketUri(), clientConfig.version(), clientConfig.subprotocol(), clientConfig.allowExtensions(), clientConfig.customHeaders(), clientConfig.maxFramePayloadLength(), clientConfig.performMasking(), clientConfig.allowMaskMismatch(), clientConfig.forceCloseTimeoutMillis(), clientConfig.absoluteUpgradeUrl());
        this.clientConfig = clientConfig;
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, boolean performMasking, boolean allowMaskMismatch) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, performMasking, allowMaskMismatch, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, boolean performMasking, boolean allowMaskMismatch, long handshakeTimeoutMillis) {
        this(WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch), handleCloseFrames, handshakeTimeoutMillis);
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, long handshakeTimeoutMillis) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, WebSocketClientProtocolConfig.DEFAULT.performMasking(), WebSocketClientProtocolConfig.DEFAULT.allowMaskMismatch(), handshakeTimeoutMillis);
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, long handshakeTimeoutMillis) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, WebSocketClientProtocolConfig.DEFAULT.handleCloseFrames(), handshakeTimeoutMillis);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames) {
        this(handshaker, handleCloseFrames, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, long handshakeTimeoutMillis) {
        this(handshaker, handleCloseFrames, WebSocketClientProtocolConfig.DEFAULT.dropPongFrames(), handshakeTimeoutMillis);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, boolean dropPongFrames) {
        this(handshaker, handleCloseFrames, dropPongFrames, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, boolean dropPongFrames, long handshakeTimeoutMillis) {
        super(dropPongFrames);
        this.handshaker = handshaker;
        this.clientConfig = WebSocketClientProtocolConfig.newBuilder().handleCloseFrames(handleCloseFrames).handshakeTimeoutMillis(handshakeTimeoutMillis).build();
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker) {
        this(handshaker, WebSocketClientProtocolConfig.DEFAULT.handshakeTimeoutMillis());
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, long handshakeTimeoutMillis) {
        this(handshaker, WebSocketClientProtocolConfig.DEFAULT.handleCloseFrames(), handshakeTimeoutMillis);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (this.clientConfig.handleCloseFrames() && frame instanceof CloseWebSocketFrame) {
            ctx.close();
            return;
        }
        super.decode(ctx, frame, out);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelPipeline cp = ctx.pipeline();
        if (cp.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker, this.clientConfig.handshakeTimeoutMillis()));
        }
        if (cp.get(Utf8FrameValidator.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
        if (this.clientConfig.sendCloseFrame() != null) {
            cp.addBefore(ctx.name(), WebSocketCloseFrameHandler.class.getName(), new WebSocketCloseFrameHandler(this.clientConfig.sendCloseFrame(), this.clientConfig.forceCloseTimeoutMillis()));
        }
    }

    public static enum ClientHandshakeStateEvent {
        HANDSHAKE_TIMEOUT,
        HANDSHAKE_ISSUED,
        HANDSHAKE_COMPLETE;

    }
}

