/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core;

import com.replaymod.core.SettingsRegistryBackend;
import com.replaymod.core.events.SettingsChangedCallback;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SettingsRegistry {
    private final Map<SettingKey<?>, Object> settings = Collections.synchronizedMap(new LinkedHashMap());
    final SettingsRegistryBackend backend = new SettingsRegistryBackend(this.settings);

    public void register() {
        this.backend.register();
    }

    public void register(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            if ((field.getModifiers() & 9) == 0 || !SettingKey.class.isAssignableFrom(field.getType())) continue;
            try {
                this.register((SettingKey)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void register(SettingKey<?> key) {
        this.settings.put(key, key.getDefault());
        this.backend.register(key);
    }

    public Set<SettingKey<?>> getSettings() {
        return this.settings.keySet();
    }

    public <T> T get(SettingKey<T> key) {
        if (!this.settings.containsKey(key)) {
            throw new IllegalArgumentException("Setting " + String.valueOf(key) + " unknown.");
        }
        return (T)this.settings.get(key);
    }

    public <T> void set(SettingKey<T> key, T value) {
        this.backend.update(key, value);
        this.settings.put(key, value);
        SettingsChangedCallback.EVENT.invoker().onSettingsChanged(this, key);
    }

    public void save() {
        this.backend.save();
    }

    public static interface SettingKey<T> {
        public String getCategory();

        public String getKey();

        public String getDisplayString();

        public T getDefault();
    }

    public static class MultipleChoiceSettingKeys<T>
    extends SettingKeys<T>
    implements MultipleChoiceSettingKey<T> {
        private List<T> choices = Collections.emptyList();

        public MultipleChoiceSettingKeys(String category, String key, String displayString, T defaultValue) {
            super(category, key, displayString, defaultValue);
        }

        public void setChoices(List<T> choices) {
            this.choices = Collections.unmodifiableList(choices);
        }

        @Override
        public List<T> getChoices() {
            return this.choices;
        }
    }

    public static class SettingKeys<T>
    implements SettingKey<T> {
        private final String category;
        private final String key;
        private final String displayString;
        private final T defaultValue;

        public SettingKeys(String category, String key, String displayString, T defaultValue) {
            this.category = category;
            this.key = key;
            this.displayString = displayString;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getDisplayString() {
            return this.displayString;
        }

        @Override
        public T getDefault() {
            return this.defaultValue;
        }
    }

    public static interface MultipleChoiceSettingKey<T>
    extends SettingKey<T> {
        public List<T> getChoices();
    }
}

