/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.events.SettingsChangedCallback;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class SettingsRegistryBackend {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<SettingsRegistry.SettingKey<?>, Object> settings;
    private final Path configFile;

    SettingsRegistryBackend(Map<SettingsRegistry.SettingKey<?>, Object> settings) {
        this.configFile = MCVer.getMinecraft().gameDirectory.toPath().resolve("config/replaymod.json");
        this.settings = settings;
    }

    public void register() {
        this.load(true);
        try {
            this.registerWatcher();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to setup file watcher for {}, live-reloading is disabled. Cause: {}", (Object)this.configFile, (Object)e);
        }
    }

    private void load(boolean createIfMissingOrBroken) {
        String config;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try {
                config = new String(Files.readAllBytes(this.configFile), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else {
            if (createIfMissingOrBroken) {
                this.save();
            }
            return;
        }
        Gson gson = new Gson();
        JsonObject root = (JsonObject)gson.fromJson(config, JsonObject.class);
        if (root == null) {
            LOGGER.error("Config file {} appears corrupted: {}", (Object)this.configFile, (Object)config);
            if (createIfMissingOrBroken) {
                this.save();
            }
            return;
        }
        for (Map.Entry<SettingsRegistry.SettingKey<?>, Object> entry : this.settings.entrySet()) {
            JsonElement valueElem;
            SettingsRegistry.SettingKey<?> key = entry.getKey();
            JsonElement category = root.get(key.getCategory());
            if (category == null || !category.isJsonObject() || (valueElem = category.getAsJsonObject().get(key.getKey())) == null || !valueElem.isJsonPrimitive()) continue;
            JsonPrimitive value = valueElem.getAsJsonPrimitive();
            if (key.getDefault() instanceof Boolean && value.isBoolean()) {
                entry.setValue(value.getAsBoolean());
            }
            if (key.getDefault() instanceof Integer && value.isNumber()) {
                entry.setValue(value.getAsNumber().intValue());
            }
            if (key.getDefault() instanceof Double && value.isNumber()) {
                entry.setValue(value.getAsNumber().doubleValue());
            }
            if (!(key.getDefault() instanceof String) || !value.isString()) continue;
            String valueStr = value.getAsString();
            if (entry instanceof SettingsRegistry.MultipleChoiceSettingKey) {
                List choices = ((SettingsRegistry.MultipleChoiceSettingKey)((Object)entry)).getChoices();
                if (choices.stream().noneMatch(valueStr::equals)) continue;
            }
            entry.setValue(valueStr);
        }
    }

    private void registerWatcher() throws IOException {
        WatchService watchService = this.configFile.getFileSystem().newWatchService();
        this.configFile.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        Thread thread = new Thread(() -> {
            WatchKey nextKey;
            do {
                try {
                    nextKey = watchService.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                for (WatchEvent<?> event : nextKey.pollEvents()) {
                    Path fileName;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !(fileName = (Path)event.context()).equals(this.configFile.getFileName())) continue;
                    Minecraft.getInstance().tell(this::reload);
                }
            } while (nextKey.reset());
        });
        thread.setName("replaymod-config-watcher");
        thread.setDaemon(true);
        thread.start();
    }

    private void reload() {
        this.load(false);
        SettingsRegistry settingsRegistry = ReplayMod.instance.getSettingsRegistry();
        for (SettingsRegistry.SettingKey<?> key : this.settings.keySet()) {
            SettingsChangedCallback.EVENT.invoker().onSettingsChanged(settingsRegistry, key);
        }
    }

    public void register(SettingsRegistry.SettingKey<?> key) {
    }

    public <T> void update(SettingsRegistry.SettingKey<T> key, T value) {
    }

    public void save() {
        JsonObject root = new JsonObject();
        for (Map.Entry<SettingsRegistry.SettingKey<?>, Object> entry : this.settings.entrySet()) {
            Object value;
            SettingsRegistry.SettingKey<?> key = entry.getKey();
            JsonObject category = root.getAsJsonObject(key.getCategory());
            if (category == null) {
                category = new JsonObject();
                root.add(key.getCategory(), (JsonElement)category);
            }
            if ((value = entry.getValue()) instanceof Boolean) {
                category.addProperty(key.getKey(), (Boolean)value);
            }
            if (value instanceof Number) {
                category.addProperty(key.getKey(), (Number)value);
            }
            if (!(value instanceof String)) continue;
            category.addProperty(key.getKey(), (String)value);
            if (!(key instanceof SettingsRegistry.MultipleChoiceSettingKey)) continue;
            List choices = ((SettingsRegistry.MultipleChoiceSettingKey)key).getChoices();
            JsonArray array = new JsonArray();
            for (String choice : choices) {
                array.add(choice);
            }
            category.add(key.getKey() + "_valid_values", (JsonElement)array);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String config = gson.toJson((JsonElement)root);
        try {
            Utils.ensureDirectoryExists(this.configFile.getParent());
            Files.write(this.configFile, config.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

