/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.utils;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class Restrictions {
    public static final ResourceLocation PLUGIN_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"replaymod", (String)"restrict");
    private boolean noXray;
    private boolean noNoclip;
    private boolean onlyFirstPerson;
    private boolean onlyRecordingPlayer;
    public static final CustomPacketPayload.Type<Payload> ID = new CustomPacketPayload.Type(PLUGIN_CHANNEL);
    public static final StreamCodec<? super FriendlyByteBuf, Payload> CODEC = StreamCodec.of((buf, payload) -> buf.writeBytes(payload.bytes()), buf -> {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return new Payload(bytes);
    });

    public String handle(ClientboundCustomPayloadPacket packet) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])((Payload)packet.payload()).bytes()));
        if (buffer.isReadable()) {
            String name = buffer.readUtf(64);
            boolean active = buffer.readBoolean();
            return name;
        }
        return null;
    }

    public boolean isNoXray() {
        return this.noXray;
    }

    public boolean isNoNoclip() {
        return this.noNoclip;
    }

    public boolean isOnlyFirstPerson() {
        return this.onlyFirstPerson;
    }

    public boolean isOnlyRecordingPlayer() {
        return this.onlyRecordingPlayer;
    }

    public record Payload(byte[] bytes) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

