/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.versions;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.replaymod.core.mixin.GuiScreenAccessor;
import com.replaymod.render.blend.mixin.ParticleAccessor;
import com.replaymod.render.mixin.MainWindowAccessor;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector2f;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MCVer {
    private static Boolean hasOptifine;

    public static int getProtocolVersion() {
        return SharedConstants.getCurrentVersion().getProtocolVersion();
    }

    public static ConnectionProtocol asMc(State state) {
        switch (state) {
            case HANDSHAKE: {
                return ConnectionProtocol.HANDSHAKING;
            }
            case STATUS: {
                return ConnectionProtocol.STATUS;
            }
            case LOGIN: {
                return ConnectionProtocol.LOGIN;
            }
            case CONFIGURATION: {
                return ConnectionProtocol.CONFIGURATION;
            }
            case PLAY: {
                return ConnectionProtocol.PLAY;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)state));
    }

    public static State fromMc(ConnectionProtocol mcState) {
        switch (mcState) {
            case HANDSHAKING: {
                return State.HANDSHAKE;
            }
            case STATUS: {
                return State.STATUS;
            }
            case LOGIN: {
                return State.LOGIN;
            }
            case CONFIGURATION: {
                return State.CONFIGURATION;
            }
            case PLAY: {
                return State.PLAY;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(mcState));
    }

    public static PacketTypeRegistry getPacketTypeRegistry(ConnectionProtocol state) {
        return MCVer.getPacketTypeRegistry(MCVer.fromMc(state));
    }

    public static PacketTypeRegistry getPacketTypeRegistry(State state) {
        return PacketTypeRegistry.get(ProtocolVersion.getProtocol(MCVer.getProtocolVersion()), state);
    }

    public static PacketTypeRegistry getPacketTypeRegistry(boolean loginPhase) {
        return PacketTypeRegistry.get(ProtocolVersion.getProtocol(MCVer.getProtocolVersion()), loginPhase ? State.LOGIN : State.PLAY);
    }

    public static void resizeMainWindow(Minecraft mc, int width, int height) {
        Window window = mc.getWindow();
        MainWindowAccessor mainWindow = (MainWindowAccessor)window;
        mainWindow.invokeOnFramebufferResize(window.getWindow(), width, height);
    }

    public static <T> void addCallback(CompletableFuture<T> future, Consumer<T> success, Consumer<Throwable> failure) {
        ((CompletableFuture)future.thenAccept((Consumer)success)).exceptionally(throwable -> {
            failure.accept((Throwable)throwable);
            return null;
        });
    }

    public static List<VertexFormatElement> getElements(VertexFormat vertexFormat) {
        return vertexFormat.getElements();
    }

    public static Minecraft getMinecraft() {
        return Minecraft.getInstance();
    }

    public static void addButton(Screen screen, Button button) {
        GuiScreenAccessor acc = (GuiScreenAccessor)screen;
        acc.invokeAddButton(button);
    }

    public static Optional<AbstractWidget> findButton(Iterable<? extends GuiEventListener> buttonList, String text, int id) {
        MutableComponent message = Component.translatable((String)text);
        for (GuiEventListener guiEventListener : buttonList) {
            Optional<AbstractWidget> button;
            if (guiEventListener instanceof ContainerEventHandler && (button = MCVer.findButton(((ContainerEventHandler)guiEventListener).children(), text, id)).isPresent()) {
                return button;
            }
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget b = (AbstractWidget)guiEventListener;
            if (message.equals((Object)b.getMessage())) {
                return Optional.of(b);
            }
            if (b.getMessage() == null || !b.getMessage().plainCopy().equals((Object)message)) continue;
            return Optional.of(b);
        }
        return Optional.empty();
    }

    public static void processKeyBinds() {
        ((MinecraftMethodAccessor)MCVer.getMinecraft()).replayModProcessKeyBinds();
    }

    public static long milliTime() {
        return Util.getMillis();
    }

    public static Vec3 getPosition(Particle particle, float partialTicks) {
        ParticleAccessor acc = (ParticleAccessor)particle;
        double x = acc.getXo() + (acc.getPosX() - acc.getXo()) * (double)partialTicks;
        double y = acc.getYo() + (acc.getPosY() - acc.getYo()) * (double)partialTicks;
        double z = acc.getZo() + (acc.getPosZ() - acc.getZo()) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    public static void openFile(File file) {
        Util.getPlatform().openFile(file);
    }

    public static void openURL(URI url) {
        Util.getPlatform().openUri(url);
    }

    public static void pushMatrix() {
        RenderSystem.getModelViewStack().pushMatrix();
    }

    public static void popMatrix() {
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static Quaternionf quaternion(float angle, org.joml.Vector3f axis) {
        return new Quaternionf().fromAxisAngleDeg(axis.x, axis.y, axis.z, angle);
    }

    public static Matrix4f ortho(float left, float right, float top, float bottom, float zNear, float zFar) {
        return new Matrix4f().ortho(left, right, bottom, top, zNear, zFar);
    }

    public static void emitLine(PoseStack matrixStack, BufferBuilder buffer, Vector2f p1, Vector2f p2, int color) {
        MCVer.emitLine(matrixStack, buffer, new Vector3f(p1.x, p1.y, 0.0f), new Vector3f(p2.x, p2.y, 0.0f), color);
    }

    public static void emitLine(PoseStack matrixStack, BufferBuilder buffer, Vector3f p1, Vector3f p2, int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        Vector3f n = Vector3f.sub((Vector3f)p2, (Vector3f)p1, null);
        buffer.addVertex(matrixStack.last().pose(), p1.x, p1.y, p1.z).setColor(r, g, b, a).setNormal(n.x, n.y, n.z);
        buffer.addVertex(matrixStack.last().pose(), p2.x, p2.y, p2.z).setColor(r, g, b, a).setNormal(n.x, n.y, n.z);
    }

    public static void bindTexture(ResourceLocation id) {
        de.johni0702.minecraft.gui.versions.MCVer.bindTexture(id);
    }

    public static boolean hasOptifine() {
        if (hasOptifine == null) {
            try {
                Class.forName("Config");
                hasOptifine = true;
            }
            catch (ClassNotFoundException e) {
                hasOptifine = false;
            }
        }
        return hasOptifine;
    }

    public static interface MinecraftMethodAccessor {
        public void replayModProcessKeyBinds();

        public void replayModExecuteTaskQueue();
    }

    public static abstract class Keyboard {
        public static final int KEY_LCONTROL = 341;
        public static final int KEY_LSHIFT = 340;
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_UP = 265;
        public static final int KEY_DOWN = 264;
        public static final int KEY_LEFT = 263;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_BACK = 259;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RETURN = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_F1 = 290;
        public static final int KEY_A = 65;
        public static final int KEY_B = 66;
        public static final int KEY_C = 67;
        public static final int KEY_D = 68;
        public static final int KEY_E = 69;
        public static final int KEY_F = 70;
        public static final int KEY_G = 71;
        public static final int KEY_H = 72;
        public static final int KEY_I = 73;
        public static final int KEY_J = 74;
        public static final int KEY_K = 75;
        public static final int KEY_L = 76;
        public static final int KEY_M = 77;
        public static final int KEY_N = 78;
        public static final int KEY_O = 79;
        public static final int KEY_P = 80;
        public static final int KEY_Q = 81;
        public static final int KEY_R = 82;
        public static final int KEY_S = 83;
        public static final int KEY_T = 84;
        public static final int KEY_U = 85;
        public static final int KEY_V = 86;
        public static final int KEY_W = 87;
        public static final int KEY_X = 88;
        public static final int KEY_Y = 89;
        public static final int KEY_Z = 90;

        public static boolean hasControlDown() {
            return Screen.hasControlDown();
        }

        public static boolean isKeyDown(int keyCode) {
            return InputConstants.isKeyDown((long)MCVer.getMinecraft().getWindow().getWindow(), (int)keyCode);
        }
    }
}

