/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.editor.gui;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.filter.DimensionTracker;
import com.replaymod.replaystudio.filter.SquashFilter;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.stream.IteratorStream;
import com.replaymod.replaystudio.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MarkerProcessor {
    public static final String MARKER_NAME_START_CUT = "_RM_START_CUT";
    public static final String MARKER_NAME_END_CUT = "_RM_END_CUT";
    public static final String MARKER_NAME_SPLIT = "_RM_SPLIT";

    private static boolean hasWork(Path path) throws IOException {
        try (ReplayFile inputReplayFile = ReplayMod.instance.files.open(path);){
            boolean bl = inputReplayFile.getMarkers().or(HashSet::new).stream().anyMatch(m -> m.getName() != null && m.getName().startsWith("_RM_"));
            return bl;
        }
    }

    public static boolean producesAnyOutput(ReplayFile replayFile) throws IOException {
        return !MarkerProcessor.getOutputSuffixes(replayFile).isEmpty();
    }

    private static List<String> getOutputSuffixes(ReplayFile inputReplayFile) throws IOException {
        List markers = inputReplayFile.getMarkers().or(HashSet::new).stream().sorted(Comparator.comparing(Marker::getTime)).collect(Collectors.toList());
        int nextSuffix = 0;
        ArrayList<String> suffixes = new ArrayList<String>();
        OutputState state = OutputState.Writing;
        for (Marker marker : markers) {
            if (MARKER_NAME_START_CUT.equals(marker.getName())) {
                if (marker.getTime() == 0) {
                    state = OutputState.NotYetWriting;
                    continue;
                }
                state = OutputState.Paused;
                continue;
            }
            if (MARKER_NAME_END_CUT.equals(marker.getName())) {
                state = OutputState.Writing;
                continue;
            }
            if (!MARKER_NAME_SPLIT.equals(marker.getName())) continue;
            switch (state.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    suffixes.add("_" + nextSuffix++);
                    state = OutputState.Writing;
                    break;
                }
                case 2: {
                    suffixes.add("_" + nextSuffix++);
                    state = OutputState.NotYetWriting;
                }
            }
        }
        if (state != OutputState.NotYetWriting) {
            suffixes.add("_" + nextSuffix);
        }
        if (suffixes.size() == 1) {
            return Collections.singletonList("");
        }
        return suffixes;
    }

    public static List<Pair<Path, ReplayMetaData>> apply(Path path, Consumer<Float> progress) throws IOException {
        ReplayMod mod = ReplayMod.instance;
        if (!MarkerProcessor.hasWork(path)) {
            ReplayMetaData metaData;
            try (ReplayFile inputReplayFile = mod.files.open(path);){
                metaData = inputReplayFile.getMetaData();
            }
            return Collections.singletonList(Pair.of((Object)path, (Object)metaData));
        }
        String replayName = FilenameUtils.getBaseName((String)path.getFileName().toString());
        int splitCounter = 0;
        PacketTypeRegistry registry = MCVer.getPacketTypeRegistry(State.LOGIN);
        DimensionTracker dimensionTracker = new DimensionTracker();
        SquashFilter squashFilter = new SquashFilter(null, null, null);
        ArrayList<Pair<Path, ReplayMetaData>> outputPaths = new ArrayList<Pair<Path, ReplayMetaData>>();
        Path rawFolder = ReplayMod.instance.folders.getRawReplayFolder();
        Path inputPath = rawFolder.resolve(path.getFileName());
        int i = 1;
        while (Files.exists(inputPath, new LinkOption[0])) {
            inputPath = inputPath.resolveSibling(replayName + "." + i + ".mcpr");
            ++i;
        }
        Files.move(path, inputPath, new CopyOption[0]);
        try (ReplayFile inputReplayFile = mod.files.open(inputPath);){
            List markers = inputReplayFile.getMarkers().or(HashSet::new).stream().sorted(Comparator.comparing(Marker::getTime)).collect(Collectors.toList());
            Iterator markerIterator = markers.iterator();
            Iterator<String> outputFileSuffixes = MarkerProcessor.getOutputSuffixes(inputReplayFile).iterator();
            boolean anySplit = markers.stream().anyMatch(m -> MARKER_NAME_SPLIT.equals(m.getName()));
            int inputDuration = inputReplayFile.getMetaData().getDuration();
            ReplayInputStream replayInputStream = inputReplayFile.getPacketData(registry);
            int timeOffset = 0;
            SquashFilter cutFilter = null;
            int startCutOffset = 0;
            PacketData nextPacket = replayInputStream.readPacket();
            Marker nextMarker = (Marker)markerIterator.next();
            while (nextPacket != null && outputFileSuffixes.hasNext()) {
                Path outputPath = path.resolveSibling(replayName + outputFileSuffixes.next() + ".mcpr");
                ReplayFile outputReplayFile = mod.files.open(null, outputPath);
                try {
                    long duration = 0L;
                    HashSet<Marker> outputMarkers = new HashSet<Marker>();
                    ReplayMetaData metaData = inputReplayFile.getMetaData();
                    metaData.setDate(metaData.getDate() + (long)timeOffset);
                    try (ReplayOutputStream replayOutputStream = outputReplayFile.writePacketData();){
                        if (cutFilter != null) {
                            cutFilter.release();
                            cutFilter = squashFilter.copy();
                        } else if (splitCounter > 0) {
                            ArrayList packets = new ArrayList();
                            squashFilter.copy().onEnd(new IteratorStream(packets.listIterator(), (StreamFilter)null), timeOffset);
                            for (Object packet : packets) {
                                replayOutputStream.write(0L, ((PacketData)packet).getPacket());
                            }
                        }
                        boolean hasFurtherOutputs = outputFileSuffixes.hasNext();
                        while (nextPacket != null) {
                            if (nextMarker != null && nextPacket.getTime() >= (long)nextMarker.getTime()) {
                                if (MARKER_NAME_START_CUT.equals(nextMarker.getName())) {
                                    if (cutFilter != null) {
                                        cutFilter.release();
                                    }
                                    startCutOffset = nextMarker.getTime();
                                    cutFilter = new SquashFilter(dimensionTracker);
                                } else if (MARKER_NAME_END_CUT.equals(nextMarker.getName())) {
                                    timeOffset += nextMarker.getTime() - startCutOffset;
                                    if (cutFilter != null) {
                                        Object packet;
                                        ArrayList packets = new ArrayList();
                                        cutFilter.onEnd(new IteratorStream(packets.listIterator(), (StreamFilter)null), nextMarker.getTime());
                                        packet = packets.iterator();
                                        while (packet.hasNext()) {
                                            PacketData packet2 = (PacketData)packet.next();
                                            replayOutputStream.write(nextMarker.getTime() - timeOffset, packet2.getPacket());
                                        }
                                        cutFilter = null;
                                    }
                                } else {
                                    if (MARKER_NAME_SPLIT.equals(nextMarker.getName())) {
                                        ++splitCounter;
                                        startCutOffset = timeOffset = nextMarker.getTime();
                                        nextMarker = markerIterator.hasNext() ? (Marker)markerIterator.next() : null;
                                        break;
                                    }
                                    nextMarker.setTime(nextMarker.getTime() - timeOffset);
                                    outputMarkers.add(nextMarker);
                                }
                                nextMarker = markerIterator.hasNext() ? (Marker)markerIterator.next() : null;
                                continue;
                            }
                            dimensionTracker.onPacket(null, nextPacket);
                            if (hasFurtherOutputs) {
                                squashFilter.onPacket(null, nextPacket);
                            }
                            if (cutFilter != null) {
                                cutFilter.onPacket(null, nextPacket);
                            } else {
                                replayOutputStream.write(nextPacket.getTime() - (long)timeOffset, nextPacket.getPacket().copy());
                                duration = nextPacket.getTime() - (long)timeOffset;
                            }
                            nextPacket.release();
                            nextPacket = replayInputStream.readPacket();
                            if (nextPacket != null) {
                                progress.accept(Float.valueOf((float)nextPacket.getTime() / (float)inputDuration));
                                continue;
                            }
                            progress.accept(Float.valueOf(1.0f));
                        }
                    }
                    metaData.setDuration((int)duration);
                    outputReplayFile.writeMetaData(registry, metaData);
                    outputReplayFile.writeMarkers(outputMarkers);
                    outputReplayFile.writeModInfo(inputReplayFile.getModInfo());
                    Map<Integer, String> resourcePackIndex = inputReplayFile.getResourcePackIndex();
                    if (resourcePackIndex != null) {
                        outputReplayFile.writeResourcePackIndex(resourcePackIndex);
                        for (String hash : resourcePackIndex.values()) {
                            InputStream in = inputReplayFile.getResourcePack(hash).get();
                            try (OutputStream out = outputReplayFile.writeResourcePack(hash);){
                                Utils.copy(in, out);
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                            }
                        }
                    }
                    outputReplayFile.save();
                    outputPaths.add((Pair<Path, ReplayMetaData>)Pair.of((Object)outputPath, (Object)metaData));
                }
                finally {
                    if (outputReplayFile == null) continue;
                    outputReplayFile.close();
                }
            }
            squashFilter.release();
            if (cutFilter != null) {
                cutFilter.release();
            }
        }
        return outputPaths;
    }

    private static enum OutputState {
        NotYetWriting,
        Writing,
        Paused;

    }
}

