/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.events.PostRenderCallback;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.mixin.SimpleOptionAccessor;
import com.replaymod.extras.Extra;
import com.replaymod.extras.Setting;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replay.gui.overlay.GuiReplayOverlay;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiImage;
import de.johni0702.minecraft.gui.element.IGuiImage;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class FullBrightness
extends EventRegistrations
implements Extra {
    private ReplayMod core;
    private ReplayModReplay module;
    private final IGuiImage indicator = (IGuiImage)((GuiImage)new GuiImage().setTexture(ReplayMod.TEXTURE, 90, 20, 19, 16)).setSize(19, 16);
    private Minecraft mc;
    private boolean active;
    private double originalGamma;

    public FullBrightness() {
        this.on(PreRenderCallback.EVENT, this::preRender);
        this.on(PostRenderCallback.EVENT, this::postRender);
        this.on(ReplayOpenedCallback.EVENT, replayHandler -> this.updateIndicator(replayHandler.getOverlay()));
    }

    @Override
    public void register(final ReplayMod mod) throws Exception {
        this.core = mod;
        this.module = ReplayModReplay.instance;
        this.mc = mod.getMinecraft();
        mod.getKeyBindingRegistry().registerKeyBinding("replaymod.input.lighting", 90, new Runnable(){

            @Override
            public void run() {
                FullBrightness.this.active = !FullBrightness.this.active;
                mod.getMinecraft().gameRenderer.tick();
                ReplayHandler replayHandler = FullBrightness.this.module.getReplayHandler();
                if (replayHandler != null) {
                    FullBrightness.this.updateIndicator(replayHandler.getOverlay());
                }
            }
        }, true);
        this.register();
    }

    public Type getType() {
        String str = this.core.getSettingsRegistry().get(Setting.FULL_BRIGHTNESS);
        for (Type type : Type.values()) {
            if (!type.toString().equals(str)) continue;
            return type;
        }
        return Type.Gamma;
    }

    private void preRender() {
        if (this.active && this.module.getReplayHandler() != null) {
            Type type = this.getType();
            if (type == Type.Gamma || type == Type.Both) {
                this.originalGamma = (Double)this.mc.options.gamma().get();
                ((SimpleOptionAccessor)this.mc.options.gamma()).setRawValue(1000.0);
            }
            if ((type == Type.NightVision || type == Type.Both) && this.mc.player != null) {
                this.mc.player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, Integer.MAX_VALUE));
            }
        }
    }

    private void postRender() {
        if (this.active && this.module.getReplayHandler() != null) {
            Type type = this.getType();
            if (type == Type.Gamma || type == Type.Both) {
                ((SimpleOptionAccessor)this.mc.options.gamma()).setRawValue(this.originalGamma);
            }
            if ((type == Type.NightVision || type == Type.Both) && this.mc.player != null) {
                this.mc.player.removeEffect(MobEffects.NIGHT_VISION);
            }
        }
    }

    private void updateIndicator(GuiReplayOverlay overlay) {
        if (this.active) {
            overlay.statusIndicatorPanel.addElements(new HorizontalLayout.Data(1.0), new GuiElement[]{this.indicator});
        } else {
            overlay.statusIndicatorPanel.removeElement(this.indicator);
        }
    }

    static enum Type {
        Gamma,
        NightVision,
        Both;


        public String toString() {
            return "replaymod.gui.settings.fullbrightness." + this.name().toLowerCase();
        }
    }
}

