/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras;

import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.ReplayMod;
import com.replaymod.extras.Extra;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replay.gui.overlay.GuiReplayOverlay;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.GridLayout;
import de.johni0702.minecraft.gui.layout.LayoutData;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public class HotkeyButtons
extends EventRegistrations
implements Extra {
    private ReplayMod mod;

    public HotkeyButtons() {
        this.on(ReplayOpenedCallback.EVENT, replayHandler -> new Gui(this.mod, replayHandler.getOverlay()));
    }

    @Override
    public void register(ReplayMod mod) {
        this.mod = mod;
        this.register();
    }

    public static final class Gui {
        private final GuiButton toggleButton;
        private final GridLayout panelLayout;
        private final GuiPanel panel;
        private boolean open;

        public Gui(ReplayMod mod, GuiReplayOverlay overlay) {
            this.toggleButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton(overlay).setSize(20, 20)).setTexture(ReplayMod.TEXTURE, 256)).setSpriteUV(0, 120)).onClick(new Runnable(){

                @Override
                public void run() {
                    open = !open;
                }
            });
            this.panelLayout = new GridLayout().setSpacingX(5).setSpacingY(5).setColumns(1);
            this.panel = (GuiPanel)new GuiPanel(overlay){

                @Override
                public Collection<GuiElement> getChildren() {
                    return open ? super.getChildren() : Collections.emptyList();
                }

                @Override
                public Map<GuiElement, LayoutData> getElements() {
                    return open ? super.getElements() : Collections.emptyMap();
                }
            }.setLayout(this.panelLayout);
            KeyBindingRegistry keyBindingRegistry = mod.getKeyBindingRegistry();
            keyBindingRegistry.getBindings().values().stream().sorted(Comparator.comparing(it -> I18n.get((String)it.name, (Object[])new Object[0]))).forEachOrdered(keyBinding -> {
                final GuiButton button = (GuiButton)new GuiButton(this, (KeyBindingRegistry.Binding)keyBinding){
                    final /* synthetic */ KeyBindingRegistry.Binding val$keyBinding;
                    {
                        this.val$keyBinding = binding;
                    }

                    @Override
                    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
                        this.setLabel(this.val$keyBinding.isBound() ? this.val$keyBinding.getBoundKey() : "");
                        if (this.val$keyBinding.supportsAutoActivation()) {
                            this.setTooltip((GuiElement)new GuiTooltip().setText(new String[]{I18n.get((String)"replaymod.gui.ingame.autoactivating", (Object[])new Object[0]), I18n.get((String)("replaymod.gui.ingame.autoactivating." + (this.val$keyBinding.isAutoActivating() ? "disable" : "enable")), (Object[])new Object[0])}));
                            this.setLabelColor(this.val$keyBinding.isAutoActivating() ? 65280 : 0xE0E0E0);
                        }
                        super.draw(renderer, size, renderInfo);
                    }
                }.onClick(() -> {
                    if (keyBinding.supportsAutoActivation() && Screen.hasControlDown()) {
                        keyBinding.setAutoActivating(!keyBinding.isAutoActivating());
                    } else {
                        keyBinding.trigger();
                    }
                });
                final GuiLabel label = (GuiLabel)new GuiLabel().setI18nText(keyBinding.name, new Object[0]);
                this.panel.addElements(null, new GuiElement[]{((GuiPanel)((GuiPanel)new GuiPanel().setLayout(new CustomLayout<GuiPanel>(this){

                    @Override
                    protected void layout(GuiPanel container, int width, int height) {
                        this.width(button, Math.max(10, this.width(button)) + 10);
                        this.height(button, 20);
                        int textWidth = this.width(label);
                        this.x(label, this.width(button) + 4);
                        this.width(label, width - this.x(label));
                        if (textWidth > width - this.x(label)) {
                            this.height(label, this.height(label) * 2);
                        }
                        this.y(label, (height - this.height(label)) / 2);
                    }
                })).addElements(null, new GuiElement[]{button, label})).setSize(150, 20)});
            });
            overlay.setLayout(new CustomLayout<GuiReplayOverlay>(overlay.getLayout()){

                @Override
                protected void layout(GuiReplayOverlay container, int width, int height) {
                    panelLayout.setColumns(Math.max(1, (width - 10) / 155));
                    this.size(panel, panel.getMinSize());
                    this.pos(toggleButton, 5, height - 25);
                    this.pos(panel, 5, this.y(toggleButton) - 5 - this.height(panel));
                }
            });
        }
    }
}

