/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras.playeroverview;

import com.replaymod.extras.playeroverview.PlayerOverview;
import com.replaymod.replay.ReplayModReplay;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiClickable;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.GuiVerticalList;
import de.johni0702.minecraft.gui.element.GuiCheckbox;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiImage;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.IGuiCheckbox;
import de.johni0702.minecraft.gui.function.Closeable;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;

public class PlayerOverviewGui
extends GuiScreen
implements Closeable {
    protected static final int ENTRY_WIDTH = 200;
    public final GuiPanel contentPanel = (GuiPanel)new GuiPanel(this).setBackgroundColor(Colors.DARK_TRANSPARENT);
    public final GuiLabel spectateLabel = (GuiLabel)new GuiLabel(this.contentPanel).setI18nText("replaymod.gui.playeroverview.spectate", new Object[0]);
    public final GuiLabel visibleLabel = (GuiLabel)new GuiLabel(this.contentPanel).setI18nText("replaymod.gui.playeroverview.visible", new Object[0]);
    public final GuiVerticalList playersScrollable = (GuiVerticalList)((GuiVerticalList)new GuiVerticalList(this.contentPanel).setDrawSlider(true)).setDrawShadow(true);
    public final GuiCheckbox saveCheckbox = (GuiCheckbox)((GuiCheckbox)new GuiCheckbox(this.contentPanel).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.playeroverview.remembersettings.description", new Object[0]))).setI18nLabel("replaymod.gui.playeroverview.remembersettings", new Object[0]);
    public final GuiCheckbox checkAll = (GuiCheckbox)((GuiCheckbox)((GuiCheckbox)new GuiCheckbox(this.contentPanel){

        @Override
        public void onClick() {
            PlayerOverviewGui.this.playersScrollable.invokeAll(IGuiCheckbox.class, e -> e.setChecked(true));
        }
    }.setLabel("")).setChecked(true)).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.playeroverview.showall", new Object[0]));
    public final GuiCheckbox uncheckAll = (GuiCheckbox)((GuiCheckbox)((GuiCheckbox)new GuiCheckbox(this.contentPanel){

        @Override
        public void onClick() {
            PlayerOverviewGui.this.playersScrollable.invokeAll(IGuiCheckbox.class, e -> e.setChecked(false));
        }
    }.setLabel("")).setChecked(false)).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.playeroverview.hideall", new Object[0]));
    private final PlayerOverview extra;

    public PlayerOverviewGui(final PlayerOverview extra, List<Player> players) {
        this.setBackground(AbstractGuiScreen.Background.NONE);
        this.setTitle((GuiLabel)new GuiLabel().setI18nText("replaymod.input.playeroverview", new Object[0]));
        this.setLayout(new CustomLayout<GuiScreen>(){

            @Override
            protected void layout(GuiScreen container, int width, int height) {
                this.size(PlayerOverviewGui.this.contentPanel, 230, height - 40);
                this.pos(PlayerOverviewGui.this.contentPanel, width / 2 - this.width(PlayerOverviewGui.this.contentPanel) / 2, 20);
            }
        });
        this.contentPanel.setLayout(new CustomLayout<GuiPanel>(){

            @Override
            protected void layout(GuiPanel container, int width, int height) {
                this.pos(PlayerOverviewGui.this.spectateLabel, 10, 10);
                this.pos(PlayerOverviewGui.this.visibleLabel, width - 10 - this.width(PlayerOverviewGui.this.visibleLabel), 10);
                this.pos(PlayerOverviewGui.this.playersScrollable, 10, this.y(PlayerOverviewGui.this.spectateLabel) + this.height(PlayerOverviewGui.this.spectateLabel) + 5);
                this.size(PlayerOverviewGui.this.playersScrollable, width - 10 - 5, height - 15 - this.height(PlayerOverviewGui.this.saveCheckbox) - this.y(PlayerOverviewGui.this.playersScrollable));
                this.pos(PlayerOverviewGui.this.saveCheckbox, 10, height - 10 - this.height(PlayerOverviewGui.this.saveCheckbox));
                this.pos(PlayerOverviewGui.this.uncheckAll, width - this.width(PlayerOverviewGui.this.uncheckAll) - 8, height - this.height(PlayerOverviewGui.this.uncheckAll) - 10);
                this.pos(PlayerOverviewGui.this.checkAll, this.x(PlayerOverviewGui.this.uncheckAll) - 3 - this.width(PlayerOverviewGui.this.checkAll), this.y(PlayerOverviewGui.this.uncheckAll));
            }
        });
        this.extra = extra;
        Collections.sort(players, new PlayerComparator());
        for (final Player p : players) {
            if (!(p instanceof AbstractClientPlayer)) continue;
            final ResourceLocation texture = ((AbstractClientPlayer)p).getSkin().texture();
            final GuiClickable panel = (GuiClickable)((GuiClickable)((GuiClickable)new GuiClickable().setLayout(new HorizontalLayout().setSpacing(2))).addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{new GuiImage(this){

                @Override
                public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
                    renderer.bindTexture(texture);
                    renderer.drawTexturedRect(0, 0, 8, 8, 16, 16, 8, 8, 64, 64);
                    if (p.isModelPartShown(PlayerModelPart.HAT)) {
                        renderer.drawTexturedRect(0, 0, 40, 8, size.getWidth(), size.getHeight(), 8, 8, 64, 64);
                    }
                }
            }.setSize(16, 16), ((GuiLabel)new GuiLabel().setText(p.getName().getString())).setColor(PlayerOverviewGui.isSpectator(p) ? Colors.DKGREY : Colors.WHITE)})).onClick(new Runnable(){

                @Override
                public void run() {
                    ReplayModReplay.instance.getReplayHandler().spectateEntity((Entity)p);
                }
            });
            final GuiCheckbox checkbox = new GuiCheckbox(this){

                @Override
                public GuiCheckbox setChecked(boolean checked) {
                    extra.setHidden(p.getUUID(), !checked);
                    return (GuiCheckbox)super.setChecked(checked);
                }
            }.setChecked(!extra.isHidden(p.getUUID()));
            ((GuiPanel)new GuiPanel(this.playersScrollable.getListPanel()).setLayout(new CustomLayout<GuiPanel>(this){

                @Override
                protected void layout(GuiPanel container, int width, int height) {
                    this.pos(panel, 5, 0);
                    this.pos(checkbox, width - this.width(checkbox) - 5, height / 2 - this.height(checkbox) / 2);
                }

                @Override
                public ReadableDimension calcMinSize(GuiContainer<?> container) {
                    return new Dimension(200, panel.getMinSize().getHeight());
                }
            })).addElements(null, new GuiElement[]{panel, checkbox});
        }
        ((GuiCheckbox)this.saveCheckbox.setChecked(extra.isSavingEnabled())).onClick(new Runnable(){

            @Override
            public void run() {
                extra.setSavingEnabled(PlayerOverviewGui.this.saveCheckbox.isChecked());
            }
        });
        ReplayModReplay.instance.getReplayHandler().getOverlay().setVisible(false);
    }

    @Override
    public void close() {
        ReplayModReplay.instance.getReplayHandler().getOverlay().setVisible(true);
        this.extra.saveHiddenPlayers();
    }

    private static boolean isSpectator(Player e) {
        return e.isInvisible() && e.getEffect(MobEffects.INVISIBILITY) == null;
    }

    private static final class PlayerComparator
    implements Comparator<Player> {
        private PlayerComparator() {
        }

        @Override
        public int compare(Player o1, Player o2) {
            if (PlayerOverviewGui.isSpectator(o1) && !PlayerOverviewGui.isSpectator(o2)) {
                return 1;
            }
            if (PlayerOverviewGui.isSpectator(o2) && !PlayerOverviewGui.isSpectator(o1)) {
                return -1;
            }
            return o1.getName().getString().compareToIgnoreCase(o2.getName().getString());
        }
    }
}

