/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.gui;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.recording.Setting;
import com.replaymod.recording.gui.GuiRecordingControls;
import de.johni0702.minecraft.gui.MinecraftGuiRenderer;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.RenderHudCallback;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class GuiRecordingOverlay
extends EventRegistrations {
    private final Minecraft mc;
    private final SettingsRegistry settingsRegistry;
    private final GuiRecordingControls guiControls;

    public GuiRecordingOverlay(Minecraft mc, SettingsRegistry settingsRegistry, GuiRecordingControls guiControls) {
        this.on(RenderHudCallback.EVENT, (stack, partialTicks) -> this.renderRecordingIndicator(stack));
        this.mc = mc;
        this.settingsRegistry = settingsRegistry;
        this.guiControls = guiControls;
    }

    private void renderRecordingIndicator(GuiGraphics stack) {
        if (this.guiControls.isStopped()) {
            return;
        }
        if (this.settingsRegistry.get(Setting.INDICATOR).booleanValue()) {
            Font fontRenderer = this.mc.font;
            String text = this.guiControls.isPaused() ? I18n.get((String)"replaymod.gui.paused", (Object[])new Object[0]) : I18n.get((String)"replaymod.gui.recording", (Object[])new Object[0]);
            MinecraftGuiRenderer renderer = new MinecraftGuiRenderer(stack);
            Objects.requireNonNull(fontRenderer);
            renderer.drawString(30, 18 - 9 / 2, -1, text.toUpperCase());
            renderer.bindTexture(ReplayMod.TEXTURE);
            renderer.drawTexturedRect(10, 10, 58, 20, 16, 16, 16, 16, 256, 256);
        }
    }
}

