/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.handler;

import com.mojang.datafixers.util.Pair;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.mixin.IntegratedServerAccessor;
import com.replaymod.recording.packet.PacketListener;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class RecordingEventHandler
extends EventRegistrations {
    private final Minecraft mc = MCVer.getMinecraft();
    private final PacketListener packetListener;
    private Double lastX;
    private Double lastY;
    private Double lastZ;
    private static final int EQUIPMENT_SLOTS = EquipmentSlot.values().length;
    private final List<ItemStack> playerItems = NonNullList.withSize((int)EQUIPMENT_SLOTS, (Object)ItemStack.EMPTY);
    private int ticksSinceLastCorrection;
    private boolean wasSleeping;
    private int lastRiding = -1;
    private Integer rotationYawHeadBefore;

    public RecordingEventHandler(PacketListener packetListener) {
        this.on(PreTickCallback.EVENT, this::onPlayerTick);
        this.on(PreRenderCallback.EVENT, this::checkForGamePaused);
        this.packetListener = packetListener;
    }

    @Override
    public void register() {
        super.register();
        ((RecordingEventSender)this.mc.levelRenderer).setRecordingEventHandler(this);
    }

    @Override
    public void unregister() {
        super.unregister();
        RecordingEventSender recordingEventSender = (RecordingEventSender)this.mc.levelRenderer;
        if (recordingEventSender.getRecordingEventHandler() == this) {
            recordingEventSender.setRecordingEventHandler(null);
        }
    }

    public void onPacket(Packet<?> packet) {
        this.packetListener.save(packet);
    }

    public void spawnRecordingPlayer() {
        try {
            LocalPlayer player = this.mc.player;
            assert (player != null);
            this.packetListener.save((Packet)new ClientboundAddEntityPacket(player.getId(), player.getUUID(), player.getX(), player.getY(), player.getZ(), player.getXRot(), player.getYRot(), player.getType(), 0, player.getDeltaMovement(), (double)player.getYHeadRot()));
            this.packetListener.save((Packet)new ClientboundSetEntityDataPacket(player.getId(), player.getEntityData().getNonDefaultValues()));
            this.lastZ = null;
            this.lastY = null;
            this.lastX = null;
            this.playerItems.clear();
            this.lastRiding = -1;
            this.wasSleeping = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClientEffect(int type, BlockPos pos, int data) {
        try {
            this.packetListener.save((Packet)new ClientboundLevelEventPacket(type, pos, data, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onPlayerTick() {
        if (this.mc.player == null) {
            return;
        }
        LocalPlayer player = this.mc.player;
        try {
            int vehicleId;
            ClientboundTeleportEntityPacket packet;
            boolean force = false;
            if (this.lastX == null || this.lastY == null || this.lastZ == null) {
                force = true;
                this.lastX = player.getX();
                this.lastY = player.getY();
                this.lastZ = player.getZ();
            }
            ++this.ticksSinceLastCorrection;
            if (this.ticksSinceLastCorrection >= 100) {
                this.ticksSinceLastCorrection = 0;
                force = true;
            }
            double dx = player.getX() - this.lastX;
            double dy = player.getY() - this.lastY;
            double dz = player.getZ() - this.lastZ;
            this.lastX = player.getX();
            this.lastY = player.getY();
            this.lastZ = player.getZ();
            double maxRelDist = 8.0;
            if (force || Math.abs(dx) > 8.0 || Math.abs(dy) > 8.0 || Math.abs(dz) > 8.0) {
                packet = new ClientboundTeleportEntityPacket((Entity)player);
            } else {
                byte newYaw = (byte)(player.getYRot() * 256.0f / 360.0f);
                byte newPitch = (byte)(player.getXRot() * 256.0f / 360.0f);
                packet = new ClientboundMoveEntityPacket.PosRot(player.getId(), (short)Math.round(dx * 4096.0), (short)Math.round(dy * 4096.0), (short)Math.round(dz * 4096.0), newYaw, newPitch, player.onGround());
            }
            this.packetListener.save((Packet)packet);
            int rotationYawHead = (int)(player.yHeadRot * 256.0f / 360.0f);
            if (!Objects.equals(rotationYawHead, this.rotationYawHeadBefore)) {
                this.packetListener.save((Packet)new ClientboundRotateHeadPacket((Entity)player, (byte)rotationYawHead));
                this.rotationYawHeadBefore = rotationYawHead;
            }
            this.packetListener.save((Packet)new ClientboundSetEntityMotionPacket(player.getId(), player.getDeltaMovement()));
            if (player.swinging && player.swingTime == 0) {
                this.packetListener.save((Packet)new ClientboundAnimatePacket((Entity)player, player.swingingArm == InteractionHand.MAIN_HAND ? 0 : 3));
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = player.getItemBySlot(slot);
                int index = slot.ordinal();
                if (ItemStack.matches((ItemStack)this.playerItems.get(index), (ItemStack)stack)) continue;
                stack = stack != null ? stack.copy() : null;
                this.playerItems.set(index, stack);
                this.packetListener.save((Packet)new ClientboundSetEquipmentPacket(player.getId(), Collections.singletonList(Pair.of((Object)slot, (Object)stack))));
            }
            Entity vehicle = player.getVehicle();
            int n = vehicleId = vehicle == null ? -1 : vehicle.getId();
            if (this.lastRiding != vehicleId) {
                this.lastRiding = vehicleId;
                this.packetListener.save((Packet)new ClientboundSetEntityLinkPacket((Entity)player, vehicle));
            }
            if (!player.isSleeping() && this.wasSleeping) {
                this.packetListener.save((Packet)new ClientboundAnimatePacket((Entity)player, 2));
                this.wasSleeping = false;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void onBlockBreakAnim(int breakerId, BlockPos pos, int progress) {
        LocalPlayer thePlayer = this.mc.player;
        if (thePlayer != null && breakerId == thePlayer.getId()) {
            this.packetListener.save((Packet)new ClientboundBlockDestructionPacket(breakerId, pos, progress));
        }
    }

    private void checkForGamePaused() {
        IntegratedServer server;
        if (this.mc.hasSingleplayerServer() && (server = this.mc.getSingleplayerServer()) != null && ((IntegratedServerAccessor)server).isGamePaused()) {
            this.packetListener.setServerWasPaused();
        }
    }

    public static interface RecordingEventSender {
        public void setRecordingEventHandler(RecordingEventHandler var1);

        public RecordingEventHandler getRecordingEventHandler();
    }
}

