/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.mixin;

import com.replaymod.recording.ServerInfoExt;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerData.class})
public abstract class MixinServerInfo
implements ServerInfoExt {
    private Boolean autoRecording;

    @Override
    public Boolean getAutoRecording() {
        return this.autoRecording;
    }

    @Override
    public void setAutoRecording(Boolean autoRecording) {
        this.autoRecording = autoRecording;
    }

    @Inject(method={"write()Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private void serialize(CallbackInfoReturnable<CompoundTag> ci) {
        CompoundTag tag = (CompoundTag)ci.getReturnValue();
        if (this.autoRecording != null) {
            tag.putBoolean("autoRecording", this.autoRecording.booleanValue());
        }
    }

    @Inject(method={"read(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/client/multiplayer/ServerData;"}, at={@At(value="RETURN")})
    private static void deserialize(CompoundTag tag, CallbackInfoReturnable<ServerData> ci) {
        ServerInfoExt serverInfo = ServerInfoExt.from((ServerData)ci.getReturnValue());
        if (tag.contains("autoRecording")) {
            serverInfo.setAutoRecording(tag.getBoolean("autoRecording"));
        }
    }

    @Inject(method={"copyFrom(Lnet/minecraft/client/multiplayer/ServerData;)V"}, at={@At(value="RETURN")})
    public void copyFrom(ServerData serverInfo, CallbackInfo ci) {
        ServerInfoExt from = ServerInfoExt.from(serverInfo);
        this.autoRecording = from.getAutoRecording();
    }
}

