/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.packet;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.PooledByteBufAllocator;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import com.google.gson.Gson;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Restrictions;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.editor.gui.MarkerProcessor;
import com.replaymod.recording.ReplayModRecording;
import com.replaymod.recording.Setting;
import com.replaymod.recording.gui.GuiSavingReplay;
import com.replaymod.recording.handler.ConnectionEventHandler;
import com.replaymod.recording.mixin.DecoderHandlerAccessor;
import com.replaymod.recording.packet.ResourcePackRecorder;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class PacketListener
extends ChannelInboundHandlerAdapter {
    public static final String RAW_RECORDER_KEY = "replay_recorder_raw";
    public static final String DECODED_RECORDER_KEY = "replay_recorder_decoded";
    public static final String DECOMPRESS_KEY = "decompress";
    public static final String DECODER_KEY = "decoder";
    private static final Minecraft mc = MCVer.getMinecraft();
    private static final Logger logger = LogManager.getLogger();
    private final ReplayMod core;
    private final Path outputPath;
    private final ReplayFile replayFile;
    private final ResourcePackRecorder resourcePackRecorder;
    private final ExecutorService saveService = Executors.newSingleThreadExecutor();
    private final ReplayOutputStream packetOutputStream;
    private ReplayMetaData metaData;
    private final Channel channel;
    private Packet currentRawPacket;
    private final long startTime;
    private long lastSentPacket;
    private long timePassedWhilePaused;
    private volatile boolean serverWasPaused;
    private final AtomicInteger lastSaveMetaDataId = new AtomicInteger();

    public PacketListener(ReplayMod core, Channel channel, Path outputPath, ReplayFile replayFile, ReplayMetaData metaData) throws IOException {
        this.core = core;
        this.channel = channel;
        this.outputPath = outputPath;
        this.replayFile = replayFile;
        this.metaData = metaData;
        this.resourcePackRecorder = new ResourcePackRecorder(replayFile);
        this.packetOutputStream = replayFile.writePacketData();
        this.startTime = metaData.getDate();
        this.saveMetaData();
    }

    private void saveMetaData() {
        int id = this.lastSaveMetaDataId.incrementAndGet();
        this.saveService.submit(() -> {
            if (this.lastSaveMetaDataId.get() != id) {
                return;
            }
            try {
                ReplayFile replayFile = this.replayFile;
                synchronized (replayFile) {
                    if (ReplayMod.isMinimalMode()) {
                        this.metaData.setFileFormat("MCPR");
                        this.metaData.setFileFormatVersion(14);
                        this.metaData.setProtocolVersion(MCVer.getProtocolVersion());
                        this.metaData.setGenerator("ReplayMod in Minimal Mode");
                        try (OutputStream out = this.replayFile.write("metaData.json");){
                            String json = new Gson().toJson((Object)this.metaData);
                            out.write(json.getBytes());
                        }
                    } else {
                        this.replayFile.writeMetaData(MCVer.getPacketTypeRegistry(State.LOGIN), this.metaData);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Writing metadata:", (Throwable)e);
            }
        });
    }

    public void save(net.minecraft.network.protocol.Packet packet) {
        Packet encoded;
        try {
            encoded = this.encodeMcPacket(this.getConnectionState(), packet);
        }
        catch (Exception e) {
            logger.error("Encoding packet:", (Throwable)e);
            return;
        }
        this.save(encoded);
    }

    public void save(Packet packet) {
        if (!mc.isSameThread()) {
            mc.tell(() -> this.save(packet));
            return;
        }
        try {
            long now = System.currentTimeMillis();
            if (this.serverWasPaused) {
                this.timePassedWhilePaused = now - this.startTime - this.lastSentPacket;
                this.serverWasPaused = false;
            }
            int timestamp = (int)(now - this.startTime - this.timePassedWhilePaused);
            this.lastSentPacket = timestamp;
            PacketData packetData = new PacketData(timestamp, packet);
            this.saveService.submit(() -> {
                block6: {
                    try {
                        if (ReplayMod.isMinimalMode()) {
                            ByteBuf packetIdBuf = PooledByteBufAllocator.DEFAULT.buffer();
                            ByteBuf packetBuf = packetData.getPacket().getBuf();
                            try {
                                new ByteBufNetOutput(packetIdBuf).writeVarInt(packetData.getPacket().getId());
                                int packetIdLen = packetIdBuf.readableBytes();
                                int packetBufLen = packetBuf.readableBytes();
                                com.replaymod.replaystudio.util.Utils.writeInt(this.packetOutputStream, (int)packetData.getTime());
                                com.replaymod.replaystudio.util.Utils.writeInt(this.packetOutputStream, packetIdLen + packetBufLen);
                                packetIdBuf.readBytes(this.packetOutputStream, packetIdLen);
                                packetBuf.getBytes(packetBuf.readerIndex(), this.packetOutputStream, packetBufLen);
                                break block6;
                            }
                            finally {
                                packetIdBuf.release();
                                packetBuf.release();
                            }
                        }
                        this.packetOutputStream.write(packetData);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Writing packet:", (Throwable)e);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.metaData.setDuration((int)this.lastSentPacket);
        this.saveMetaData();
        this.core.runLater(() -> {
            ConnectionEventHandler connectionEventHandler = ReplayModRecording.instance.getConnectionEventHandler();
            if (connectionEventHandler.getPacketListener() == this) {
                connectionEventHandler.reset();
            }
        });
        GuiSavingReplay guiSavingReplay = new GuiSavingReplay(this.core);
        new Thread(() -> {
            List<Object> outputPaths;
            this.core.runLater(guiSavingReplay::open);
            this.saveService.shutdown();
            try {
                this.saveService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error("Waiting for save service termination:", (Throwable)e);
            }
            try {
                this.packetOutputStream.close();
            }
            catch (IOException e) {
                logger.error("Failed to close packet output stream:", (Throwable)e);
            }
            ReplayFile replayFile = this.replayFile;
            synchronized (replayFile) {
                try {
                    if (!MarkerProcessor.producesAnyOutput(this.replayFile)) {
                        this.core.runLater(guiSavingReplay::close);
                        Path noRecoverMarker = this.outputPath.resolveSibling(String.valueOf(this.outputPath.getFileName()) + ".no_recover");
                        Files.createFile(noRecoverMarker, new FileAttribute[0]);
                        String replayName = FilenameUtils.getBaseName((String)this.outputPath.getFileName().toString());
                        Path rawFolder = ReplayMod.instance.folders.getRawReplayFolder();
                        Path rawPath = rawFolder.resolve(this.outputPath.getFileName());
                        int i = 1;
                        while (Files.exists(rawPath, new LinkOption[0])) {
                            rawPath = rawPath.resolveSibling(replayName + "." + i + ".mcpr");
                            ++i;
                        }
                        this.replayFile.saveTo(rawPath.toFile());
                        this.replayFile.close();
                        Files.delete(noRecoverMarker);
                        return;
                    }
                    this.replayFile.save();
                    this.replayFile.close();
                    outputPaths = this.core.getSettingsRegistry().get(Setting.AUTO_POST_PROCESS).booleanValue() && !ReplayMod.isMinimalMode() ? MarkerProcessor.apply(this.outputPath, guiSavingReplay.getProgressBar()::setProgress) : Collections.singletonList(Pair.of((Object)this.outputPath, (Object)this.metaData));
                }
                catch (Exception e) {
                    logger.error("Saving replay file:", (Throwable)e);
                    CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Saving replay file");
                    this.core.runLater(() -> Utils.error(logger, VanillaGuiScreen.wrap(PacketListener.mc.screen), crashReport, guiSavingReplay::close));
                    return;
                }
            }
            this.core.runLater(() -> guiSavingReplay.presentRenameDialog(outputPaths));
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ConnectionProtocol connectionState = this.getConnectionState();
        Packet packet = null;
        if (msg instanceof io.netty.buffer.ByteBuf) {
            io.netty.buffer.ByteBuf buf = (io.netty.buffer.ByteBuf)msg;
            if (buf.readableBytes() > 0) {
                packet = PacketListener.decodePacket(connectionState, buf);
            }
        } else if (msg instanceof net.minecraft.network.protocol.Packet) {
            // empty if block
        }
        this.currentRawPacket = packet;
        try {
            super.channelRead(ctx, msg);
        }
        finally {
            if (this.currentRawPacket != null) {
                this.currentRawPacket.release();
                this.currentRawPacket = null;
            }
        }
    }

    private ConnectionProtocol getConnectionState() {
        DecoderHandlerAccessor decoderHandler = (DecoderHandlerAccessor)this.channel.pipeline().get(PacketDecoder.class);
        if (decoderHandler == null) {
            return ConnectionProtocol.LOGIN;
        }
        return decoderHandler.getProtocolInfo().id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet encodeMcPacket(ConnectionProtocol connectionState, net.minecraft.network.protocol.Packet packet) throws Exception {
        io.netty.buffer.ByteBuf byteBuf = Unpooled.buffer();
        try {
            ProtocolInfo state = connectionState == ConnectionProtocol.LOGIN ? LoginProtocols.CLIENTBOUND : ((DecoderHandlerAccessor)this.channel.pipeline().get(PacketDecoder.class)).getProtocolInfo();
            state.codec().encode((Object)byteBuf, (Object)packet);
            Packet packet2 = PacketListener.decodePacket(state.id(), byteBuf);
            return packet2;
        }
        finally {
            byteBuf.release();
        }
    }

    private static Packet decodePacket(ConnectionProtocol connectionState, io.netty.buffer.ByteBuf buf) {
        FriendlyByteBuf packetBuf = new FriendlyByteBuf(buf.slice());
        int packetId = packetBuf.readVarInt();
        byte[] bytes = new byte[packetBuf.readableBytes()];
        packetBuf.readBytes(bytes);
        return new Packet(MCVer.getPacketTypeRegistry(connectionState), packetId, com.github.steveice10.netty.buffer.Unpooled.wrappedBuffer(bytes));
    }

    public void addMarker(String name) {
        this.addMarker(name, (int)this.getCurrentDuration());
    }

    public void addMarker(String name, int timestamp) {
        Entity view = mc.getCameraEntity();
        Marker marker = new Marker();
        marker.setName(name);
        marker.setTime(timestamp);
        if (view != null) {
            marker.setX(view.getX());
            marker.setY(view.getY());
            marker.setZ(view.getZ());
            marker.setYaw(view.getYRot());
            marker.setPitch(view.getXRot());
        }
        this.saveService.submit(() -> {
            ReplayFile replayFile = this.replayFile;
            synchronized (replayFile) {
                try {
                    Set markers = this.replayFile.getMarkers().or(HashSet::new);
                    markers.add(marker);
                    this.replayFile.writeMarkers(markers);
                }
                catch (IOException e) {
                    logger.error("Writing markers:", (Throwable)e);
                }
            }
        });
    }

    public long getCurrentDuration() {
        return this.lastSentPacket;
    }

    public void setServerWasPaused() {
        this.serverWasPaused = true;
    }

    public ResourcePackRecorder getResourcePackRecorder() {
        return this.resourcePackRecorder;
    }

    public class DecodedPacketListener
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ClientboundCustomPayloadPacket packet;
            if (msg instanceof ClientboundLoginCompressionPacket) {
                super.channelRead(ctx, msg);
                return;
            }
            if (msg instanceof ClientboundCustomPayloadPacket && Restrictions.PLUGIN_CHANNEL.equals((Object)(packet = (ClientboundCustomPayloadPacket)msg).payload().type().id())) {
                PacketListener.this.save((net.minecraft.network.protocol.Packet)new ClientboundDisconnectPacket((Component)Component.literal((String)"Please update to view this replay.")));
            }
            if (msg instanceof ClientboundAddEntityPacket && (packet = (ClientboundAddEntityPacket)msg).getType() == EntityType.PLAYER) {
                UUID uuid = packet.getUUID();
                HashSet<String> uuids = new HashSet<String>(Arrays.asList(PacketListener.this.metaData.getPlayers()));
                uuids.add(uuid.toString());
                PacketListener.this.metaData.setPlayers(uuids.toArray(new String[uuids.size()]));
                PacketListener.this.saveMetaData();
            }
            if (msg instanceof ClientboundResourcePackPushPacket) {
                Connection connection = (Connection)ctx.pipeline().get(Connection.class);
                PacketListener.this.save((net.minecraft.network.protocol.Packet)PacketListener.this.resourcePackRecorder.handleResourcePack(connection, (ClientboundResourcePackPushPacket)msg));
                super.channelRead(ctx, msg);
            }
            if (msg instanceof ClientboundFinishConfigurationPacket) {
                super.channelRead(ctx, msg);
                return;
            }
            if (PacketListener.this.currentRawPacket != null) {
                PacketListener.this.save(PacketListener.this.currentRawPacket);
                PacketListener.this.currentRawPacket = null;
            }
            super.channelRead(ctx, msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof UnconfiguredPipelineHandler.InboundConfigurationTask) {
                msg = ((UnconfiguredPipelineHandler.InboundConfigurationTask)msg).andThen(context -> {
                    context.pipeline().remove((ChannelHandler)this);
                    context.pipeline().addAfter(PacketListener.DECODER_KEY, PacketListener.DECODED_RECORDER_KEY, (ChannelHandler)new DecodedPacketListener());
                });
            }
            super.write(ctx, msg, promise);
        }
    }
}

