/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.packet;

import com.google.common.hash.Hashing;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replaystudio.replay.ReplayFile;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackRecorder {
    private static final Logger logger = LogManager.getLogger();
    private static final Minecraft mc = MCVer.getMinecraft();
    private final ReplayFile replayFile;
    private int nextRequestId;
    private final Map<UUID, Integer> mcIdToReplayId = new HashMap<UUID, Integer>();

    public ResourcePackRecorder(ReplayFile replayFile) {
        this.replayFile = replayFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResourcePack(Path file, int requestId) {
        block13: {
            try {
                byte[] bytes = Files.readAllBytes(file);
                String hash = Hashing.sha1().hashBytes(bytes).toString();
                boolean doWrite = false;
                ReplayFile replayFile = this.replayFile;
                synchronized (replayFile) {
                    Map<Integer, String> index = this.replayFile.getResourcePackIndex();
                    if (index == null) {
                        index = new HashMap<Integer, String>();
                    }
                    if (!index.containsValue(hash)) {
                        doWrite = true;
                    }
                    index.put(requestId, hash);
                    this.replayFile.writeResourcePackIndex(index);
                }
                if (!doWrite) break block13;
                try (OutputStream out = this.replayFile.writeResourcePack(hash);){
                    out.write(bytes);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to save resource pack.", (Throwable)e);
            }
        }
    }

    public synchronized ClientboundResourcePackPushPacket handleResourcePack(Connection netManager, ClientboundResourcePackPushPacket packet) {
        int requestId = this.nextRequestId++;
        this.mcIdToReplayId.put(packet.id(), requestId);
        return new ClientboundResourcePackPushPacket(packet.id(), "replay://" + requestId, "", packet.required(), packet.prompt());
    }

    public void recordResourcePack(Path file, UUID uuid) {
        Integer id = this.mcIdToReplayId.get(uuid);
        if (id == null) {
            logger.warn("Got resource pack download for unexpected uuid " + String.valueOf(uuid) + " at " + String.valueOf(file));
            return;
        }
        this.recordResourcePack(file, id);
    }
}

