/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render;

import com.replaymod.core.versions.MCVer;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.utils.ByteBufferPool;
import com.replaymod.render.utils.Lwjgl3Loader;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.CrashReport;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyexr.EXRChannelInfo;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.TinyEXR;

public class EXRWriter
implements FrameConsumer<BitmapFrame> {
    private static final int COMPRESSION = Runtime.getRuntime().availableProcessors() >= 8 ? 2 : 0;
    private final Path outputFolder;
    private final boolean keepAlpha;

    public static FrameConsumer<BitmapFrame> create(Path outputFolder, boolean keepAlpha) {
        return Lwjgl3Loader.createFrameConsumer(EXRWriter.class, new Class[]{Path.class, Boolean.TYPE}, new Object[]{outputFolder, keepAlpha});
    }

    public EXRWriter(Path outputFolder, boolean keepAlpha) throws IOException {
        this.outputFolder = outputFolder;
        this.keepAlpha = keepAlpha;
        Files.createDirectories(outputFolder, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Map<Channel, BitmapFrame> channels) {
        BitmapFrame bgraFrame = channels.get((Object)Channel.BRGA);
        BitmapFrame depthFrame = channels.get((Object)Channel.DEPTH);
        Path path = this.outputFolder.resolve(bgraFrame.getFrameId() + ".exr");
        ReadableDimension size = bgraFrame.getSize();
        ByteBuffer bgra = bgraFrame.getByteBuffer();
        int width = size.getWidth();
        int height = size.getHeight();
        int numChannels = 4 + (depthFrame != null ? 1 : 0);
        MemoryStack.stackPush();
        EXRHeader header = EXRHeader.mallocStack();
        TinyEXR.InitEXRHeader((EXRHeader)header);
        EXRChannelInfo.Buffer channelInfos = EXRChannelInfo.mallocStack((int)numChannels);
        IntBuffer pixelTypes = MemoryStack.stackMallocInt((int)numChannels);
        IntBuffer requestedPixelTypes = MemoryStack.stackMallocInt((int)numChannels);
        EXRImage image = EXRImage.mallocStack();
        TinyEXR.InitEXRImage((EXRImage)image);
        PointerBuffer imagePointers = MemoryStack.stackMallocPointer((int)numChannels);
        FloatBuffer images = MemoryUtil.memAllocFloat((int)(width * height * numChannels));
        PointerBuffer err = MemoryStack.stackMallocPointer((int)1);
        try {
            int ret;
            header.num_channels(numChannels);
            header.channels(channelInfos);
            header.pixel_types(pixelTypes);
            header.requested_pixel_types(requestedPixelTypes);
            header.compression_type(COMPRESSION);
            MemoryUtil.memASCII((CharSequence)"A", (boolean)true, (ByteBuffer)((EXRChannelInfo)channelInfos.get(0)).name());
            MemoryUtil.memASCII((CharSequence)"B", (boolean)true, (ByteBuffer)((EXRChannelInfo)channelInfos.get(1)).name());
            MemoryUtil.memASCII((CharSequence)"G", (boolean)true, (ByteBuffer)((EXRChannelInfo)channelInfos.get(2)).name());
            MemoryUtil.memASCII((CharSequence)"R", (boolean)true, (ByteBuffer)((EXRChannelInfo)channelInfos.get(3)).name());
            for (int i = 0; i < numChannels; ++i) {
                pixelTypes.put(i, 2);
                requestedPixelTypes.put(i, 1);
            }
            if (depthFrame != null) {
                MemoryUtil.memASCII((CharSequence)"Z", (boolean)true, (ByteBuffer)((EXRChannelInfo)channelInfos.get(4)).name());
                requestedPixelTypes.put(4, 2);
            }
            image.num_channels(numChannels);
            image.width(width);
            image.height(height);
            image.images(imagePointers);
            FloatBuffer[] bgrChannels = new FloatBuffer[4];
            FloatBuffer depthChannel = null;
            for (int i = 0; i < numChannels; ++i) {
                FloatBuffer channel = images.slice();
                channel.position(width * height * i);
                imagePointers.put(i, MemoryUtil.memAddress((FloatBuffer)channel));
                if (i == 4) {
                    depthChannel = channel;
                    continue;
                }
                bgrChannels[(i + 3) % 4] = channel;
            }
            int alphaMask = this.keepAlpha ? 0 : 255;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    bgrChannels[0].put((float)(bgra.get() & 0xFF) / 255.0f);
                    bgrChannels[1].put((float)(bgra.get() & 0xFF) / 255.0f);
                    bgrChannels[2].put((float)(bgra.get() & 0xFF) / 255.0f);
                    bgrChannels[3].put((float)(bgra.get() & 0xFF | alphaMask) / 255.0f);
                }
            }
            if (depthFrame != null && depthChannel != null) {
                depthChannel.put(depthFrame.getByteBuffer().asFloatBuffer());
            }
            if ((ret = TinyEXR.SaveEXRImageToFile((EXRImage)image, (EXRHeader)header, (CharSequence)path.toString(), (PointerBuffer)err)) != 0) {
                String message = MemoryUtil.memASCII((long)err.get(0));
                TinyEXR.nFreeEXRErrorMessage((long)err.get(0));
                throw new IOException(message);
            }
        }
        catch (Throwable t) {
            MCVer.getMinecraft().delayCrashRaw(CrashReport.forThrowable((Throwable)t, (String)"Exporting EXR frame"));
        }
        finally {
            MemoryUtil.memFree((Buffer)images);
            MemoryStack.stackPop();
            channels.values().forEach(it -> ByteBufferPool.release(it.getByteBuffer()));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isParallelCapable() {
        return true;
    }
}

