/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render;

import com.replaymod.core.versions.MCVer;
import com.replaymod.render.RenderSettings;
import com.replaymod.render.ReplayModRender;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.rendering.VideoRenderer;
import com.replaymod.render.utils.ByteBufferPool;
import com.replaymod.render.utils.StreamPipe;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.Validate;

public class FFmpegWriter
implements FrameConsumer<BitmapFrame> {
    private final VideoRenderer renderer;
    private final RenderSettings settings;
    private final Process process;
    private final OutputStream outputStream;
    private final WritableByteChannel channel;
    private final String commandArgs;
    private volatile boolean aborted;
    private ByteArrayOutputStream ffmpegLog = new ByteArrayOutputStream(4096);

    public FFmpegWriter(VideoRenderer renderer) throws IOException {
        String[] cmdline;
        this.renderer = renderer;
        this.settings = renderer.getRenderSettings();
        File outputFolder = this.settings.getOutputFile().getParentFile();
        FileUtils.forceMkdir((File)outputFolder);
        String fileName = this.settings.getOutputFile().getName();
        this.commandArgs = this.settings.getExportArguments().replace("%WIDTH%", String.valueOf(this.settings.getVideoWidth())).replace("%HEIGHT%", String.valueOf(this.settings.getVideoHeight())).replace("%FPS%", String.valueOf(this.settings.getFramesPerSecond())).replace("%FILENAME%", fileName).replace("%BITRATE%", String.valueOf(this.settings.getBitRate())).replace("%FILTERS%", this.settings.getVideoFilters());
        String executable = this.settings.getExportCommandOrDefault();
        ReplayModRender.LOGGER.info("Starting {} with args: {}", (Object)executable, (Object)this.commandArgs);
        try {
            cmdline = new CommandLine(executable).addArguments(this.commandArgs, false).toStrings();
        }
        catch (IllegalArgumentException e) {
            ReplayModRender.LOGGER.error("Failed to parse ffmpeg command line:", (Throwable)e);
            throw new FFmpegStartupException(this.settings, e.getLocalizedMessage());
        }
        try {
            this.process = new ProcessBuilder(cmdline).directory(outputFolder).start();
        }
        catch (IOException e) {
            throw new NoFFmpegException(e);
        }
        File exportLogFile = new File(MCVer.getMinecraft().gameDirectory, "export.log");
        TeeOutputStream exportLogOut = new TeeOutputStream((OutputStream)new FileOutputStream(exportLogFile), (OutputStream)this.ffmpegLog);
        new StreamPipe(this.process.getInputStream(), (OutputStream)exportLogOut).start();
        new StreamPipe(this.process.getErrorStream(), (OutputStream)exportLogOut).start();
        this.outputStream = this.process.getOutputStream();
        this.channel = Channels.newChannel(this.outputStream);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        long startTime = System.nanoTime();
        long rem = TimeUnit.SECONDS.toNanos(30L);
        while (true) {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                try {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if ((rem = TimeUnit.SECONDS.toNanos(30L) - (System.nanoTime() - startTime)) > 0L) continue;
            }
            break;
        }
        this.process.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Map<Channel, BitmapFrame> channels) {
        BitmapFrame frame = channels.get((Object)Channel.BRGA);
        try {
            this.checkSize(frame.getSize());
            this.channel.write(frame.getByteBuffer());
        }
        catch (Throwable t) {
            if (this.aborted) {
                return;
            }
            try {
                this.getVideoFile();
            }
            catch (FFmpegStartupException e) {
                this.renderer.setFailure(e);
                return;
            }
            CrashReport report = CrashReport.forThrowable((Throwable)t, (String)"Exporting frame");
            CrashReportCategory exportDetails = report.addCategory("Export details");
            exportDetails.setDetail("Export command", this.settings::getExportCommand);
            exportDetails.setDetail("Export args", this.commandArgs::toString);
            MCVer.getMinecraft().delayCrashRaw(report);
        }
        finally {
            channels.values().forEach(it -> ByteBufferPool.release(it.getByteBuffer()));
        }
    }

    @Override
    public boolean isParallelCapable() {
        return false;
    }

    private void checkSize(ReadableDimension size) {
        this.checkSize(size.getWidth(), size.getHeight());
    }

    private void checkSize(int width, int height) {
        Validate.isTrue((width == this.settings.getVideoWidth() ? 1 : 0) != 0, (String)"Width has to be %d but was %d", (Object[])new Object[]{this.settings.getVideoWidth(), width});
        Validate.isTrue((height == this.settings.getVideoHeight() ? 1 : 0) != 0, (String)"Height has to be %d but was %d", (Object[])new Object[]{this.settings.getVideoHeight(), height});
    }

    public void abort() {
        this.aborted = true;
    }

    public File getVideoFile() throws FFmpegStartupException {
        String log = this.ffmpegLog.toString();
        for (String line : log.split("\n")) {
            if (!line.startsWith("Output #0")) continue;
            String fileName = line.substring(line.indexOf(", to '") + 6, line.lastIndexOf(39));
            return new File(this.settings.getOutputFile().getParentFile(), fileName);
        }
        throw new FFmpegStartupException(this.settings, log);
    }

    public static class FFmpegStartupException
    extends IOException {
        private final RenderSettings settings;
        private final String log;

        public FFmpegStartupException(RenderSettings settings, String log) {
            this.settings = settings;
            this.log = log;
        }

        public RenderSettings getSettings() {
            return this.settings;
        }

        public String getLog() {
            return this.log;
        }
    }

    public static class NoFFmpegException
    extends IOException {
        public NoFFmpegException(Throwable cause) {
            super(cause);
        }
    }
}

