/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render;

import com.replaymod.core.versions.MCVer;
import com.replaymod.render.blend.Util;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.utils.ByteBufferPool;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.versions.Image;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.CrashReport;

public class PNGWriter
implements FrameConsumer<BitmapFrame> {
    private final Path outputFolder;
    private final boolean keepAlpha;

    public PNGWriter(Path outputFolder, boolean keepAlpha) throws IOException {
        this.outputFolder = outputFolder;
        this.keepAlpha = keepAlpha;
        Files.createDirectories(outputFolder, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Map<Channel, BitmapFrame> channels) {
        BitmapFrame bgraFrame = channels.get((Object)Channel.BRGA);
        BitmapFrame depthFrame = channels.get((Object)Channel.DEPTH);
        try {
            if (bgraFrame != null) {
                this.withImage(bgraFrame, image -> image.writePNG(this.outputFolder.resolve(bgraFrame.getFrameId() + ".png").toFile()));
            }
            if (depthFrame != null) {
                this.withImage(depthFrame, image -> image.writePNG(this.outputFolder.resolve(depthFrame.getFrameId() + ".depth.png").toFile()));
            }
        }
        catch (Throwable t) {
            MCVer.getMinecraft().delayCrashRaw(CrashReport.forThrowable((Throwable)t, (String)"Exporting EXR frame"));
        }
        finally {
            channels.values().forEach(it -> ByteBufferPool.release(it.getByteBuffer()));
        }
    }

    private void withImage(BitmapFrame frame, Util.IOConsumer<Image> consumer) throws IOException {
        byte alphaMask = (byte)(this.keepAlpha ? 0 : 255);
        ByteBuffer buffer = frame.getByteBuffer();
        ReadableDimension size = frame.getSize();
        int width = size.getWidth();
        int height = size.getHeight();
        try (Image image = new Image(width, height);){
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    byte b = buffer.get();
                    byte g = buffer.get();
                    byte r = buffer.get();
                    byte a = buffer.get();
                    image.setRGBA(x, y, r, g, b, a | alphaMask);
                }
            }
            consumer.accept(image);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isParallelCapable() {
        return true;
    }
}

