/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render;

import com.replaymod.core.Module;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Utils;
import com.replaymod.render.Setting;
import com.replaymod.render.utils.RenderJob;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.events.ReplayClosedCallback;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replaystudio.replay.ReplayFile;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplayModRender
extends EventRegistrations
implements Module {
    public static ReplayModRender instance;
    private ReplayMod core;
    public static Logger LOGGER;
    private ReplayFile replayFile;
    private final List<RenderJob> renderQueue;

    public ReplayModRender(ReplayMod core) {
        instance = this;
        this.renderQueue = new ArrayList<RenderJob>();
        this.on(ReplayOpenedCallback.EVENT, this::onReplayOpened);
        this.on(ReplayClosedCallback.EVENT, replayHandler -> this.onReplayClosed());
        this.core = core;
        core.getSettingsRegistry().register(Setting.class);
    }

    public ReplayMod getCore() {
        return this.core;
    }

    @Override
    public void initClient() {
        this.register();
    }

    public File getVideoFolder() {
        String path = this.core.getSettingsRegistry().get(Setting.RENDER_PATH);
        File folder = new File(path.startsWith("./") ? this.core.getMinecraft().gameDirectory : null, path);
        try {
            FileUtils.forceMkdir((File)folder);
        }
        catch (IOException e) {
            throw new ReportedException(CrashReport.forThrowable((Throwable)e, (String)"Cannot create video folder."));
        }
        return folder;
    }

    public Path getRenderSettingsPath() {
        return this.core.getMinecraft().gameDirectory.toPath().resolve("config/replaymod-rendersettings.json");
    }

    public List<RenderJob> getRenderQueue() {
        return this.renderQueue;
    }

    private void onReplayOpened(ReplayHandler replayHandler) {
        this.replayFile = replayHandler.getReplayFile();
        try {
            this.renderQueue.addAll(RenderJob.readQueue(this.replayFile));
        }
        catch (IOException e) {
            throw new ReportedException(CrashReport.forThrowable((Throwable)e, (String)"Reading timeline"));
        }
    }

    private void onReplayClosed() {
        this.renderQueue.clear();
        this.replayFile = null;
    }

    public void saveRenderQueue() {
        try {
            RenderJob.writeQueue(this.replayFile, this.renderQueue);
        }
        catch (IOException e) {
            e.printStackTrace();
            VanillaGuiScreen screen = VanillaGuiScreen.wrap(this.getCore().getMinecraft().screen);
            CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Reading timeline");
            Utils.error(LOGGER, screen, report, () -> {});
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

