/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.blend.data;

import com.replaymod.render.blend.data.DId;
import com.replaymod.render.blend.data.DMaterial;
import com.replaymod.render.blend.data.Serializer;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector2f;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.blender.dna.CustomData;
import org.blender.dna.CustomDataLayer;
import org.blender.dna.Image;
import org.blender.dna.MEdge;
import org.blender.dna.MFace;
import org.blender.dna.MLoop;
import org.blender.dna.MLoopCol;
import org.blender.dna.MLoopUV;
import org.blender.dna.MPoly;
import org.blender.dna.MTexPoly;
import org.blender.dna.MVert;
import org.blender.dna.Material;
import org.blender.dna.Mesh;
import org.cakelab.blender.io.block.BlockCodes;
import org.cakelab.blender.nio.CArrayFacade;
import org.cakelab.blender.nio.CPointer;

public class DMesh {
    public final DId id = new DId(BlockCodes.ID_ME);
    public final List<Vertex> vertices = new ArrayList<Vertex>();
    public final List<Edge> edges = new ArrayList<Edge>();
    public final List<Face> faces = new ArrayList<Face>();
    public final List<Loop> loops = new ArrayList<Loop>();
    public final List<Poly> polys = new ArrayList<Poly>();
    public final List<DMaterial> materials = new ArrayList<DMaterial>();

    public CPointer<Mesh> serialize(Serializer serializer) throws IOException {
        return serializer.maybeMajor(this, this.id, Mesh.class, () -> {
            ArrayList<CPointer<Material>> materials = new ArrayList<CPointer<Material>>();
            ArrayList<CPointer<Image>> images = new ArrayList<CPointer<Image>>();
            for (DMaterial material : this.materials) {
                materials.add(material.serialize(serializer));
                images.add(material.textures.isEmpty() ? null : material.textures.get((int)0).texture.image.serialize(serializer));
            }
            return mesh -> {
                mesh.setDrawflag(3);
                CArrayFacade<CPointer<Material>> mat = serializer.writeDataPArray(Material.class, materials.size(), materials::get);
                mesh.setMat(mat);
                mesh.setTotcol((short)materials.size());
                if (!this.vertices.isEmpty()) {
                    CArrayFacade<MVert> mVerts = serializer.writeData(MVert.class, this.vertices.size(), (i, mVert) -> this.vertices.get((int)i).serialize((MVert)mVert));
                    CustomDataLayer vDataLayer = serializer.writeData(CustomDataLayer.class);
                    vDataLayer.setType(0);
                    vDataLayer.setData(mVerts.cast(Object.class));
                    CustomData vData = mesh.getVdata();
                    vData.setMaxlayer(1);
                    vData.setTotlayer(1);
                    vData.setLayers(vDataLayer.__io__addressof());
                    mesh.setMvert(mVerts);
                    mesh.setTotvert(this.vertices.size());
                }
                if (!this.edges.isEmpty()) {
                    CArrayFacade<MEdge> mEdges = serializer.writeData(MEdge.class, this.edges.size(), (i, mEdge) -> this.edges.get((int)i).serialize((MEdge)mEdge));
                    CustomDataLayer eDataLayer = serializer.writeData(CustomDataLayer.class);
                    eDataLayer.setType(3);
                    eDataLayer.setData(mEdges.cast(Object.class));
                    CustomData eData = mesh.getEdata();
                    eData.setMaxlayer(1);
                    eData.setTotlayer(1);
                    eData.setLayers(eDataLayer.__io__addressof());
                    mesh.setMedge(mEdges);
                    mesh.setTotedge(this.edges.size());
                    mesh.setMface(serializer.writeData(MFace.class, this.faces.size(), (i, mFace) -> this.faces.get((int)i).serialize((MFace)mFace)));
                    mesh.setTotface(this.faces.size());
                }
                if (!this.loops.isEmpty()) {
                    CArrayFacade<MLoop> mLoops = serializer.writeData(MLoop.class, this.loops.size(), (i, mLoop) -> this.loops.get((int)i).serialize((MLoop)mLoop));
                    CArrayFacade<MLoopUV> mLoopUVs = serializer.writeData(MLoopUV.class, this.loops.size(), (i, mLoopUV) -> this.loops.get((int)i).serialize((MLoopUV)mLoopUV));
                    CArrayFacade<MLoopCol> mLoopCols = serializer.writeData(MLoopCol.class, this.loops.size(), (i, mLoopCol) -> this.loops.get((int)i).serialize((MLoopCol)mLoopCol));
                    CArrayFacade<CustomDataLayer> dataLayers = serializer.writeData(CustomDataLayer.class, 3);
                    int i2 = 0;
                    CustomDataLayer luvDataLayer = (CustomDataLayer)dataLayers.get(i2++);
                    luvDataLayer.setType(16);
                    luvDataLayer.setData(mLoopUVs.cast(Object.class));
                    CustomDataLayer lcolDataLayer = (CustomDataLayer)dataLayers.get(i2++);
                    lcolDataLayer.setType(17);
                    lcolDataLayer.setData(mLoopCols.cast(Object.class));
                    CustomDataLayer lDataLayer = (CustomDataLayer)dataLayers.get(i2++);
                    lDataLayer.setType(26);
                    lDataLayer.setData(mLoops.cast(Object.class));
                    CustomData lData = mesh.getLdata();
                    lData.setMaxlayer(i2);
                    lData.setTotlayer(i2);
                    lData.setLayers(dataLayers);
                    mesh.setMloop(mLoops);
                    mesh.setMloopuv(mLoopUVs);
                    mesh.setTotloop(this.loops.size());
                }
                if (!this.polys.isEmpty()) {
                    CArrayFacade<MPoly> mPolys = serializer.writeData(MPoly.class, this.polys.size(), (i, mPoly) -> this.polys.get((int)i).serialize((MPoly)mPoly));
                    CArrayFacade<MTexPoly> mTexPolys = serializer.writeData(MTexPoly.class, this.polys.size(), (i, mTexPoly) -> mTexPoly.setTpage((CPointer)images.get(this.polys.get((int)i.intValue()).materialSlot)));
                    CArrayFacade<CustomDataLayer> dataLayers = serializer.writeData(CustomDataLayer.class, mTexPolys != null ? 2 : 1);
                    int i3 = 0;
                    if (mTexPolys != null) {
                        CustomDataLayer pTexDataLayer = (CustomDataLayer)dataLayers.get(i3++);
                        pTexDataLayer.getName().fromString("UVMap");
                        pTexDataLayer.setType(15);
                        pTexDataLayer.setData(mTexPolys.cast(Object.class));
                    }
                    CustomDataLayer pDataLayer = (CustomDataLayer)dataLayers.get(i3++);
                    pDataLayer.setType(25);
                    pDataLayer.setData(mPolys.cast(Object.class));
                    CustomData pData = mesh.getPdata();
                    pData.setMaxlayer(i3);
                    pData.setTotlayer(i3);
                    pData.setLayers(dataLayers);
                    mesh.setMpoly(mPolys);
                    mesh.setMtpoly(mTexPolys);
                    mesh.setTotpoly(this.polys.size());
                }
            };
        });
    }

    public void addTriangle(Vertex v1, Vertex v2, Vertex v3, Vector2f uv1, Vector2f uv2, Vector2f uv3, int c1, int c2, int c3, int materialSlot) {
        int vOffset = this.vertices.size();
        int eOffset = this.edges.size();
        int lOffset = this.loops.size();
        this.vertices.add(v1);
        this.vertices.add(v2);
        this.vertices.add(v3);
        this.edges.add(new Edge(vOffset, vOffset + 1));
        this.edges.add(new Edge(vOffset + 1, vOffset + 2));
        this.edges.add(new Edge(vOffset + 2, vOffset));
        this.loops.add(new Loop(vOffset, eOffset, uv1.x, uv1.y, c1));
        this.loops.add(new Loop(vOffset + 1, eOffset + 1, uv2.x, uv2.y, c2));
        this.loops.add(new Loop(vOffset + 2, eOffset + 2, uv3.x, uv3.y, c3));
        this.polys.add(new Poly(lOffset, 3, materialSlot));
    }

    public void addQuad(Vertex v1, Vertex v2, Vertex v3, Vertex v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4, int c1, int c2, int c3, int c4, int materialSlot) {
        int vOffset = this.vertices.size();
        int eOffset = this.edges.size();
        int lOffset = this.loops.size();
        this.vertices.add(v1);
        this.vertices.add(v2);
        this.vertices.add(v3);
        this.vertices.add(v4);
        this.edges.add(new Edge(vOffset, vOffset + 1));
        this.edges.add(new Edge(vOffset + 1, vOffset + 2));
        this.edges.add(new Edge(vOffset + 2, vOffset + 3));
        this.edges.add(new Edge(vOffset + 3, vOffset));
        this.loops.add(new Loop(vOffset, eOffset, uv1.x, uv1.y, c1));
        this.loops.add(new Loop(vOffset + 1, eOffset + 1, uv2.x, uv2.y, c2));
        this.loops.add(new Loop(vOffset + 2, eOffset + 2, uv3.x, uv3.y, c3));
        this.loops.add(new Loop(vOffset + 3, eOffset + 3, uv4.x, uv4.y, c4));
        this.polys.add(new Poly(lOffset, 4, materialSlot));
    }

    public float getSizeX() {
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        for (Vertex vertex : this.vertices) {
            if (vertex.pos.x < minX) {
                minX = vertex.pos.x;
            }
            if (!(vertex.pos.x > maxX)) continue;
            maxX = vertex.pos.x;
        }
        return maxX - minX;
    }

    public boolean hasZeroLengthEdge(float delta) {
        float deltaSquared = delta * delta;
        Vector3f dst = new Vector3f();
        for (Edge edge : this.edges) {
            Vertex v1 = this.vertices.get(edge.v1);
            Vertex v2 = this.vertices.get(edge.v2);
            if (!(Vector3f.sub((Vector3f)v1.pos, (Vector3f)v2.pos, (Vector3f)dst).lengthSquared() < deltaSquared)) continue;
            return true;
        }
        return false;
    }

    public static class Edge {
        public int v1;
        public int v2;

        public Edge(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public void serialize(MEdge mEdge) throws IOException {
            mEdge.setV1(this.v1);
            mEdge.setV2(this.v2);
        }
    }

    public static class Loop {
        public int vertex;
        public int edge;
        public float u;
        public float v;
        public int col;

        public Loop(int vertex, int edge, float u, float v, int col) {
            this.vertex = vertex;
            this.edge = edge;
            this.u = u;
            this.v = v;
            this.col = col;
        }

        public void serialize(MLoop mLoop) throws IOException {
            mLoop.setV(this.vertex);
            mLoop.setE(this.edge);
        }

        public void serialize(MLoopUV mLoop) throws IOException {
            CArrayFacade uv = mLoop.getUv();
            uv.set(0, (Object)Float.valueOf(this.u));
            uv.set(1, (Object)Float.valueOf(this.v));
        }

        public void serialize(MLoopCol mLoop) throws IOException {
            mLoop.setR((byte)(this.col & 0xFF));
            mLoop.setG((byte)(this.col >> 8 & 0xFF));
            mLoop.setB((byte)(this.col >> 16 & 0xFF));
            mLoop.setA((byte)(this.col >> 24 & 0xFF));
        }
    }

    public static class Poly {
        public int loopStart;
        public int size;
        public short materialSlot;

        public Poly(int loopStart, int size, int materialSlot) {
            this.loopStart = loopStart;
            this.size = size;
            this.materialSlot = (short)materialSlot;
        }

        public void serialize(MPoly mPoly) throws IOException {
            mPoly.setLoopstart(this.loopStart);
            mPoly.setTotloop(this.size);
            mPoly.setMat_nr(this.materialSlot);
        }
    }

    public static class Vertex {
        public Vector3f pos;
        public short normX;
        public short normY;
        public short normZ;

        public Vertex(float x, float y, float z) {
            this.pos = new Vector3f(x, y, z);
        }

        public void serialize(MVert mVert) throws IOException {
            CArrayFacade pos = mVert.getCo();
            pos.set(0, (Object)Float.valueOf(this.pos.getX()));
            pos.set(1, (Object)Float.valueOf(this.pos.getY()));
            pos.set(2, (Object)Float.valueOf(this.pos.getZ()));
            CArrayFacade norm = mVert.getNo();
            norm.set(0, (Object)this.normX);
            norm.set(1, (Object)this.normY);
            norm.set(2, (Object)this.normZ);
        }
    }

    public static class Face {
        public int v1;
        public int v2;
        public int v3;
        public int v4;

        public Face(int v1, int v2, int v3, int v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }

        public void serialize(MFace mFace) throws IOException {
            mFace.setV1(this.v1);
            mFace.setV2(this.v2);
            mFace.setV3(this.v3);
            mFace.setV4(this.v4);
        }
    }
}

