/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.replaymod.render.hooks.ForceChunkLoadingHook;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.util.thread.ProcessorMailbox;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SectionRenderDispatcher.class})
public abstract class Mixin_BlockOnChunkRebuilds
implements ForceChunkLoadingHook.IBlockOnChunkRebuilds {
    @Shadow
    @Final
    private SectionBufferBuilderPool bufferPool;
    @Shadow
    @Final
    private ProcessorMailbox<Runnable> mailbox;
    @Shadow
    @Final
    private Queue<Runnable> toUpload;
    private final Lock waitingForWorkLock = new ReentrantLock();
    private final Condition newWork = this.waitingForWorkLock.newCondition();
    private volatile boolean allDone;
    private int totalBufferCount;

    @Unique
    private int getAvailableBufferCount() {
        return this.bufferPool.getFreeBufferCount();
    }

    @Unique
    private boolean upload() {
        Runnable runnable;
        boolean anything = false;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
            anything = true;
        }
        return anything;
    }

    @Shadow
    protected abstract void runTask();

    @Inject(method={"<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/renderer/LevelRenderer;Ljava/util/concurrent/Executor;Lnet/minecraft/client/renderer/RenderBuffers;Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;)V"}, at={@At(value="RETURN")})
    private void rememberTotalThreads(CallbackInfo ci) {
        this.totalBufferCount = this.getAvailableBufferCount();
    }

    @Inject(method={"runTask()V"}, at={@At(value="RETURN")})
    private void notifyMainThreadIfEverythingIsDone(CallbackInfo ci) {
        if (this.getAvailableBufferCount() == this.totalBufferCount) {
            this.waitingForWorkLock.lock();
            try {
                this.allDone = true;
                this.newWork.signalAll();
            }
            finally {
                this.waitingForWorkLock.unlock();
            }
        } else {
            this.allDone = false;
        }
    }

    @Inject(method={"uploadSectionLayer(Lcom/mojang/blaze3d/vertex/MeshData;Lcom/mojang/blaze3d/vertex/VertexBuffer;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private void notifyMainThreadOfNewUpload(CallbackInfoReturnable<CompletableFuture<Void>> ci) {
        this.waitingForWorkLock.lock();
        try {
            this.newWork.signal();
        }
        finally {
            this.waitingForWorkLock.unlock();
        }
    }

    private boolean waitForMainThreadWork() {
        boolean allDone = (Boolean)this.mailbox.ask(reply -> () -> {
            this.runTask();
            reply.tell((Object)(this.getAvailableBufferCount() == this.totalBufferCount ? 1 : 0));
        }).join();
        if (allDone) {
            return true;
        }
        this.waitingForWorkLock.lock();
        try {
            while (true) {
                RenderSystem.replayQueue();
                if (this.allDone) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.toUpload.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.newWork.awaitUninterruptibly();
            }
        }
        finally {
            this.waitingForWorkLock.unlock();
        }
    }

    @Override
    public boolean uploadEverythingBlocking() {
        boolean allChunksBuilt;
        boolean anything = false;
        do {
            allChunksBuilt = this.waitForMainThreadWork();
            while (this.upload()) {
                anything = true;
            }
        } while (!allChunksBuilt);
        return anything;
    }
}

