/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.replaymod.render.hooks.ForceChunkLoadingHook;
import com.replaymod.render.hooks.IForceChunkLoading;
import com.replaymod.render.mixin.ChunkRenderingDataPreparerAccessor;
import com.replaymod.render.utils.EmbeddiumFlawlessFramesHelper;
import com.replaymod.render.utils.SodiumFlawlessFramesHelper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SectionOcclusionGraph;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class Mixin_ForceChunkLoading
implements IForceChunkLoading {
    private ForceChunkLoadingHook replayModRender_hook;
    @Shadow
    private SectionRenderDispatcher sectionRenderDispatcher;
    @Shadow
    @Final
    private SectionOcclusionGraph sectionOcclusionGraph;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    private Frustum capturedFrustum;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Override
    public void replayModRender_setHook(ForceChunkLoadingHook hook) {
        this.replayModRender_hook = hook;
    }

    @Shadow
    protected abstract void setupRender(Camera var1, Frustum var2, boolean var3, boolean var4);

    @Shadow
    protected abstract void applyFrustum(Frustum var1);

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V")})
    private void forceAllChunks(CallbackInfo ci, @Local(argsOnly=true) Camera camera) {
        if (this.replayModRender_hook == null) {
            return;
        }
        if (EmbeddiumFlawlessFramesHelper.hasEmbeddium() && EmbeddiumFlawlessFramesHelper.supportFlawlessFrames()) {
            return;
        }
        if (SodiumFlawlessFramesHelper.hasSodium() && SodiumFlawlessFramesHelper.supportFlawlessFrames()) {
            return;
        }
        assert (this.minecraft.player != null);
        SectionOcclusionGraph renderingData = this.sectionOcclusionGraph;
        ChunkRenderingDataPreparerAccessor renderingDataAcc = (ChunkRenderingDataPreparerAccessor)renderingData;
        RenderRegionCache chunkRendererRegionBuilder = new RenderRegionCache();
        do {
            boolean areWeDoneYet = true;
            this.setupRender(camera, this.cullingFrustum, this.capturedFrustum != null, this.minecraft.player.isSpectator());
            Future<?> fullUpdateFuture = renderingDataAcc.fullUpdateFuture();
            if (fullUpdateFuture != null) {
                try {
                    fullUpdateFuture.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
            if (renderingData.consumeFrustumUpdate()) {
                this.applyFrustum(new Frustum(this.cullingFrustum).offsetToFullyIncludeCameraCube(8));
            }
            for (SectionRenderDispatcher.RenderSection builtChunk : renderingDataAcc.builtChunkStorage().sections) {
                if (!builtChunk.isDirty()) continue;
                if (builtChunk.hasAllNeighbors()) {
                    builtChunk.rebuildSectionAsync(this.sectionRenderDispatcher, chunkRendererRegionBuilder);
                    areWeDoneYet = false;
                }
                builtChunk.setNotDirty();
            }
            if (((ForceChunkLoadingHook.IBlockOnChunkRebuilds)this.sectionRenderDispatcher).uploadEverythingBlocking()) {
                areWeDoneYet = false;
            }
            if (areWeDoneYet) continue;
            renderingData.invalidate();
        } while (renderingDataAcc.shouldUpdate());
    }
}

