/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.rendering;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.mixin.TimerAccessor;
import com.replaymod.core.versions.MCVer;
import com.replaymod.pathing.player.AbstractTimelinePlayer;
import com.replaymod.pathing.player.ReplayTimer;
import com.replaymod.pathing.properties.TimestampProperty;
import com.replaymod.render.CameraPathExporter;
import com.replaymod.render.EXRWriter;
import com.replaymod.render.FFmpegWriter;
import com.replaymod.render.PNGWriter;
import com.replaymod.render.RenderSettings;
import com.replaymod.render.ReplayModRender;
import com.replaymod.render.blend.BlendState;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.events.ReplayRenderCallback;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.gui.GuiRenderingDone;
import com.replaymod.render.gui.GuiVideoRenderer;
import com.replaymod.render.gui.progress.VirtualWindow;
import com.replaymod.render.hooks.ForceChunkLoadingHook;
import com.replaymod.render.metadata.MetadataInjector;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.rendering.Pipeline;
import com.replaymod.render.rendering.Pipelines;
import com.replaymod.render.utils.EmbeddiumFlawlessFramesHelper;
import com.replaymod.render.utils.SodiumFlawlessFramesHelper;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.Timeline;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.fml.loading.LoadingModList;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.glfw.GLFW;

public class VideoRenderer
implements RenderInfo {
    private static final ResourceLocation SOUND_RENDER_SUCCESS = ResourceLocation.fromNamespaceAndPath((String)"replaymod", (String)"render_success");
    private final Minecraft mc = MCVer.getMinecraft();
    private final RenderSettings settings;
    private final ReplayHandler replayHandler;
    private final Timeline timeline;
    private final Pipeline renderingPipeline;
    private final FFmpegWriter ffmpegWriter;
    private final CameraPathExporter cameraPathExporter;
    private int fps;
    private boolean mouseWasGrabbed;
    private boolean debugInfoWasShown;
    private Map<SoundSource, Float> originalSoundLevels;
    private TimelinePlayer timelinePlayer;
    private Future<Void> timelinePlayerFuture;
    private ForceChunkLoadingHook forceChunkLoadingHook;
    private int framesDone;
    private int totalFrames;
    private final VirtualWindow guiWindow = new VirtualWindow(this.mc);
    private final GuiVideoRenderer gui;
    private boolean paused;
    private boolean cancelled;
    private volatile Throwable failureCause;

    public VideoRenderer(RenderSettings settings, ReplayHandler replayHandler, Timeline timeline) throws IOException {
        this.settings = settings;
        this.replayHandler = replayHandler;
        this.timeline = timeline;
        this.gui = new GuiVideoRenderer(this);
        if (settings.getRenderMethod() == RenderSettings.RenderMethod.BLEND) {
            BlendState.setState(new BlendState(settings.getOutputFile()));
            this.renderingPipeline = Pipelines.newBlendPipeline(this);
            this.ffmpegWriter = null;
        } else {
            final FrameConsumer<BitmapFrame> frameConsumer = settings.getEncodingPreset() == RenderSettings.EncodingPreset.EXR ? EXRWriter.create(settings.getOutputFile().toPath(), settings.isIncludeAlphaChannel()) : (settings.getEncodingPreset() == RenderSettings.EncodingPreset.PNG ? new PNGWriter(settings.getOutputFile().toPath(), settings.isIncludeAlphaChannel()) : new FFmpegWriter(this));
            this.ffmpegWriter = frameConsumer instanceof FFmpegWriter ? frameConsumer : null;
            FrameConsumer<BitmapFrame> previewingFrameConsumer = new FrameConsumer<BitmapFrame>(){
                private int lastFrameId = -1;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void consume(Map<Channel, BitmapFrame> channels) {
                    BitmapFrame bgra = channels.get((Object)Channel.BRGA);
                    if (bgra != null) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            int frameId = bgra.getFrameId();
                            if (this.lastFrameId < frameId) {
                                this.lastFrameId = frameId;
                                VideoRenderer.this.gui.updatePreview(bgra.getByteBuffer(), bgra.getSize());
                            }
                        }
                    }
                    frameConsumer.consume(channels);
                }

                @Override
                public void close() throws IOException {
                    frameConsumer.close();
                }

                @Override
                public boolean isParallelCapable() {
                    return frameConsumer.isParallelCapable();
                }
            };
            this.renderingPipeline = Pipelines.newPipeline(settings.getRenderMethod(), this, previewingFrameConsumer);
        }
        this.cameraPathExporter = settings.isCameraPathExport() ? new CameraPathExporter(settings) : null;
    }

    public boolean renderVideo() throws Throwable {
        int videoStart;
        ReplayRenderCallback.Pre.EVENT.invoker().beforeRendering(this);
        this.setup();
        this.drawGui();
        ReplayTimer timer = (ReplayTimer)((MinecraftAccessor)this.mc).getTimer();
        Optional<Integer> optionalVideoStartTime = this.timeline.getValue(TimestampProperty.PROPERTY, 0L);
        if (optionalVideoStartTime.isPresent() && (videoStart = optionalVideoStartTime.get().intValue()) > 1000) {
            int replayTime = videoStart - 1000;
            timer.tickDelta = 0.0f;
            ((TimerAccessor)((Object)timer)).setTickLength(50.0f);
            while (replayTime < videoStart) {
                this.replayHandler.getReplaySender().sendPacketsTill(replayTime += 50);
                this.tick();
            }
        }
        this.renderingPipeline.run();
        if (((MinecraftAccessor)this.mc).getCrashReporter() != null) {
            throw new ReportedException(((MinecraftAccessor)this.mc).getCrashReporter().get());
        }
        if (this.settings.isInjectSphericalMetadata()) {
            MetadataInjector.injectMetadata(this.settings.getRenderMethod(), this.settings.getOutputFile(), this.settings.getTargetVideoWidth(), this.settings.getTargetVideoHeight(), this.settings.getSphericalFovX(), this.settings.getSphericalFovY());
        }
        this.finish();
        ReplayRenderCallback.Post.EVENT.invoker().afterRendering(this);
        if (this.failureCause != null) {
            throw this.failureCause;
        }
        return !this.cancelled;
    }

    @Override
    public float updateForNextFrame() {
        this.guiWindow.bind();
        if (!this.settings.isHighPerformance() || this.framesDone % this.fps == 0) {
            while (this.drawGui() && this.paused) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        ReplayTimer timer = (ReplayTimer)((MinecraftAccessor)this.mc).getTimer();
        int elapsedTicks = timer.advanceTime(MCVer.milliTime(), true);
        this.executeTaskQueue();
        while (elapsedTicks-- > 0) {
            this.tick();
        }
        this.guiWindow.unbind();
        if (this.cameraPathExporter != null) {
            this.cameraPathExporter.recordFrame(timer.tickDelta);
        }
        ++this.framesDone;
        return timer.tickDelta;
    }

    @Override
    public RenderSettings getRenderSettings() {
        return this.settings;
    }

    private void setup() {
        this.timelinePlayer = new TimelinePlayer(this.replayHandler);
        this.timelinePlayerFuture = this.timelinePlayer.start(this.timeline);
        if (this.mc.getDebugOverlay().showDebugScreen()) {
            this.debugInfoWasShown = true;
            this.mc.getDebugOverlay().toggleOverlay();
        }
        if (this.mc.mouseHandler.isMouseGrabbed()) {
            this.mouseWasGrabbed = true;
        }
        this.mc.mouseHandler.releaseMouse();
        this.originalSoundLevels = new EnumMap<SoundSource, Float>(SoundSource.class);
        for (SoundSource category : SoundSource.values()) {
            if (category == SoundSource.MASTER) continue;
            this.originalSoundLevels.put(category, Float.valueOf(this.mc.options.getSoundSourceVolume(category)));
            this.mc.options.getSoundSourceOptionInstance(category).set((Object)0.0);
        }
        this.fps = this.settings.getFramesPerSecond();
        long duration = 0L;
        for (Path path : this.timeline.getPaths()) {
            if (!path.isActive()) continue;
            path.updateAll();
            Collection<Keyframe> keyframes = path.getKeyframes();
            if (keyframes.size() <= 0) continue;
            duration = Math.max(duration, ((Keyframe)Iterables.getLast(keyframes)).getTime());
        }
        this.totalFrames = (int)(duration * (long)this.fps / 1000L);
        if (this.cameraPathExporter != null) {
            this.cameraPathExporter.setup(this.totalFrames);
        }
        this.gui.toMinecraft().init(this.mc, this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight());
        this.forceChunkLoadingHook = new ForceChunkLoadingHook(this.mc.levelRenderer);
    }

    private void finish() {
        if (!this.timelinePlayerFuture.isDone()) {
            this.timelinePlayerFuture.cancel(false);
        }
        this.timelinePlayer.onTick();
        this.guiWindow.close();
        if (this.debugInfoWasShown) {
            this.mc.getDebugOverlay().toggleOverlay();
        }
        if (this.mouseWasGrabbed) {
            this.mc.mouseHandler.grabMouse();
        }
        for (Map.Entry<SoundSource, Float> entry : this.originalSoundLevels.entrySet()) {
            this.mc.options.getSoundSourceOptionInstance(entry.getKey()).set((Object)entry.getValue().floatValue());
        }
        this.mc.setScreen(null);
        this.forceChunkLoadingHook.uninstall();
        if (!this.hasFailed() && this.cameraPathExporter != null) {
            try {
                this.cameraPathExporter.finish();
            }
            catch (IOException e) {
                this.setFailure(e);
            }
        }
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvent.createVariableRangeEvent((ResourceLocation)SOUND_RENDER_SUCCESS), (float)1.0f));
        try {
            if (!this.hasFailed() && this.ffmpegWriter != null) {
                new GuiRenderingDone(ReplayModRender.instance, this.ffmpegWriter.getVideoFile(), this.totalFrames, this.settings).display();
            }
        }
        catch (FFmpegWriter.FFmpegStartupException e) {
            this.setFailure(e);
        }
        MCVer.resizeMainWindow(this.mc, this.guiWindow.getFramebufferWidth(), this.guiWindow.getFramebufferHeight());
    }

    private void executeTaskQueue() {
        while (true) {
            if (this.mc.getOverlay() != null) {
                this.drawGui();
                ((MCVer.MinecraftMethodAccessor)this.mc).replayModExecuteTaskQueue();
                continue;
            }
            CompletableFuture<Void> resourceReloadFuture = ((MinecraftAccessor)this.mc).getPendingReload();
            if (resourceReloadFuture == null) break;
            ((MinecraftAccessor)this.mc).setPendingReload(null);
            this.mc.reloadResourcePacks().thenRun(() -> resourceReloadFuture.complete(null));
        }
        ((MCVer.MinecraftMethodAccessor)this.mc).replayModExecuteTaskQueue();
        this.mc.screen = this.gui.toMinecraft();
    }

    private void tick() {
        this.mc.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawGui() {
        Window window = this.mc.getWindow();
        if (GLFW.glfwWindowShouldClose((long)window.getWindow()) || ((MinecraftAccessor)this.mc).getCrashReporter() != null) {
            return false;
        }
        MCVer.pushMatrix();
        RenderSystem.clear((int)16640, (boolean)false);
        this.guiWindow.beginWrite();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        RenderSystem.setProjectionMatrix((Matrix4f)MCVer.ortho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), 0.0f, (float)((double)window.getHeight() / window.getGuiScale()), 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.translation(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        this.gui.toMinecraft().init(this.mc, window.getGuiScaledWidth(), window.getGuiScaledHeight());
        int mouseX = (int)this.mc.mouseHandler.xpos() * window.getGuiScaledWidth() / Math.max(window.getScreenWidth(), 1);
        int mouseY = (int)this.mc.mouseHandler.ypos() * window.getGuiScaledHeight() / Math.max(window.getScreenHeight(), 1);
        GuiGraphics drawContext = new GuiGraphics(this.mc, this.mc.renderBuffers().bufferSource());
        if (this.mc.getOverlay() != null) {
            Screen orgScreen = this.mc.screen;
            try {
                this.mc.screen = this.gui.toMinecraft();
                this.mc.getOverlay().render(new GuiGraphics(this.mc, this.mc.renderBuffers().bufferSource()), mouseX, mouseY, 0.0f);
            }
            finally {
                this.mc.screen = orgScreen;
            }
        } else {
            this.gui.toMinecraft().tick();
            this.gui.toMinecraft().render(drawContext, mouseX, mouseY, 0.0f);
        }
        drawContext.flush();
        this.guiWindow.endWrite();
        MCVer.popMatrix();
        MCVer.pushMatrix();
        this.guiWindow.flip();
        MCVer.popMatrix();
        if (this.mc.mouseHandler.isMouseGrabbed()) {
            this.mc.mouseHandler.releaseMouse();
        }
        return !this.hasFailed() && !this.cancelled;
    }

    @Override
    public int getFramesDone() {
        return this.framesDone;
    }

    @Override
    public ReadableDimension getFrameSize() {
        return new Dimension(this.settings.getVideoWidth(), this.settings.getVideoHeight());
    }

    @Override
    public int getTotalFrames() {
        return this.totalFrames;
    }

    public int getVideoTime() {
        return this.framesDone * 1000 / this.fps;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void cancel() {
        if (this.ffmpegWriter != null) {
            this.ffmpegWriter.abort();
        }
        this.cancelled = true;
        this.renderingPipeline.cancel();
    }

    public boolean hasFailed() {
        return this.failureCause != null;
    }

    public synchronized void setFailure(Throwable cause) {
        if (this.failureCause != null) {
            ReplayModRender.LOGGER.error("Further failure during failed rendering: ", cause);
        } else {
            ReplayModRender.LOGGER.error("Failure during rendering: ", cause);
            this.failureCause = cause;
            this.cancel();
        }
    }

    public static String[] checkCompat(Stream<RenderSettings> settings) {
        return settings.map(VideoRenderer::checkCompat).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static String[] checkCompat(RenderSettings settings) {
        if (EmbeddiumFlawlessFramesHelper.hasEmbeddium() && !EmbeddiumFlawlessFramesHelper.supportFlawlessFrames()) {
            return new String[]{"Rendering is not supported with your Embeddium version.", "It is missing support for the FREX Flawless Frames API.", "Please use a more up to date Embeddium version!"};
        }
        if (SodiumFlawlessFramesHelper.hasSodium() && !SodiumFlawlessFramesHelper.supportFlawlessFrames()) {
            return new String[]{"Rendering is not supported with your Sodium version.", "It is missing support for the FREX Flawless Frames API.", "Please use a more up to date Sodium version!"};
        }
        if (settings.getRenderMethod() == RenderSettings.RenderMethod.ODS && LoadingModList.get().getModFileById("iris") == null) {
            return new String[]{"ODS export requires Iris to be installed for Minecraft 1.17 and above.", "Note that it is nevertheless incompatible with other shaders and will simply replace them.", "Get it from: https://irisshaders.net/"};
        }
        return null;
    }

    private class TimelinePlayer
    extends AbstractTimelinePlayer {
        public TimelinePlayer(ReplayHandler replayHandler) {
            super(replayHandler);
        }

        @Override
        public long getTimePassed() {
            return VideoRenderer.this.getVideoTime();
        }
    }
}

