/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.shader;

import com.replaymod.core.versions.MCVer;
import java.io.InputStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;

public class Program {
    private final int program;

    public Program(ResourceLocation vertexShader, ResourceLocation fragmentShader) throws Exception {
        int vertShader = this.createShader(vertexShader, 35633);
        int fragShader = this.createShader(fragmentShader, 35632);
        this.program = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.program == 0) {
            throw new Exception("glCreateProgramObjectARB failed");
        }
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)vertShader);
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)fragShader);
        ARBShaderObjects.glLinkProgramARB((int)this.program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35714) == 0) {
            throw new Exception("Error linking: " + Program.getLogInfo(this.program));
        }
        ARBShaderObjects.glValidateProgramARB((int)this.program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35715) == 0) {
            throw new Exception("Error validating: " + Program.getLogInfo(this.program));
        }
    }

    private int createShader(ResourceLocation resourceLocation, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                throw new Exception("glCreateShaderObjectARB failed");
            }
            Resource resource = MCVer.getMinecraft().getResourceManager().getResourceOrThrow(resourceLocation);
            try (InputStream is = resource.open();){
                ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)IOUtils.toString((InputStream)is));
            }
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + Program.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public void use() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.program);
    }

    public void stopUsing() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public void delete() {
        ARBShaderObjects.glDeleteObjectARB((int)this.program);
    }

    public Uniform getUniformVariable(String name) {
        return new Uniform(this, ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name));
    }

    public class Uniform {
        private final int location;

        public Uniform(Program this$0, int location) {
            this.location = location;
        }

        public void set(boolean bool) {
            ARBShaderObjects.glUniform1iARB((int)this.location, (int)(bool ? 1 : 0));
        }

        public void set(int integer) {
            ARBShaderObjects.glUniform1iARB((int)this.location, (int)integer);
        }
    }
}

