/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.mixin.TimerAccessor;
import com.replaymod.core.utils.Restrictions;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.FullReplaySender;
import com.replaymod.replay.QuickReplaySender;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.ReplaySender;
import com.replaymod.replay.camera.CameraEntity;
import com.replaymod.replay.camera.SpectatorCameraController;
import com.replaymod.replay.events.ReplayClosedCallback;
import com.replaymod.replay.events.ReplayClosingCallback;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replay.gui.overlay.GuiReplayOverlay;
import com.replaymod.replay.mixin.EntityLivingBaseAccessor;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.util.Location;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.advanced.GuiProgressBar;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.popup.AbstractGuiPopup;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.resources.server.ServerPackManager;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ReplayHandler {
    public static final String PACKET_HANDLER_NAME = "ReplayModReplay_packetHandler";
    private static Minecraft mc = MCVer.getMinecraft();
    private final ReplayFile replayFile;
    private final FullReplaySender fullReplaySender;
    private final QuickReplaySender quickReplaySender;
    private boolean quickMode = false;
    private Restrictions restrictions = new Restrictions();
    private boolean suppressCameraMovements;
    private Set<Marker> markers;
    private final GuiReplayOverlay overlay;
    private EmbeddedChannel channel;
    private int replayDuration;
    private Location targetCameraPosition;
    private UUID spectating;

    public ReplayHandler(ReplayFile replayFile, boolean asyncMode) throws IOException {
        Preconditions.checkState((boolean)mc.isSameThread(), (Object)"Must be called from Minecraft thread.");
        this.replayFile = replayFile;
        this.replayDuration = replayFile.getMetaData().getDuration();
        this.markers = replayFile.getMarkers().or(Collections.emptySet());
        this.fullReplaySender = new FullReplaySender(this, replayFile);
        this.quickReplaySender = new QuickReplaySender(ReplayModReplay.instance, replayFile);
        this.setup();
        this.overlay = new GuiReplayOverlay(this);
        this.overlay.setVisible(true);
        ReplayOpenedCallback.EVENT.invoker().replayOpened(this);
        this.fullReplaySender.setAsyncMode(asyncMode);
    }

    void restartedReplay() {
        Preconditions.checkState((boolean)mc.isSameThread(), (Object)"Must be called from Minecraft thread.");
        this.channel.close();
        ReplayHandler.mc.mouseHandler.releaseMouse();
        mc.disconnect();
        this.restrictions = new Restrictions();
        this.setup();
    }

    public void endReplay() throws IOException {
        Preconditions.checkState((boolean)mc.isSameThread(), (Object)"Must be called from Minecraft thread.");
        ReplayClosingCallback.EVENT.invoker().replayClosing(this);
        this.fullReplaySender.terminateReplay();
        if (this.quickMode) {
            this.quickReplaySender.unregister();
        }
        this.replayFile.save();
        this.replayFile.close();
        this.channel.close().awaitUninterruptibly();
        if (ReplayHandler.mc.player instanceof CameraEntity) {
            // empty if block
        }
        if (ReplayHandler.mc.level != null) {
            mc.disconnect();
        }
        TimerAccessor timer = (TimerAccessor)((MinecraftAccessor)mc).getTimer();
        timer.setTickLength(50.0f);
        this.overlay.setVisible(false);
        ReplayModReplay.instance.forcefullyStopReplay();
        mc.setScreen(null);
        ReplayClosedCallback.EVENT.invoker().replayClosed(this);
    }

    private void setup() {
        Preconditions.checkState((boolean)mc.isSameThread(), (Object)"Must be called from Minecraft thread.");
        ReplayHandler.mc.gui.getChat().clearMessages(false);
        Connection networkManager = new Connection(this, PacketFlow.CLIENTBOUND){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
                t.printStackTrace();
            }
        };
        this.channel = new EmbeddedChannel();
        this.channel.pipeline().addFirst("ReplayModReplay_head", (ChannelHandler)new DropOutboundMessagesHandler());
        this.quickReplaySender.setChannel((Channel)this.channel);
        this.fullReplaySender.setChannel((Channel)this.channel);
        this.channel.pipeline().addLast("inbound_config", (ChannelHandler)new UnconfiguredPipelineHandler.Inbound());
        this.channel.pipeline().addLast("outbound_config", (ChannelHandler)new UnconfiguredPipelineHandler.Outbound());
        this.channel.pipeline().addLast(PACKET_HANDLER_NAME, (ChannelHandler)(this.quickMode ? this.quickReplaySender : this.fullReplaySender));
        this.channel.pipeline().addLast("packet_handler", (ChannelHandler)networkManager);
        this.channel.pipeline().fireChannelActive();
        networkManager.setupInboundProtocol(LoginProtocols.CLIENTBOUND, (PacketListener)new ClientHandshakePacketListenerImpl(networkManager, mc, null, null, false, null, it -> {}, null));
        networkManager.setupOutboundProtocol(LoginProtocols.SERVERBOUND);
        ((MinecraftAccessor)mc).setConnection(networkManager);
        mc.getDownloadedPackSource().configureForServerControl(networkManager, ServerPackManager.PackPromptStatus.ALLOWED);
    }

    public ReplayFile getReplayFile() {
        return this.replayFile;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public ReplaySender getReplaySender() {
        return this.quickMode ? this.quickReplaySender : this.fullReplaySender;
    }

    public GuiReplayOverlay getOverlay() {
        return this.overlay;
    }

    public void ensureQuickModeInitialized(final Runnable andThen) {
        if (Utils.ifMinimalModeDoPopup(this.overlay, () -> {})) {
            return;
        }
        ListenableFuture<Void> future = this.quickReplaySender.getInitializationPromise();
        if (future == null) {
            final InitializingQuickModePopup popup = new InitializingQuickModePopup(this, this.overlay);
            future = this.quickReplaySender.initialize(progress -> popup.progressBar.setProgress(progress.floatValue()));
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                    popup.close();
                }

                public void onFailure(@Nonnull Throwable t) {
                    String message = "Failed to initialize quick mode. It will not be available.";
                    Utils.error(ReplayModReplay.LOGGER, ReplayHandler.this.overlay, CrashReport.forThrowable((Throwable)t, (String)message), popup::close);
                }
            }, Runnable::run);
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                andThen.run();
            }

            public void onFailure(@Nonnull Throwable t) {
            }
        }, Runnable::run);
    }

    public void setQuickMode(boolean quickMode) {
        if (ReplayMod.isMinimalMode()) {
            throw new UnsupportedOperationException("Quick Mode not supported in minimal mode.");
        }
        if (quickMode == this.quickMode) {
            return;
        }
        if (quickMode && this.fullReplaySender.isAsyncMode()) {
            throw new IllegalStateException("Cannot switch to quick mode while in async mode.");
        }
        this.quickMode = quickMode;
        CameraEntity cam = this.getCameraEntity();
        this.targetCameraPosition = cam != null ? new Location(cam.getX(), cam.getY(), cam.getZ(), cam.getYRot(), cam.getXRot()) : null;
        this.channel.pipeline().replace(PACKET_HANDLER_NAME, PACKET_HANDLER_NAME, (ChannelHandler)(quickMode ? this.quickReplaySender : this.fullReplaySender));
        if (quickMode) {
            this.quickReplaySender.register();
            this.quickReplaySender.restart();
            this.quickReplaySender.sendPacketsTill(this.fullReplaySender.currentTimeStamp());
        } else {
            this.quickReplaySender.unregister();
            this.fullReplaySender.sendPacketsTill(0);
            this.fullReplaySender.sendPacketsTill(this.quickReplaySender.currentTimeStamp());
        }
        this.moveCameraToTargetPosition();
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public int getReplayDuration() {
        return this.replayDuration;
    }

    public boolean shouldSuppressCameraMovements() {
        return this.suppressCameraMovements;
    }

    public void setSuppressCameraMovements(boolean suppressCameraMovements) {
        this.suppressCameraMovements = suppressCameraMovements;
    }

    public void spectateEntity(Entity e) {
        CameraEntity cameraEntity = this.getCameraEntity();
        if (cameraEntity == null) {
            return;
        }
        if (e == null || e == cameraEntity) {
            this.spectating = null;
            e = cameraEntity;
        } else if (e instanceof Player) {
            this.spectating = e.getUUID();
        }
        if (e == cameraEntity) {
            cameraEntity.setCameraController(ReplayModReplay.instance.createCameraController(cameraEntity));
        } else {
            cameraEntity.setCameraController(new SpectatorCameraController(cameraEntity));
        }
        if (mc.getCameraEntity() != e) {
            mc.setCameraEntity(e);
            cameraEntity.setCameraPosRot((Entity)e);
        }
    }

    public void spectateCamera() {
        this.spectateEntity(null);
    }

    public boolean isCameraView() {
        return ReplayHandler.mc.player instanceof CameraEntity && ReplayHandler.mc.player == mc.getCameraEntity();
    }

    public CameraEntity getCameraEntity() {
        return ReplayHandler.mc.player instanceof CameraEntity ? (CameraEntity)ReplayHandler.mc.player : null;
    }

    public UUID getSpectatedUUID() {
        return this.spectating;
    }

    public void moveCameraToTargetPosition() {
        CameraEntity cam = this.getCameraEntity();
        if (cam != null && this.targetCameraPosition != null) {
            cam.setCameraPosRot(this.targetCameraPosition);
        }
    }

    public void doJump(int targetTime, boolean retainCameraPosition) {
        long diff;
        if (!this.getReplaySender().isAsyncMode()) {
            return;
        }
        if (this.getReplaySender() == this.quickReplaySender) {
            if ((targetTime += targetTime % 50) >= 50) {
                this.quickReplaySender.sendPacketsTill(targetTime - 50);
            }
            for (Entity entity : ReplayHandler.mc.level.entitiesForRendering()) {
                this.skipTeleportInterpolation(entity);
                entity.xOld = entity.xo = entity.getX();
                entity.yOld = entity.yo = entity.getY();
                entity.zOld = entity.zo = entity.getZ();
                entity.yRotO = entity.getYRot();
                entity.xRotO = entity.getXRot();
            }
            mc.tick();
            this.quickReplaySender.sendPacketsTill(targetTime);
            for (Entity entity : ReplayHandler.mc.level.entitiesForRendering()) {
                this.skipTeleportInterpolation(entity);
            }
            return;
        }
        FullReplaySender replaySender = this.fullReplaySender;
        if (replaySender.isHurrying()) {
            return;
        }
        if (targetTime < replaySender.currentTimeStamp()) {
            mc.setScreen(null);
        }
        if (retainCameraPosition) {
            CameraEntity cam = this.getCameraEntity();
            this.targetCameraPosition = cam != null ? new Location(cam.getX(), cam.getY(), cam.getZ(), cam.getYRot(), cam.getXRot()) : null;
        }
        if ((diff = (long)targetTime - (replaySender.isHurrying() ? replaySender.getDesiredTimestamp() : (long)replaySender.currentTimeStamp())) != 0L) {
            if (diff > 0L && diff < 5000L) {
                if (replaySender.paused()) {
                    replaySender.setSyncModeAndWait();
                    do {
                        replaySender.sendPacketsTill(targetTime);
                        targetTime += 500;
                    } while (ReplayHandler.mc.player == null || ReplayHandler.mc.screen instanceof ReceivingLevelScreen);
                    replaySender.setAsyncMode(true);
                    int i = 0;
                    while ((long)i < Math.min(diff / 50L, 3L)) {
                        mc.tick();
                        ++i;
                    }
                } else {
                    replaySender.jumpToTime(targetTime);
                }
            } else {
                GuiScreen guiScreen = new GuiScreen();
                guiScreen.setBackground(AbstractGuiScreen.Background.DIRT);
                guiScreen.setLayout(new HorizontalLayout(HorizontalLayout.Alignment.CENTER));
                guiScreen.addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.pleasewait", new Object[0])});
                replaySender.setSyncModeAndWait();
                MCVer.pushMatrix();
                RenderSystem.clear((int)16640, (boolean)true);
                mc.getMainRenderTarget().bindWrite(true);
                Window window = mc.getWindow();
                RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
                RenderSystem.setProjectionMatrix((Matrix4f)MCVer.ortho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), 0.0f, (float)((double)window.getHeight() / window.getGuiScale()), 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
                Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
                matrixStack.translation(0.0f, 0.0f, -2000.0f);
                RenderSystem.applyModelViewMatrix();
                Lighting.setupFor3DItems();
                guiScreen.toMinecraft().init(mc, window.getGuiScaledWidth(), window.getGuiScaledHeight());
                GuiGraphics drawContext = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
                guiScreen.toMinecraft().render(drawContext, 0, 0, 0.0f);
                drawContext.flush();
                guiScreen.toMinecraft().removed();
                mc.getMainRenderTarget().unbindWrite();
                MCVer.popMatrix();
                MCVer.pushMatrix();
                mc.getMainRenderTarget().blitToScreen(mc.getWindow().getWidth(), mc.getWindow().getHeight());
                MCVer.popMatrix();
                mc.getWindow().updateDisplay();
                do {
                    replaySender.sendPacketsTill(targetTime);
                    targetTime += 500;
                } while (ReplayHandler.mc.player == null || ReplayHandler.mc.screen instanceof ReceivingLevelScreen);
                replaySender.setAsyncMode(true);
                replaySender.setReplaySpeed(0.0);
                mc.getConnection().getConnection().tick();
                if (ReplayHandler.mc.level == null) {
                    return;
                }
                for (Entity entity : ReplayHandler.mc.level.entitiesForRendering()) {
                    this.skipTeleportInterpolation(entity);
                    entity.xOld = entity.xo = entity.getX();
                    entity.yOld = entity.yo = entity.getY();
                    entity.zOld = entity.zo = entity.getZ();
                    entity.yRotO = entity.getYRot();
                    entity.xRotO = entity.getXRot();
                }
                mc.tick();
                this.moveCameraToTargetPosition();
            }
        }
    }

    private void skipTeleportInterpolation(Entity entity) {
        if (entity instanceof LivingEntity && !(entity instanceof CameraEntity)) {
            LivingEntity e = (LivingEntity)entity;
            EntityLivingBaseAccessor ea = (EntityLivingBaseAccessor)e;
            e.absMoveTo(ea.getInterpTargetX(), ea.getInterpTargetY(), ea.getInterpTargetZ());
            e.setYRot((float)ea.getInterpTargetYaw());
            e.setXRot((float)ea.getInterpTargetPitch());
        }
    }

    private static class DropOutboundMessagesHandler
    extends ChannelOutboundHandlerAdapter {
        private DropOutboundMessagesHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            promise.setSuccess();
        }

        public void flush(ChannelHandlerContext ctx) {
        }
    }

    private class InitializingQuickModePopup
    extends AbstractGuiPopup<InitializingQuickModePopup> {
        private final GuiProgressBar progressBar;

        public InitializingQuickModePopup(ReplayHandler replayHandler, GuiContainer container) {
            super(container);
            this.progressBar = (GuiProgressBar)((GuiProgressBar)new GuiProgressBar(this.popup).setSize(300, 20)).setI18nLabel("replaymod.gui.loadquickmode", new Object[0]);
            this.open();
        }

        @Override
        public void close() {
            super.close();
        }

        @Override
        protected InitializingQuickModePopup getThis() {
            return this;
        }
    }
}

