/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.Module;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.ModCompat;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.NoGuiScreenshot;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.Setting;
import com.replaymod.replay.camera.CameraController;
import com.replaymod.replay.camera.CameraControllerRegistry;
import com.replaymod.replay.camera.CameraEntity;
import com.replaymod.replay.camera.ClassicCameraController;
import com.replaymod.replay.camera.VanillaCameraController;
import com.replaymod.replay.gui.screen.GuiModCompatWarning;
import com.replaymod.replay.handler.GuiHandler;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.replay.ReplayFile;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplayModReplay
implements Module {
    public static ReplayModReplay instance;
    private ReplayMod core;
    public KeyBindingRegistry.Binding keyPlayPause;
    private final CameraControllerRegistry cameraControllerRegistry;
    public static Logger LOGGER;
    private ReplayHandler replayHandler;

    public ReplayHandler getReplayHandler() {
        return this.replayHandler;
    }

    public ReplayModReplay(ReplayMod core) {
        instance = this;
        this.cameraControllerRegistry = new CameraControllerRegistry();
        this.core = core;
        core.getSettingsRegistry().register(Setting.class);
    }

    @Override
    public void registerKeyBindings(KeyBindingRegistry registry) {
        registry.registerKeyBinding("replaymod.input.marker", 77, new Runnable(){

            @Override
            public void run() {
                CameraEntity camera;
                if (ReplayModReplay.this.replayHandler != null && (camera = ReplayModReplay.this.replayHandler.getCameraEntity()) != null) {
                    Marker marker = new Marker();
                    marker.setTime(ReplayModReplay.this.replayHandler.getReplaySender().currentTimeStamp());
                    marker.setX(camera.getX());
                    marker.setY(camera.getY());
                    marker.setZ(camera.getZ());
                    marker.setYaw(camera.getYRot());
                    marker.setPitch(camera.getXRot());
                    marker.setRoll(camera.roll);
                    ReplayModReplay.this.replayHandler.getOverlay().timeline.addMarker(marker);
                }
            }
        }, true);
        registry.registerKeyBinding("replaymod.input.thumbnail", 78, new Runnable(){

            @Override
            public void run() {
                if (ReplayModReplay.this.replayHandler != null) {
                    Minecraft mc = MCVer.getMinecraft();
                    ListenableFuture<NoGuiScreenshot> future = NoGuiScreenshot.take(mc, 1280, 720);
                    Futures.addCallback(future, (FutureCallback)new FutureCallback<NoGuiScreenshot>(){

                        public void onSuccess(NoGuiScreenshot result) {
                            try {
                                ReplayModReplay.this.core.printInfoToChat("replaymod.chat.savingthumb", new Object[0]);
                                BufferedImage image = result.getImage().toBufferedImage();
                                BufferedImage bgrImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                                Graphics graphics = bgrImage.getGraphics();
                                graphics.drawImage(image, 0, 0, null);
                                graphics.dispose();
                                ReplayModReplay.this.replayHandler.getReplayFile().writeThumb(bgrImage);
                                ReplayModReplay.this.core.printInfoToChat("replaymod.chat.savedthumb", new Object[0]);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                        public void onFailure(Throwable t) {
                            t.printStackTrace();
                            ReplayModReplay.this.core.printWarningToChat("replaymod.chat.failedthumb", new Object[0]);
                        }
                    }, Runnable::run);
                }
            }
        }, true);
        this.keyPlayPause = registry.registerKeyBinding("replaymod.input.playpause", 80, new Runnable(){

            @Override
            public void run() {
                if (ReplayModReplay.this.replayHandler != null) {
                    ReplayModReplay.this.replayHandler.getOverlay().playPauseButton.onClick();
                }
            }
        }, true);
        this.core.getKeyBindingRegistry().registerKeyBinding("replaymod.input.rollclockwise", 76, () -> {}, true);
        this.core.getKeyBindingRegistry().registerKeyBinding("replaymod.input.rollcounterclockwise", 74, () -> {}, true);
        this.core.getKeyBindingRegistry().registerKeyBinding("replaymod.input.resettilt", 75, () -> Optional.ofNullable(this.replayHandler).map(ReplayHandler::getCameraEntity).ifPresent(c -> {
            c.roll = 0.0f;
        }), true);
    }

    @Override
    public void initClient() {
        this.cameraControllerRegistry.register("replaymod.camera.classic", new Function<CameraEntity, CameraController>(this){

            @Nullable
            public CameraController apply(CameraEntity cameraEntity) {
                return new ClassicCameraController(cameraEntity);
            }
        });
        this.cameraControllerRegistry.register("replaymod.camera.vanilla", new Function<CameraEntity, CameraController>(){

            @Nullable
            public CameraController apply(@Nullable CameraEntity cameraEntity) {
                return new VanillaCameraController(ReplayModReplay.this.core.getMinecraft(), cameraEntity);
            }
        });
        new GuiHandler(this).register();
    }

    public void startReplay(File file) throws IOException {
        this.startReplay(this.core.files.open(file.toPath()));
    }

    public void startReplay(ReplayFile replayFile) throws IOException {
        this.startReplay(replayFile, true, true);
    }

    public ReplayHandler startReplay(ReplayFile replayFile, boolean checkModCompat, boolean asyncMode) throws IOException {
        ModCompat.ModInfoDifference modDifference;
        if (this.replayHandler != null) {
            this.replayHandler.endReplay();
        }
        if (!(!checkModCompat || (modDifference = new ModCompat.ModInfoDifference(replayFile.getModInfo())).getMissing().isEmpty() && modDifference.getDiffering().isEmpty())) {
            GuiModCompatWarning screen = new GuiModCompatWarning(modDifference);
            screen.loadButton.onClick(() -> {
                try {
                    this.startReplay(replayFile, false, asyncMode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            screen.display();
            return null;
        }
        this.replayHandler = new ReplayHandler(replayFile, asyncMode);
        KeyMapping.resetMapping();
        return this.replayHandler;
    }

    public void forcefullyStopReplay() {
        this.replayHandler = null;
        KeyMapping.resetMapping();
    }

    public ReplayMod getCore() {
        return this.core;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public CameraControllerRegistry getCameraControllerRegistry() {
        return this.cameraControllerRegistry;
    }

    public CameraController createCameraController(CameraEntity cameraEntity) {
        String controllerName = this.core.getSettingsRegistry().get(Setting.CAMERA);
        return this.cameraControllerRegistry.create(controllerName, cameraEntity);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

