/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.camera;

import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.events.KeyBindingEventCallback;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.events.PreRenderHandCallback;
import com.replaymod.core.events.SettingsChangedCallback;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.Setting;
import com.replaymod.replay.camera.CameraController;
import com.replaymod.replay.camera.SpectatorCameraController;
import com.replaymod.replay.events.RenderHotbarCallback;
import com.replaymod.replay.events.RenderSpectatorCrosshairCallback;
import com.replaymod.replay.mixin.EntityPlayerAccessor;
import com.replaymod.replay.mixin.FirstPersonRendererAccessor;
import com.replaymod.replaystudio.util.Location;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CameraEntity
extends LocalPlayer {
    private static final UUID CAMERA_UUID = UUID.nameUUIDFromBytes("ReplayModCamera".getBytes(StandardCharsets.UTF_8));
    public float roll;
    private CameraController cameraController;
    private long lastControllerUpdate = System.currentTimeMillis();
    private Entity lastHandRendered = null;
    private EventHandler eventHandler = new EventHandler();
    private final Inventory originalInventory = this.getInventory();

    public CameraEntity(Minecraft mcIn, ClientLevel worldIn, ClientPacketListener netHandlerPlayClient, StatsCounter statisticsManager, ClientRecipeBook recipeBook) {
        super(mcIn, worldIn, netHandlerPlayClient, statisticsManager, recipeBook, false, false);
        this.setUUID(CAMERA_UUID);
        this.eventHandler.register();
        this.cameraController = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID() == null ? ReplayModReplay.instance.createCameraController(this) : new SpectatorCameraController(this);
    }

    public CameraController getCameraController() {
        return this.cameraController;
    }

    public void setCameraController(CameraController cameraController) {
        this.cameraController = cameraController;
    }

    public void moveCamera(double x, double y, double z) {
        this.setCameraPosition(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public void setCameraPosition(double x, double y, double z) {
        this.xOld = this.xo = x;
        this.yOld = this.yo = y;
        this.zOld = this.zo = z;
        this.setPosRaw(x, y, z);
        this.updateBoundingBox();
    }

    public void setCameraRotation(float yaw, float pitch, float roll) {
        this.yRotO = yaw;
        this.xRotO = pitch;
        this.setYRot(yaw);
        this.setXRot(pitch);
        this.roll = roll;
    }

    public void setCameraPosRot(Location pos) {
        this.setCameraRotation(pos.getYaw(), pos.getPitch(), this.roll);
        this.setCameraPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public void setCameraPosRot(Entity to) {
        if (to == this) {
            return;
        }
        float yOffset = 0.0f;
        this.xo = to.xo;
        this.yo = to.yo + (double)yOffset;
        this.zo = to.zo;
        this.yRotO = to.yRotO;
        this.xRotO = to.xRotO;
        this.setPosRaw(to.getX(), to.getY(), to.getZ());
        this.setYRot(to.getYRot());
        this.setXRot(to.getXRot());
        this.xOld = to.xOld;
        this.yOld = to.yOld + (double)yOffset;
        this.zOld = to.zOld;
        this.wrapArmYaw();
        this.updateBoundingBox();
    }

    public float getViewYRot(float tickDelta) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != null && view != this) {
            return this.yRotO + (this.getYRot() - this.yRotO) * tickDelta;
        }
        return super.getViewYRot(tickDelta);
    }

    public float getViewXRot(float tickDelta) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != null && view != this) {
            return this.xRotO + (this.getXRot() - this.xRotO) * tickDelta;
        }
        return super.getViewXRot(tickDelta);
    }

    private void updateBoundingBox() {
        float width = this.getBbWidth();
        float height = this.getBbHeight();
        this.setBoundingBox(new AABB(this.getX() - (double)(width / 2.0f), this.getY(), this.getZ() - (double)(width / 2.0f), this.getX() + (double)(width / 2.0f), this.getY() + (double)height, this.getZ() + (double)(width / 2.0f)));
    }

    public void tick() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != null) {
            UUID spectating = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID();
            if (spectating != null && (view.getUUID() != spectating || view.level() != this.level()) || this.level().getEntity(view.getId()) != view) {
                if (spectating == null) {
                    ReplayModReplay.instance.getReplayHandler().spectateEntity((Entity)this);
                    return;
                }
                view = this.level().getPlayerByUUID(spectating);
                if (view != null) {
                    this.minecraft.setCameraEntity(view);
                } else {
                    this.minecraft.setCameraEntity((Entity)this);
                    return;
                }
            }
            if (view != this) {
                this.setCameraPosRot(view);
            }
        }
    }

    public void resetPos() {
        if (this.minecraft.level != null) {
            this.setLevel((Level)this.minecraft.level);
        }
        super.resetPos();
    }

    public void setRot(float yaw, float pitch) {
        if (this.minecraft.getCameraEntity() == this) {
            super.setRot(yaw, pitch);
        }
    }

    public boolean isInWall() {
        return this.falseUnlessSpectating(Entity::isInWall);
    }

    public boolean isEyeInFluid(TagKey<Fluid> fluid) {
        return this.falseUnlessSpectating(entity -> entity.isEyeInFluid(fluid));
    }

    public float getWaterVision() {
        return this.falseUnlessSpectating(__ -> true) ? super.getWaterVision() : 1.0f;
    }

    public boolean isOnFire() {
        return this.falseUnlessSpectating(Entity::isOnFire);
    }

    private boolean falseUnlessSpectating(Function<Entity, Boolean> property) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != null && view != this) {
            return property.apply(view);
        }
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void spawnSprintParticle() {
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isSpectator() {
        ReplayHandler replayHandler = ReplayModReplay.instance.getReplayHandler();
        return replayHandler == null || replayHandler.isCameraView();
    }

    public boolean shouldRender(double double_1, double double_2, double double_3) {
        return false;
    }

    public float getFieldOfViewModifier() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)view).getFieldOfViewModifier();
        }
        return 1.0f;
    }

    public boolean isInvisible() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this) {
            return view.isInvisible();
        }
        return super.isInvisible();
    }

    public PlayerSkin getSkin() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)view).getSkin();
        }
        return super.getSkin();
    }

    public boolean isModelPartShown(PlayerModelPart modelPart) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).isModelPartShown(modelPart);
        }
        return super.isModelPartShown(modelPart);
    }

    public HumanoidArm getMainArm() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).getMainArm();
        }
        return super.getMainArm();
    }

    public float getAttackAnim(float renderPartialTicks) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).getAttackAnim(renderPartialTicks);
        }
        return 0.0f;
    }

    public float getCurrentItemAttackStrengthDelay() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).getCurrentItemAttackStrengthDelay();
        }
        return 1.0f;
    }

    public float getAttackStrengthScale(float adjustTicks) {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).getAttackStrengthScale(adjustTicks);
        }
        return 1.0f;
    }

    public InteractionHand getUsedItemHand() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).getUsedItemHand();
        }
        return super.getUsedItemHand();
    }

    public boolean isUsingItem() {
        Entity view = this.minecraft.getCameraEntity();
        if (view != this && view instanceof Player) {
            return ((Player)view).isUsingItem();
        }
        return super.isUsingItem();
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack stack, ItemStack itemStack) {
    }

    public HitResult pick(double maxDistance, float tickDelta, boolean fluids) {
        HitResult result = super.pick(maxDistance, tickDelta, fluids);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            result = BlockHitResult.miss((Vec3)result.getLocation(), (Direction)blockResult.getDirection(), (BlockPos)blockResult.getBlockPos());
        }
        return result;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.eventHandler != null) {
            this.eventHandler.unregister();
            this.eventHandler = null;
        }
    }

    private void update() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != this.level()) {
            if (this.eventHandler != null) {
                this.eventHandler.unregister();
                this.eventHandler = null;
            }
            return;
        }
        long now = System.currentTimeMillis();
        long timePassed = now - this.lastControllerUpdate;
        this.cameraController.update((float)timePassed / 50.0f);
        this.lastControllerUpdate = now;
        this.handleInputEvents();
        Map<String, KeyBindingRegistry.Binding> keyBindings = ReplayMod.instance.getKeyBindingRegistry().getBindings();
        if (keyBindings.get((Object)"replaymod.input.rollclockwise").keyBinding.isDown()) {
            this.roll = (float)((double)this.roll + (Utils.isCtrlDown() ? 0.2 : 1.0));
        }
        if (keyBindings.get((Object)"replaymod.input.rollcounterclockwise").keyBinding.isDown()) {
            this.roll = (float)((double)this.roll - (Utils.isCtrlDown() ? 0.2 : 1.0));
        }
        this.noPhysics = this.isSpectator();
        this.syncInventory();
    }

    private void syncInventory() {
        Entity view = this.minecraft.getCameraEntity();
        Player viewPlayer = view != this && view instanceof Player ? (Player)view : null;
        EntityPlayerAccessor cameraA = (EntityPlayerAccessor)((Object)this);
        EntityPlayerAccessor viewPlayerA = (EntityPlayerAccessor)viewPlayer;
        ItemStack empty = ItemStack.EMPTY;
        this.setItemSlot(EquipmentSlot.HEAD, viewPlayer != null ? viewPlayer.getItemBySlot(EquipmentSlot.HEAD) : empty);
        this.setItemSlot(EquipmentSlot.MAINHAND, viewPlayer != null ? viewPlayer.getItemBySlot(EquipmentSlot.MAINHAND) : empty);
        this.setItemSlot(EquipmentSlot.OFFHAND, viewPlayer != null ? viewPlayer.getItemBySlot(EquipmentSlot.OFFHAND) : empty);
        cameraA.setItemStackMainHand(viewPlayerA != null ? viewPlayerA.getItemStackMainHand() : empty);
        this.swingingArm = viewPlayer != null ? viewPlayer.swingingArm : InteractionHand.MAIN_HAND;
        this.useItem = viewPlayer != null ? viewPlayer.getUseItem() : empty;
        cameraA.setActiveItemStackUseCount(viewPlayerA != null ? viewPlayerA.getActiveItemStackUseCount() : 0);
    }

    private void handleInputEvents() {
        if ((this.minecraft.options.keyAttack.consumeClick() || this.minecraft.options.keyUse.consumeClick()) && this.minecraft.screen == null && this.canSpectate(this.minecraft.crosshairPickEntity)) {
            ReplayModReplay.instance.getReplayHandler().spectateEntity(this.minecraft.crosshairPickEntity);
            while (this.minecraft.options.keyShift.consumeClick()) {
            }
        }
    }

    private void updateArmYawAndPitch() {
        this.yBobO = this.yBob;
        this.xBobO = this.xBob;
        this.xBob += (this.getXRot() - this.xBob) * 0.5f;
        this.yBob += CameraEntity.wrapDegrees(this.getYRot() - this.yBob) * 0.5f;
        this.wrapArmYaw();
    }

    private void wrapArmYaw() {
        this.yBob = CameraEntity.wrapDegreesTo(this.yBob, this.getYRot());
        this.yBobO = CameraEntity.wrapDegreesTo(this.yBobO, this.yBob);
    }

    private static float wrapDegreesTo(float value, float towardsValue) {
        while (towardsValue - value < -180.0f) {
            value -= 360.0f;
        }
        while (towardsValue - value >= 180.0f) {
            value += 360.0f;
        }
        return value;
    }

    private static float wrapDegrees(float value) {
        return CameraEntity.wrapDegreesTo(value %= 360.0f, 0.0f);
    }

    public boolean canSpectate(Entity e) {
        return e != null && !e.isInvisible();
    }

    private class EventHandler
    extends EventRegistrations {
        private final Minecraft mc = MCVer.getMinecraft();
        private boolean heldItemTooltipsWasTrue;

        private EventHandler() {
            this.on(PreTickCallback.EVENT, this::onPreClientTick);
            this.on(PreRenderCallback.EVENT, this::onRenderUpdate);
            this.on(KeyBindingEventCallback.EVENT, CameraEntity.this::handleInputEvents);
            this.on(RenderSpectatorCrosshairCallback.EVENT, this::shouldRenderSpectatorCrosshair);
            this.on(RenderHotbarCallback.EVENT, this::shouldRenderHotbar);
            this.on(SettingsChangedCallback.EVENT, this::onSettingsChanged);
            this.on(PreRenderHandCallback.EVENT, this::onRenderHand);
        }

        private void onPreClientTick() {
            CameraEntity.this.updateArmYawAndPitch();
        }

        private void onRenderUpdate() {
            CameraEntity.this.update();
        }

        private Boolean shouldRenderSpectatorCrosshair() {
            return CameraEntity.this.canSpectate(this.mc.crosshairPickEntity);
        }

        private Boolean shouldRenderHotbar() {
            return false;
        }

        private void onSettingsChanged(SettingsRegistry registry, SettingsRegistry.SettingKey<?> key) {
            if (key == Setting.CAMERA) {
                CameraEntity.this.cameraController = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID() == null ? ReplayModReplay.instance.createCameraController(CameraEntity.this) : new SpectatorCameraController(CameraEntity.this);
            }
        }

        private boolean onRenderHand() {
            Entity view = this.mc.getCameraEntity();
            if (view == CameraEntity.this || !(view instanceof Player)) {
                return true;
            }
            Player player = (Player)view;
            if (CameraEntity.this.lastHandRendered != player) {
                CameraEntity.this.lastHandRendered = player;
                FirstPersonRendererAccessor acc = (FirstPersonRendererAccessor)this.mc.gameRenderer.itemInHandRenderer;
                acc.setPrevEquippedProgressMainHand(1.0f);
                acc.setPrevEquippedProgressOffHand(1.0f);
                acc.setEquippedProgressMainHand(1.0f);
                acc.setEquippedProgressOffHand(1.0f);
                acc.setItemStackMainHand(player.getItemBySlot(EquipmentSlot.MAINHAND));
                acc.setItemStackOffHand(player.getItemBySlot(EquipmentSlot.OFFHAND));
                this.mc.player.yBob = this.mc.player.yBobO = player.getYRot();
                this.mc.player.xBob = this.mc.player.xBobO = player.getXRot();
            }
            return false;
        }
    }
}

