/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.handler;

import com.replaymod.core.gui.GuiReplayButton;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.ScreenButtonExtension;
import com.replaymod.replay.Setting;
import com.replaymod.replay.gui.screen.GuiReplayViewer;
import de.johni0702.minecraft.gui.MinecraftGuiRenderer;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.versions.callbacks.InitScreenCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class GuiHandler
extends EventRegistrations {
    private static final int BUTTON_REPLAY_VIEWER = 17890234;
    private static final int BUTTON_EXIT_REPLAY = 17890235;
    private final ReplayModReplay mod;

    public GuiHandler(ReplayModReplay mod) {
        this.on(InitScreenCallback.EVENT, this::injectIntoIngameMenu);
        this.on(InitScreenCallback.EVENT, (screen, buttons) -> this.ensureReplayStopped(screen));
        this.on(InitScreenCallback.EVENT, this::injectIntoMainMenu);
        this.mod = mod;
    }

    private void injectIntoIngameMenu(Screen guiScreen, Collection<AbstractWidget> buttonList) {
        if (!(guiScreen instanceof PauseScreen)) {
            return;
        }
        if (this.mod.getReplayHandler() != null) {
            this.mod.getReplayHandler().getReplaySender().setReplaySpeed(0.0);
            MutableComponent BUTTON_OPTIONS = Component.translatable((String)"menu.options");
            MutableComponent BUTTON_EXIT_SERVER = Component.translatable((String)"menu.disconnect");
            MutableComponent BUTTON_ADVANCEMENTS = Component.translatable((String)"gui.advancements");
            MutableComponent BUTTON_STATS = Component.translatable((String)"gui.stats");
            MutableComponent BUTTON_OPEN_TO_LAN = Component.translatable((String)"menu.shareToLan");
            AbstractWidget achievements = null;
            AbstractWidget stats = null;
            for (AbstractWidget b : new ArrayList<AbstractWidget>(buttonList)) {
                boolean remove = false;
                Component id = b.getMessage();
                if (id == null) continue;
                if (id.equals((Object)BUTTON_EXIT_SERVER)) {
                    remove = true;
                    MCVer.addButton(guiScreen, new InjectedButton(guiScreen, 17890235, b.getX(), b.getY(), b.getWidth(), b.getHeight(), "replaymod.gui.exit", null, this::onButton));
                } else if (id.equals((Object)BUTTON_ADVANCEMENTS)) {
                    remove = true;
                    achievements = b;
                } else if (id.equals((Object)BUTTON_STATS)) {
                    remove = true;
                    stats = b;
                } else if (id.equals((Object)BUTTON_OPEN_TO_LAN)) {
                    remove = true;
                }
                if (!remove) continue;
                b.setX(-1000);
                b.setY(-1000);
            }
            if (achievements != null && stats != null) {
                this.moveAllButtonsInRect(buttonList, achievements.getX(), stats.getX() + stats.getWidth(), achievements.getY(), Integer.MAX_VALUE, -24);
            }
        }
    }

    private void moveAllButtonsInRect(Collection<AbstractWidget> buttons, int xStart, int xEnd, int yStart, int yEnd, int moveBy) {
        buttons.stream().filter(button -> button.getX() <= xEnd && button.getX() + button.getWidth() >= xStart).filter(button -> button.getY() <= yEnd && button.getY() + button.getHeight() >= yStart).forEach(button -> button.setY(button.getY() + moveBy));
    }

    private void ensureReplayStopped(Screen guiScreen) {
        if (!(guiScreen instanceof TitleScreen) && !(guiScreen instanceof JoinMultiplayerScreen)) {
            return;
        }
        if (this.mod.getReplayHandler() != null) {
            try {
                this.mod.getReplayHandler().endReplay();
            }
            catch (IOException e) {
                ReplayModReplay.LOGGER.error("Trying to stop broken replay: ", (Throwable)e);
            }
            finally {
                if (this.mod.getReplayHandler() != null) {
                    this.mod.forcefullyStopReplay();
                }
            }
        }
    }

    private void injectIntoMainMenu(Screen guiScreen, Collection<AbstractWidget> buttonList) {
        if (!(guiScreen instanceof TitleScreen)) {
            return;
        }
        if (this.mod.getCore().getSettingsRegistry().get(Setting.LEGACY_MAIN_MENU_BUTTON).booleanValue()) {
            this.legacyInjectIntoMainMenu(guiScreen, buttonList);
        } else {
            this.properInjectIntoMainMenu(guiScreen);
        }
    }

    private void properInjectIntoMainMenu(Screen screen) {
        Point pos;
        List<AbstractWidget> buttonList = ((ScreenButtonExtension)screen).replay_getButtons();
        MainMenuButtonPosition buttonPosition = MainMenuButtonPosition.valueOf(this.mod.getCore().getSettingsRegistry().get(Setting.MAIN_MENU_BUTTON));
        if (this.isFancyMenu2Installed()) {
            for (AbstractWidget button : buttonList) {
                if (!(button instanceof InjectedButton)) continue;
                return;
            }
        }
        if (buttonPosition == MainMenuButtonPosition.BIG) {
            int x = screen.width / 2 - 100;
            Optional targetButton = MCVer.findButton(buttonList, "menu.online", 14).map(Optional::of).orElseGet(() -> MCVer.findButton(buttonList, "menu.multiplayer", 2));
            int y = targetButton.map(it -> it.getY()).orElse(screen.height / 4 + 10 + 96);
            this.moveAllButtonsInRect(buttonList, x, x + 200, Integer.MIN_VALUE, y, -24);
            pos = new Point(x, y);
        } else {
            pos = this.determineButtonPos(buttonPosition, screen, buttonList);
        }
        InjectedButton replayViewerButton = buttonPosition == MainMenuButtonPosition.BIG ? new InjectedButton(screen, 17890234, pos.getX(), pos.getY(), 200, 20, "replaymod.gui.replayviewer", null, this::onButton) : new InjectedButton(this, screen, 17890234, pos.getX(), pos.getY(), 20, 20, "", "replaymod.gui.replayviewer", this::onButton){

            public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
                super.renderWidget(context, mouseX, mouseY, delta);
                MinecraftGuiRenderer renderer = new MinecraftGuiRenderer(context);
                renderer.bindTexture(GuiReplayButton.ICON);
                renderer.drawTexturedRect(this.getX() + 3, this.getY() + 3, 0, 0, this.width - 6, this.height - 6, 1, 1, 1, 1);
            }
        };
        int index = this.determineButtonIndex(buttonList, (AbstractWidget)replayViewerButton);
        if (index != -1) {
            buttonList.add(index, (AbstractWidget)replayViewerButton);
        } else {
            buttonList.add((AbstractWidget)replayViewerButton);
        }
    }

    private boolean isFancyMenu2Installed() {
        ModFileInfo mod = FMLLoader.getLoadingModList().getModFileById("fancymenu");
        if (mod == null) {
            return false;
        }
        return ((IModInfo)mod.getMods().get(0)).getVersion().toString().startsWith("2.");
    }

    private void legacyInjectIntoMainMenu(final Screen guiScreen, final Collection<AbstractWidget> buttonList) {
        boolean isCustomMainMenuMod = guiScreen.getClass().getName().endsWith("custommainmenu.gui.GuiFakeMain");
        final MainMenuButtonPosition buttonPosition = MainMenuButtonPosition.valueOf(this.mod.getCore().getSettingsRegistry().get(Setting.MAIN_MENU_BUTTON));
        if (buttonPosition != MainMenuButtonPosition.BIG && !isCustomMainMenuMod) {
            VanillaGuiScreen vanillaGui = VanillaGuiScreen.wrap(guiScreen);
            final GuiReplayButton replayButton = new GuiReplayButton();
            ((GuiButton)replayButton.onClick(() -> new GuiReplayViewer(this.mod).display())).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.replayviewer", new Object[0]));
            ((GuiScreen)vanillaGui.setLayout(new CustomLayout<GuiScreen>(vanillaGui.getLayout()){
                private Point pos;

                @Override
                protected void layout(GuiScreen container, int width, int height) {
                    if (this.pos == null) {
                        this.pos = GuiHandler.this.determineButtonPos(buttonPosition, guiScreen, buttonList);
                    }
                    this.size(replayButton, 20, 20);
                    this.pos(replayButton, this.pos.getX(), this.pos.getY());
                }
            })).addElements(null, new GuiElement[]{replayButton});
            return;
        }
        int x = guiScreen.width / 2 - 100;
        int y = MCVer.findButton(buttonList, "menu.online", 14).map(Optional::of).orElse(MCVer.findButton(buttonList, "menu.multiplayer", 2)).map(it -> it.getY()).orElse(guiScreen.height / 4 + 10 + 96);
        this.moveAllButtonsInRect(buttonList, x, x + 200, Integer.MIN_VALUE, y, -24);
        InjectedButton button = new InjectedButton(guiScreen, 17890234, x, y, 200, 20, "replaymod.gui.replayviewer", null, this::onButton);
        MCVer.addButton(guiScreen, button);
    }

    private Point determineButtonPos(MainMenuButtonPosition buttonPosition, Screen guiScreen, Collection<AbstractWidget> buttonList) {
        Point topRight = new Point(guiScreen.width - 20 - 5, 5);
        if (buttonPosition == MainMenuButtonPosition.TOP_LEFT) {
            return new Point(5, 5);
        }
        if (buttonPosition == MainMenuButtonPosition.TOP_RIGHT) {
            return topRight;
        }
        if (buttonPosition == MainMenuButtonPosition.DEFAULT) {
            return Stream.of(MCVer.findButton(buttonList, "menu.singleplayer", 1), MCVer.findButton(buttonList, "menu.multiplayer", 2), MCVer.findButton(buttonList, "menu.online", 14), MCVer.findButton(buttonList, "modmenu.title", 6)).flatMap(it -> it.map(Stream::of).orElseGet(Stream::empty)).filter(it -> buttonList.stream().noneMatch(button -> button.getX() <= it.getX() + it.getWidth() + 4 + 20 && button.getY() <= it.getY() + it.getHeight() && button.getX() + button.getWidth() >= it.getX() + it.getWidth() + 4 && button.getY() + button.getHeight() >= it.getY())).max(Comparator.comparingInt(it -> it.getY()).thenComparingInt(it -> it.getX())).map(it -> new Point(it.getX() + it.getWidth() + 4, it.getY())).orElse(topRight);
        }
        return Optional.of(buttonList).flatMap(buttons -> {
            switch (buttonPosition.ordinal()) {
                case 4: 
                case 5: {
                    return MCVer.findButton(buttons, "menu.singleplayer", 1);
                }
                case 6: 
                case 7: {
                    return MCVer.findButton(buttons, "menu.multiplayer", 2);
                }
                case 8: 
                case 9: {
                    return MCVer.findButton(buttons, "menu.online", 14);
                }
                case 10: 
                case 11: {
                    return MCVer.findButton(buttons, "modmenu.title", 6);
                }
            }
            throw new RuntimeException();
        }).map(button -> {
            switch (buttonPosition.ordinal()) {
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    return new Point(button.getX() - 4 - 20, button.getY());
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    return new Point(button.getX() + button.getWidth() + 4, button.getY());
                }
            }
            throw new RuntimeException();
        }).orElse(topRight);
    }

    private int determineButtonIndex(Collection<AbstractWidget> buttons, AbstractWidget button) {
        AbstractWidget best = null;
        int bestIndex = -1;
        int index = 0;
        for (AbstractWidget other : buttons) {
            if (other.getY() > button.getY() || other.getY() == button.getY() && other.getX() > button.getX()) {
                ++index;
                continue;
            }
            if (best == null || other.getY() > best.getY() || other.getY() == best.getY() && other.getX() > best.getX()) {
                best = other;
                bestIndex = index + 1;
            }
            ++index;
        }
        return bestIndex;
    }

    private void onButton(InjectedButton button) {
        Screen guiScreen = button.guiScreen;
        if (!button.active) {
            return;
        }
        if (guiScreen instanceof TitleScreen && button.id == 17890234) {
            new GuiReplayViewer(this.mod).display();
        }
        if (guiScreen instanceof PauseScreen && this.mod.getReplayHandler() != null && button.id == 17890235) {
            button.active = false;
            try {
                this.mod.getReplayHandler().endReplay();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class InjectedButton
    extends Button {
        public final Screen guiScreen;
        public final int id;
        private Consumer<InjectedButton> onClick;

        public InjectedButton(Screen guiScreen, int buttonId, int x, int y, int width, int height, String buttonText, String tooltip, Consumer<InjectedButton> onClick) {
            super(x, y, width, height, (Component)Component.translatable((String)buttonText), self -> onClick.accept((InjectedButton)self), DEFAULT_NARRATION);
            this.guiScreen = guiScreen;
            this.id = buttonId;
            this.onClick = onClick;
            if (tooltip != null) {
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)tooltip)));
            }
        }
    }

    public static enum MainMenuButtonPosition {
        BIG,
        DEFAULT,
        TOP_LEFT,
        TOP_RIGHT,
        LEFT_OF_SINGLEPLAYER,
        RIGHT_OF_SINGLEPLAYER,
        LEFT_OF_MULTIPLAYER,
        RIGHT_OF_MULTIPLAYER,
        LEFT_OF_REALMS,
        RIGHT_OF_REALMS,
        LEFT_OF_MODS,
        RIGHT_OF_MODS;

    }
}

