/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.mixin;

import com.replaymod.replay.mixin.ClientWorldAccessor;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ClientPacketListener.class})
public class Mixin_FixEntityNotTracking {
    @ModifyVariable(method={"handleTeleportEntity(Lnet/minecraft/network/protocol/game/ClientboundTeleportEntityPacket;)V", "handleMoveEntity(Lnet/minecraft/network/protocol/game/ClientboundMoveEntityPacket;)V", "handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at=@At(value="RETURN"), ordinal=0)
    private Entity updatePositionIfNotTracked$0(Entity entity) {
        if (entity != null) {
            entity.getSelfAndPassengers().forEach(this::updatePositionIfNotTracked);
        }
        return entity;
    }

    private void updatePositionIfNotTracked(Entity entity) {
        ClientWorldAccessor world;
        Level level;
        if (entity != null && (level = entity.level()) instanceof ClientWorldAccessor && !(world = (ClientWorldAccessor)level).getTickingEntities().contains(entity)) {
            Vec3 prevPos;
            if (entity.isControlledByLocalInstance()) {
                return;
            }
            int ticks = 0;
            do {
                prevPos = entity.position();
                if (entity.isPassenger()) {
                    entity.rideTick();
                    continue;
                }
                entity.tick();
            } while (prevPos.distanceToSqr(entity.position()) > 1.0E-4 && ticks++ < 100);
        }
    }
}

