/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.filter;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.google.gson.JsonObject;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.filter.DimensionTracker;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketBlockChange;
import com.replaymod.replaystudio.protocol.packets.PacketChunkData;
import com.replaymod.replaystudio.protocol.packets.PacketCustomPayload;
import com.replaymod.replaystudio.protocol.packets.PacketDestroyEntities;
import com.replaymod.replaystudio.protocol.packets.PacketEntityMovement;
import com.replaymod.replaystudio.protocol.packets.PacketEntityTeleport;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketPlayerPositionRotation;
import com.replaymod.replaystudio.protocol.packets.PacketRespawn;
import com.replaymod.replaystudio.protocol.packets.PacketSetSlot;
import com.replaymod.replaystudio.protocol.packets.PacketTeam;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateLight;
import com.replaymod.replaystudio.protocol.packets.PacketWindowItems;
import com.replaymod.replaystudio.protocol.registry.DimensionType;
import com.replaymod.replaystudio.protocol.registry.Registries;
import com.replaymod.replaystudio.protocol.registry.RegistriesBuilder;
import com.replaymod.replaystudio.stream.IteratorStream;
import com.replaymod.replaystudio.stream.PacketStream;
import com.replaymod.replaystudio.util.DPosition;
import com.replaymod.replaystudio.util.IPosition;
import com.replaymod.replaystudio.util.Location;
import com.replaymod.replaystudio.util.PacketUtils;
import com.replaymod.replaystudio.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SquashFilter
implements StreamFilter {
    private static final long POS_MIN = -128L;
    private static final long POS_MAX = 127L;
    private PacketTypeRegistry registry;
    private boolean forgeHandshake;
    private final List<PacketData> emitFirst = new ArrayList<PacketData>();
    private final List<PacketData> loginPhase = new ArrayList<PacketData>();
    private final List<PacketData> configurationPhase = new ArrayList<PacketData>();
    private final List<PacketData> preJoinGame = new ArrayList<PacketData>();
    private final List<PacketData> unhandled = new ArrayList<PacketData>();
    private final Map<Integer, Entity> entities = new HashMap<Integer, Entity>();
    private final Map<String, Team> teams = new HashMap<String, Team>();
    private final Map<Integer, PacketData> mainInventoryChanges = new HashMap<Integer, PacketData>();
    private final Map<Integer, Packet> maps = new HashMap<Integer, Packet>();
    private final List<PacketData> currentWorld = new ArrayList<PacketData>();
    private final List<PacketData> currentWindow = new ArrayList<PacketData>();
    private final List<PacketData> closeWindows = new ArrayList<PacketData>();
    private final Map<PacketType, PacketData> latestOnly = new HashMap<PacketType, PacketData>();
    private final Map<Long, ChunkData> chunks = new HashMap<Long, ChunkData>();
    private final Map<Long, Long> unloadedChunks = new HashMap<Long, Long>();
    private Registries registries;
    private final RegistriesBuilder registriesBuilder = new RegistriesBuilder();
    private String dimension;
    private DimensionType dimensionType;
    private PacketPlayerPositionRotation cameraPositionRotation;
    private Integer recordingPlayerEntityId;
    private long prevTimestamp;

    public SquashFilter(Registries registries, String dimension, DimensionType dimensionType) {
        this.registries = registries != null ? registries : new Registries();
        this.dimension = dimension;
        this.dimensionType = dimensionType;
    }

    public SquashFilter(DimensionTracker dimensionTracker) {
        this(dimensionTracker.registries.copy(), dimensionTracker.dimension, dimensionTracker.dimensionType);
    }

    public SquashFilter copy() {
        SquashFilter copy = new SquashFilter(this.registries.copy(), this.dimension, this.dimensionType);
        copy.registry = this.registry;
        copy.forgeHandshake = this.forgeHandshake;
        this.teams.forEach((key, value) -> copy.teams.put((String)key, value.copy()));
        this.entities.forEach((key, value) -> copy.entities.put((Integer)key, value.copy()));
        this.emitFirst.forEach(it -> copy.emitFirst.add(it.copy()));
        this.loginPhase.forEach(it -> copy.loginPhase.add(it.copy()));
        this.configurationPhase.forEach(it -> copy.configurationPhase.add(it.copy()));
        this.preJoinGame.forEach(it -> copy.preJoinGame.add(it.copy()));
        this.unhandled.forEach(it -> copy.unhandled.add(it.copy()));
        this.mainInventoryChanges.forEach((key, value) -> copy.mainInventoryChanges.put((Integer)key, value.copy()));
        this.maps.forEach((key, value) -> copy.maps.put((Integer)key, value.copy()));
        this.currentWorld.forEach(it -> copy.currentWorld.add(it.copy()));
        this.currentWindow.forEach(it -> copy.currentWindow.add(it.copy()));
        this.closeWindows.forEach(it -> copy.closeWindows.add(it.copy()));
        this.latestOnly.forEach((key, value) -> copy.latestOnly.put((PacketType)((Object)key), value.copy()));
        this.chunks.forEach((key, value) -> copy.chunks.put((Long)key, value.copy()));
        copy.unloadedChunks.putAll(this.unloadedChunks);
        copy.registriesBuilder.copyFrom(this.registriesBuilder);
        copy.cameraPositionRotation = this.cameraPositionRotation;
        copy.recordingPlayerEntityId = this.recordingPlayerEntityId;
        copy.prevTimestamp = this.prevTimestamp;
        return copy;
    }

    private void flush() throws IOException {
        ArrayList flushedPackets = new ArrayList();
        this.onEnd(new IteratorStream(flushedPackets.listIterator(), (PacketStream.FilterInfo)null), 0L);
        this.emitFirst.addAll(flushedPackets);
    }

    public void release() {
        this.teams.values().forEach(Team::release);
        this.entities.values().forEach(Entity::release);
        this.emitFirst.forEach(PacketData::release);
        this.loginPhase.forEach(PacketData::release);
        this.configurationPhase.forEach(PacketData::release);
        this.preJoinGame.forEach(PacketData::release);
        this.unhandled.forEach(PacketData::release);
        this.mainInventoryChanges.values().forEach(PacketData::release);
        this.maps.values().forEach(Packet::release);
        this.currentWorld.forEach(PacketData::release);
        this.currentWindow.forEach(PacketData::release);
        this.closeWindows.forEach(PacketData::release);
        this.latestOnly.values().forEach(PacketData::release);
    }

    @Override
    public void onStart(PacketStream stream) {
    }

    @Override
    public boolean onPacket(PacketStream stream, PacketData originalData) throws IOException {
        block74: {
            PacketData data = new PacketData(Math.max(originalData.getTime(), this.prevTimestamp + 1L), originalData.getPacket());
            this.prevTimestamp = data.getTime();
            Packet packet = data.getPacket();
            PacketType type = packet.getType();
            this.registry = packet.getRegistry();
            long lastTimestamp = data.getTime();
            Integer entityId = PacketUtils.getEntityId(packet);
            if (entityId != null) {
                if (entityId == -1) {
                    for (int id : PacketUtils.getEntityIds(packet)) {
                        Entity entity;
                        if (type == PacketType.DestroyEntity || type == PacketType.DestroyEntities) {
                            entity = this.entities.computeIfAbsent(id, i -> new Entity());
                            entity.release();
                            entity.despawned = true;
                            if (entity.complete) {
                                this.entities.remove(id);
                            }
                        } else {
                            entity = this.entities.compute(id, (i, e) -> e == null || ((Entity)e).despawned ? new Entity() : e);
                            entity.packets.add(data.retain());
                        }
                        entity.lastTimestamp = lastTimestamp;
                    }
                } else {
                    Entity entity = this.entities.compute(entityId, (i, e) -> e == null || ((Entity)e).despawned ? new Entity() : e);
                    if (type == PacketType.EntityMovement || type == PacketType.EntityPosition || type == PacketType.EntityRotation || type == PacketType.EntityPositionRotation) {
                        Triple<DPosition, Pair<Float, Float>, Boolean> movement = PacketEntityMovement.getMovement(packet);
                        DPosition deltaPos = (DPosition)movement.getLeft();
                        Pair yawPitch = (Pair)movement.getMiddle();
                        if (deltaPos != null) {
                            Entity entity2 = entity;
                            entity2.dx = (long)((double)entity2.dx + deltaPos.getX() * 32.0);
                            entity2 = entity;
                            entity2.dy = (long)((double)entity2.dy + deltaPos.getY() * 32.0);
                            entity2 = entity;
                            entity2.dz = (long)((double)entity2.dz + deltaPos.getZ() * 32.0);
                        }
                        if (yawPitch != null) {
                            entity.yaw = (Float)yawPitch.getKey();
                            entity.pitch = (Float)yawPitch.getValue();
                        }
                        entity.onGround = (Boolean)movement.getRight();
                    } else if (type == PacketType.EntityTeleport) {
                        if (entity.teleport != null) {
                            entity.teleport.release();
                        }
                        entity.dx = (entity.dy = (entity.dz = 0L));
                        entity.yaw = (entity.pitch = null);
                        entity.teleport = packet.retain();
                    } else {
                        if (PacketUtils.isSpawnEntityPacket(packet)) {
                            entity.complete = true;
                        }
                        entity.packets.add(data.retain());
                    }
                    entity.lastTimestamp = lastTimestamp;
                }
                return false;
            }
            block0 : switch (type) {
                case PlayerActionAck: 
                case SpawnParticle: {
                    break;
                }
                case Respawn: {
                    PacketRespawn packetRespawn = PacketRespawn.read(packet, this.registries);
                    String newDimension = packetRespawn.dimension;
                    if (this.dimension == null) {
                        this.flush();
                    } else if (!this.dimension.equals(newDimension)) {
                        this.currentWorld.forEach(PacketData::release);
                        this.currentWorld.clear();
                        this.chunks.clear();
                        this.unloadedChunks.clear();
                        this.currentWindow.forEach(PacketData::release);
                        this.currentWindow.clear();
                        this.entities.values().forEach(Entity::release);
                        this.entities.clear();
                    }
                    this.dimension = newDimension;
                    this.dimensionType = packetRespawn.dimensionType;
                    PacketData prev = this.latestOnly.put(type, data.retain());
                    if (prev == null) break;
                    prev.release();
                    break;
                }
                case JoinGame: {
                    this.currentWorld.forEach(PacketData::release);
                    this.currentWorld.clear();
                    this.chunks.clear();
                    this.unloadedChunks.clear();
                    this.currentWindow.forEach(PacketData::release);
                    this.currentWindow.clear();
                    this.entities.values().forEach(Entity::release);
                    this.entities.clear();
                    PacketJoinGame packetJoinGame = PacketJoinGame.read(packet, this.registries);
                    this.recordingPlayerEntityId = ~packetJoinGame.entityId;
                    this.registries = packetJoinGame.registries;
                    this.dimension = packetJoinGame.dimension;
                    this.dimensionType = packetJoinGame.dimensionType;
                    this.forgeHandshake = false;
                }
                case SetExperience: 
                case PlayerAbilities: 
                case Difficulty: 
                case UpdateViewPosition: 
                case UpdateViewDistance: {
                    PacketData prev = this.latestOnly.put(type, data.retain());
                    if (prev == null) break;
                    prev.release();
                    break;
                }
                case UpdateLight: {
                    PacketUpdateLight updateLight = PacketUpdateLight.read(packet);
                    this.chunks.computeIfAbsent(ColumnPos.coordToLong(updateLight.getX(), updateLight.getZ()), idx -> new ChunkData(data.getTime(), updateLight.getX(), updateLight.getZ())).updateLight(updateLight.getData());
                    break;
                }
                case ChunkData: 
                case UnloadChunk: {
                    PacketChunkData chunkData = PacketChunkData.read(packet, this.dimensionType.getSections());
                    if (chunkData.isUnload()) {
                        this.unloadChunk(data.getTime(), chunkData.getUnloadX(), chunkData.getUnloadZ());
                        break;
                    }
                    this.updateChunk(data.getTime(), chunkData.getColumn());
                    break;
                }
                case BulkChunkData: {
                    for (PacketChunkData.Column column : PacketChunkData.readBulk(packet)) {
                        this.updateChunk(data.getTime(), column);
                    }
                    break;
                }
                case BlockChange: {
                    this.updateBlock(data.getTime(), PacketBlockChange.read(packet));
                    break;
                }
                case MultiBlockChange: {
                    for (PacketBlockChange change : PacketBlockChange.readBulk(packet)) {
                        this.updateBlock(data.getTime(), change);
                    }
                    break;
                }
                case PlayerPositionRotation: {
                    this.cameraPositionRotation = PacketPlayerPositionRotation.read(packet);
                    break;
                }
                case BlockBreakAnim: 
                case BlockValue: 
                case Explosion: 
                case OpenTileEntityEditor: 
                case PlayEffect: 
                case PlaySound: 
                case SpawnPosition: 
                case UpdateSign: 
                case UpdateTileEntity: 
                case UpdateTime: 
                case WorldBorder: 
                case NotifyClient: 
                case MapData: {
                    this.currentWorld.add(data.retain());
                    break;
                }
                case CloseWindow: {
                    this.currentWindow.forEach(PacketData::release);
                    this.currentWindow.clear();
                    this.closeWindows.add(data.retain());
                    break;
                }
                case ConfirmTransaction: {
                    break;
                }
                case OpenWindow: 
                case TradeList: 
                case WindowProperty: {
                    this.currentWindow.add(data.retain());
                    break;
                }
                case WindowItems: {
                    if (PacketWindowItems.getWindowId(packet) == 0) {
                        PacketData prev = this.latestOnly.put(type, data.retain());
                        if (prev == null) break;
                        prev.release();
                        break;
                    }
                    this.currentWindow.add(data.retain());
                    break;
                }
                case SetSlot: {
                    if (PacketSetSlot.getWindowId(packet) == 0) {
                        PacketData prev = this.mainInventoryChanges.put(PacketSetSlot.getSlot(packet), data.retain());
                        if (prev == null) break;
                        prev.release();
                        break;
                    }
                    this.currentWindow.add(data.retain());
                    break;
                }
                case Team: {
                    Team team = this.teams.computeIfAbsent(PacketTeam.getName(packet), x$0 -> new Team((String)x$0));
                    switch (PacketTeam.getAction(packet)) {
                        case CREATE: {
                            if (team.create != null) {
                                team.create.release();
                            }
                            team.create = packet.retain();
                            break;
                        }
                        case UPDATE: {
                            if (team.update != null) {
                                team.update.release();
                            }
                            team.update = packet.retain();
                            break;
                        }
                        case REMOVE: {
                            if (team.remove != null) {
                                team.remove.release();
                            }
                            team.remove = packet.retain();
                            if (team.create != null) {
                                team.release();
                                this.teams.remove(team.name);
                                break;
                            }
                            break block74;
                        }
                        case ADD_PLAYER: {
                            for (String player : PacketTeam.getPlayers(packet)) {
                                if (team.removed.remove(player)) continue;
                                team.added.add(player);
                            }
                            break block0;
                        }
                        case REMOVE_PLAYER: {
                            for (String player : PacketTeam.getPlayers(packet)) {
                                if (team.added.remove(player)) continue;
                                team.removed.add(player);
                            }
                        }
                    }
                    break;
                }
                case ConfigCustomPayload: {
                    switch (PacketCustomPayload.getId(packet)) {
                        case "replaymod:enabled_packs_data": {
                            this.registriesBuilder.readEnabledPacksDataPacket(packet);
                        }
                    }
                    this.configurationPhase.add(data.retain());
                    break;
                }
                case ConfigRegistries: {
                    this.registriesBuilder.readRegistriesPacket(packet);
                    if (this.registry.atLeast(ProtocolVersion.v1_20_5)) {
                        boolean previousPhase = false;
                        for (int i2 = this.configurationPhase.size() - 1; i2 >= 0; --i2) {
                            PacketType oldType = this.configurationPhase.get(i2).getPacket().getType();
                            if (oldType == PacketType.ConfigFinish) {
                                previousPhase = true;
                                continue;
                            }
                            if (oldType != PacketType.ConfigRegistries || !previousPhase) continue;
                            this.configurationPhase.remove(i2).release();
                        }
                    } else {
                        this.dropConfigPhasePacketsOfType(type);
                    }
                    this.configurationPhase.add(data.retain());
                    break;
                }
                case ConfigSelectKnownPacks: {
                    this.registriesBuilder.readKnownPacksPacket(packet);
                    this.dropConfigPhasePacketsOfType(type);
                    this.configurationPhase.add(data.retain());
                    break;
                }
                case ConfigFinish: {
                    this.registries = this.registriesBuilder.finish(this.registries);
                    this.dropConfigPhasePacketsOfType(type);
                    this.configurationPhase.add(data.retain());
                    break;
                }
                case ConfigTags: 
                case ConfigFeatures: {
                    this.dropConfigPhasePacketsOfType(type);
                    this.configurationPhase.add(data.retain());
                    break;
                }
                case Reconfigure: {
                    break;
                }
                default: {
                    if (type.getState() == State.CONFIGURATION) {
                        this.configurationPhase.add(data.retain());
                        break;
                    }
                    if (type.getState() == State.LOGIN) {
                        this.loginPhase.add(data.retain());
                        this.forgeHandshake = true;
                        break;
                    }
                    if (this.forgeHandshake) {
                        this.preJoinGame.add(data.retain());
                        break;
                    }
                    this.unhandled.add(data.retain());
                }
            }
        }
        return false;
    }

    private void dropConfigPhasePacketsOfType(PacketType type) {
        this.configurationPhase.removeIf(old -> {
            if (old.getPacket().getType() == type) {
                old.release();
                return true;
            }
            return false;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onEnd(PacketStream stream, long timestamp) throws IOException {
        Iterator iterator;
        PacketData pendingBundle;
        Iterator<Object> entity;
        boolean inBundle = false;
        for (PacketData packetData : this.emitFirst) {
            if (packetData.getPacket().getType() == PacketType.Bundle) {
                inBundle = !inBundle;
            }
            stream.insert(timestamp, packetData.getPacket());
        }
        this.emitFirst.clear();
        boolean hadLoginPhase = !this.loginPhase.isEmpty();
        for (PacketData data : this.loginPhase) {
            if (data.getPacket().getType() == PacketType.Bundle) {
                inBundle = !inBundle;
            }
            stream.insert(timestamp, data.getPacket());
        }
        this.loginPhase.clear();
        if (!this.configurationPhase.isEmpty()) {
            if (!hadLoginPhase) {
                stream.insert(timestamp, new Packet(this.registry, PacketType.Reconfigure));
            }
            for (PacketData data : this.configurationPhase) {
                stream.insert(timestamp, data.getPacket());
            }
            this.configurationPhase.clear();
        }
        for (PacketData data : this.preJoinGame) {
            if (data.getPacket().getType() == PacketType.Bundle) {
                inBundle = !inBundle;
            }
            stream.insert(timestamp, data.getPacket());
        }
        this.preJoinGame.clear();
        PacketData packetData = this.latestOnly.remove((Object)PacketType.JoinGame);
        PacketData respawn = this.latestOnly.remove((Object)PacketType.Respawn);
        if (packetData != null) {
            stream.insert(timestamp, packetData.getPacket());
        }
        if (respawn != null) {
            stream.insert(timestamp, respawn.getPacket());
        }
        PacketData updateViewPosition = this.latestOnly.remove((Object)PacketType.UpdateViewPosition);
        PacketData updateViewDistance = this.latestOnly.remove((Object)PacketType.UpdateViewDistance);
        if (updateViewPosition != null) {
            stream.insert(timestamp, updateViewPosition.getPacket());
        }
        if (updateViewDistance != null) {
            stream.insert(timestamp, updateViewDistance.getPacket());
        }
        ArrayList<PacketData> result = new ArrayList<PacketData>();
        result.addAll(this.unhandled);
        result.addAll(this.currentWorld);
        result.addAll(this.currentWindow);
        result.addAll(this.closeWindows);
        result.addAll(this.mainInventoryChanges.values());
        result.addAll(this.latestOnly.values());
        this.unhandled.clear();
        this.currentWorld.clear();
        this.currentWindow.clear();
        this.closeWindows.clear();
        this.mainInventoryChanges.clear();
        this.latestOnly.clear();
        if (this.cameraPositionRotation != null && (entity = this.entities.get(this.recordingPlayerEntityId)) != null) {
            if (((Entity)((Object)entity)).teleport != null) {
                Location location = PacketEntityTeleport.getLocation(((Entity)((Object)entity)).teleport);
                this.cameraPositionRotation.x = location.getX();
                this.cameraPositionRotation.y = location.getY();
                this.cameraPositionRotation.z = location.getZ();
                this.cameraPositionRotation.yaw = location.getYaw();
                this.cameraPositionRotation.pitch = location.getPitch();
            }
            this.cameraPositionRotation.x += (double)((Entity)entity).dx;
            this.cameraPositionRotation.y += (double)((Entity)entity).dy;
            this.cameraPositionRotation.z += (double)((Entity)entity).dz;
            if (((Entity)entity).yaw != null && ((Entity)entity).pitch != null) {
                this.cameraPositionRotation.yaw = ((Entity)entity).yaw.floatValue();
                this.cameraPositionRotation.pitch = ((Entity)entity).pitch.floatValue();
            }
        }
        entity = this.entities.entrySet().iterator();
        while (true) {
            Iterator iterator2;
            Entity entity2;
            Map.Entry entry;
            if (entity.hasNext()) {
                entry = (Map.Entry)entity.next();
                entity2 = (Entity)entry.getValue();
                if (entity2.despawned) {
                    result.add(new PacketData(entity2.lastTimestamp, PacketDestroyEntities.write(this.registry, (int)((Integer)entry.getKey()))));
                    entity2.release();
                    continue;
                }
                iterator2 = entity2.packets.iterator();
            } else {
                this.entities.clear();
                for (Map.Entry<Long, Long> entry2 : this.unloadedChunks.entrySet()) {
                    int x = ColumnPos.longToX(entry2.getKey());
                    int z = ColumnPos.longToZ(entry2.getKey());
                    result.add(new PacketData(entry2.getValue(), PacketChunkData.unload(x, z).write(this.registry)));
                }
                break;
            }
            block6: while (iterator2.hasNext()) {
                PacketData data = (PacketData)iterator2.next();
                Packet packet = data.getPacket();
                for (int i : PacketUtils.getEntityIds(packet)) {
                    Entity other = this.entities.get(i);
                    if (other != null && !other.despawned) continue;
                    packet.release();
                    continue block6;
                }
                result.add(data);
            }
            if (entity2.teleport != null) {
                result.add(new PacketData(entity2.lastTimestamp, entity2.teleport));
            }
            while (entity2.dx != 0L || entity2.dy != 0L || entity2.dz != 0L) {
                long mx = Utils.within(entity2.dx, -128L, 127L);
                long my = Utils.within(entity2.dy, -128L, 127L);
                long mz = Utils.within(entity2.dz, -128L, 127L);
                Entity entity3 = entity2;
                entity3.dx = entity3.dx - mx;
                entity3 = entity2;
                entity3.dy = entity3.dy - my;
                entity3 = entity2;
                entity3.dz = entity3.dz - mz;
                DPosition deltaPos = new DPosition((double)mx / 32.0, (double)my / 32.0, (double)mz / 32.0);
                result.add(new PacketData(entity2.lastTimestamp, PacketEntityMovement.write(this.registry, (Integer)entry.getKey(), deltaPos, null, entity2.onGround)));
            }
            if (entity2.yaw == null || entity2.pitch == null) continue;
            result.add(new PacketData(entity2.lastTimestamp, PacketEntityMovement.write(this.registry, (Integer)entry.getKey(), null, (Pair<Float, Float>)Pair.of((Object)entity2.yaw, (Object)entity2.pitch), entity2.onGround)));
        }
        entity = this.chunks.values().iterator();
        while (true) {
            int my;
            Map[] mapArray;
            PacketUpdateLight.Data lightData;
            ChunkData chunkData;
            if (entity.hasNext()) {
                chunkData = (ChunkData)entity.next();
                lightData = new PacketUpdateLight.Data(Arrays.asList(chunkData.skyLight), Arrays.asList(chunkData.blockLight));
                PacketChunkData.Column column = new PacketChunkData.Column(chunkData.x, chunkData.z, chunkData.changes, chunkData.biomeData, chunkData.tileEntities, chunkData.heightmaps, chunkData.biomes, chunkData.useExistingLightData, lightData);
                if (column.isFull() || !Utils.containsOnlyNull(chunkData.changes)) {
                    result.add(new PacketData(chunkData.firstAppearance, PacketChunkData.load(column).write(this.registry)));
                }
                mapArray = chunkData.blockChanges;
                my = mapArray.length;
            } else {
                this.chunks.clear();
                result.sort(Comparator.comparingLong(PacketData::getTime));
                pendingBundle = null;
                iterator = result.iterator();
                break;
            }
            for (int i = 0; i < my; ++i) {
                Map e = mapArray[i];
                if (e == null) continue;
                for (MutablePair pair : e.values()) {
                    result.add(new PacketData((Long)pair.getLeft(), ((PacketBlockChange)pair.getRight()).write(this.registry)));
                }
            }
            for (MutablePair pair : chunkData.allBlockChanges.values()) {
                result.add(new PacketData((Long)pair.getLeft(), ((PacketBlockChange)pair.getRight()).write(this.registry)));
            }
            if (!chunkData.hasLight() || !this.registry.olderThan(ProtocolVersion.v1_18)) continue;
            result.add(new PacketData(chunkData.firstAppearance, new PacketUpdateLight(chunkData.x, chunkData.z, lightData).write(this.registry)));
        }
        while (iterator.hasNext()) {
            PacketData data;
            block46: {
                data = (PacketData)iterator.next();
                if (data.getPacket().getType() == PacketType.Bundle) {
                    if (inBundle) {
                        inBundle = false;
                        break block46;
                    } else {
                        if (pendingBundle != null) {
                            pendingBundle.release();
                            pendingBundle = null;
                            data.release();
                            continue;
                        }
                        pendingBundle = data;
                        continue;
                    }
                }
                if (pendingBundle != null) {
                    this.add(stream, timestamp, pendingBundle.getPacket());
                    pendingBundle = null;
                    inBundle = true;
                }
            }
            this.add(stream, timestamp, data.getPacket());
        }
        if (pendingBundle != null) {
            this.add(stream, timestamp, pendingBundle.getPacket());
        }
        for (Team team : this.teams.values()) {
            if (team.create != null) {
                this.add(stream, timestamp, team.create);
            }
            if (team.update != null) {
                this.add(stream, timestamp, team.update);
            }
            if (team.remove != null) {
                this.add(stream, timestamp, team.remove);
                continue;
            }
            if (!team.added.isEmpty()) {
                this.add(stream, timestamp, PacketTeam.addPlayers(this.registry, team.name, team.added));
            }
            if (team.removed.isEmpty()) continue;
            this.add(stream, timestamp, PacketTeam.removePlayers(this.registry, team.name, team.removed));
        }
        this.teams.clear();
        for (Packet packet : this.maps.values()) {
            this.add(stream, timestamp, packet);
        }
        this.maps.clear();
        if (this.cameraPositionRotation != null) {
            this.add(stream, timestamp, this.cameraPositionRotation.write(this.registry));
        }
    }

    @Override
    public String getName() {
        return "squash";
    }

    @Override
    public void init(Studio studio, JsonObject config) {
    }

    private void add(PacketStream stream, long timestamp, Packet packet) {
        stream.insert(new PacketData(timestamp, packet));
    }

    private void updateBlock(long time, PacketBlockChange record) {
        IPosition pos = record.getPosition();
        this.chunks.computeIfAbsent(ColumnPos.coordToLong(pos.getX() >> 4, pos.getZ() >> 4), idx -> new ChunkData(time, pos.getX() >> 4, pos.getZ() >> 4)).updateBlock(time, record);
    }

    private void unloadChunk(long time, int x, int z) {
        long coord = ColumnPos.coordToLong(x, z);
        this.chunks.remove(coord);
        this.unloadedChunks.put(coord, time);
    }

    private void updateChunk(long time, PacketChunkData.Column column) {
        long coord = ColumnPos.coordToLong(column.x, column.z);
        this.unloadedChunks.remove(coord);
        ChunkData chunk = this.chunks.get(coord);
        if (chunk == null) {
            chunk = new ChunkData(time, column.x, column.z);
            this.chunks.put(coord, chunk);
        }
        chunk.update(column.chunks, column.biomeData, column.tileEntities, column.heightMaps, column.biomes, column.useExistingLightData);
        if (column.lightData != null) {
            chunk.updateLight(column.lightData);
        }
    }

    private static class ColumnPos {
        private ColumnPos() {
        }

        private static long coordToLong(int x, int z) {
            return (long)x << 32 | (long)z & 0xFFFFFFFFL;
        }

        private static int longToX(long coord) {
            return (int)(coord >> 32);
        }

        private static int longToZ(long coord) {
            return (int)(coord & 0xFFFFFFFFL);
        }
    }

    private class ChunkData {
        private final long firstAppearance;
        private final int x;
        private final int z;
        private PacketChunkData.Chunk[] changes = new PacketChunkData.Chunk[0];
        private byte[] biomeData;
        private Map<Short, MutablePair<Long, PacketBlockChange>>[] blockChanges = new Map[16];
        private final Map<Integer, MutablePair<Long, PacketBlockChange>> allBlockChanges = new HashMap<Integer, MutablePair<Long, PacketBlockChange>>();
        private PacketChunkData.TileEntity[] tileEntities;
        private CompoundTag heightmaps;
        private byte[][] skyLight = new byte[0][];
        private byte[][] blockLight = new byte[0][];
        private int[] biomes;
        private boolean useExistingLightData = true;

        ChunkData(long firstAppearance, int x, int z) {
            this.firstAppearance = firstAppearance;
            this.x = x;
            this.z = z;
        }

        ChunkData copy() {
            int i;
            ChunkData copy = new ChunkData(this.firstAppearance, this.x, this.z);
            copy.changes = new PacketChunkData.Chunk[this.changes.length];
            for (i = 0; i < this.changes.length; ++i) {
                copy.changes[i] = this.changes[i] != null ? this.changes[i].copy() : null;
            }
            copy.biomeData = this.biomeData;
            for (i = 0; i < this.blockChanges.length; ++i) {
                if (this.blockChanges[i] == null) continue;
                HashMap<Short, MutablePair<Long, PacketBlockChange>> copyMap = new HashMap<Short, MutablePair<Long, PacketBlockChange>>();
                copy.blockChanges[i] = copyMap;
                this.blockChanges[i].forEach((key, value) -> copyMap.put((Short)key, (MutablePair<Long, PacketBlockChange>)new MutablePair(value.left, value.right)));
            }
            this.allBlockChanges.forEach((key, value) -> copy.allBlockChanges.put((Integer)key, (MutablePair<Long, PacketBlockChange>)new MutablePair(value.left, value.right)));
            copy.tileEntities = this.tileEntities;
            copy.heightmaps = this.heightmaps;
            copy.skyLight = (byte[][])this.skyLight.clone();
            copy.blockLight = (byte[][])this.blockLight.clone();
            copy.biomes = this.biomes;
            copy.useExistingLightData = this.useExistingLightData;
            return copy;
        }

        void update(PacketChunkData.Chunk[] newChunks, byte[] newBiomeData, PacketChunkData.TileEntity[] newTileEntities, CompoundTag newHeightmaps, int[] newBiomes, boolean useExistingLightData) {
            if (this.changes.length < newChunks.length) {
                this.changes = Arrays.copyOf(this.changes, newChunks.length);
            }
            for (int i = 0; i < newChunks.length; ++i) {
                if (newChunks[i] == null) continue;
                this.changes[i] = newChunks[i];
                if (!SquashFilter.this.registry.olderThan(ProtocolVersion.v1_17)) continue;
                this.blockChanges[i] = null;
            }
            this.allBlockChanges.clear();
            if (newBiomeData != null) {
                this.biomeData = newBiomeData;
            }
            if (newTileEntities != null) {
                this.tileEntities = newTileEntities;
            }
            if (newHeightmaps != null) {
                this.heightmaps = newHeightmaps;
            }
            if (newBiomes != null) {
                this.biomes = newBiomes;
            }
            if (!useExistingLightData) {
                this.useExistingLightData = false;
            }
        }

        private void updateLight(PacketUpdateLight.Data data) {
            List<byte[]> skyLightUpdates = data.skyLight;
            List<byte[]> blockLightUpdates = data.blockLight;
            if (this.skyLight.length < skyLightUpdates.size()) {
                this.skyLight = (byte[][])Arrays.copyOf(this.skyLight, skyLightUpdates.size());
            }
            if (this.blockLight.length < blockLightUpdates.size()) {
                this.blockLight = (byte[][])Arrays.copyOf(this.blockLight, blockLightUpdates.size());
            }
            int i = 0;
            for (byte[] light : skyLightUpdates) {
                if (light != null) {
                    this.skyLight[i] = light;
                }
                ++i;
            }
            i = 0;
            for (byte[] light : blockLightUpdates) {
                if (light != null) {
                    this.blockLight[i] = light;
                }
                ++i;
            }
        }

        private boolean hasLight() {
            for (byte[] light : this.skyLight) {
                if (light == null) continue;
                return true;
            }
            for (byte[] light : this.blockLight) {
                if (light == null) continue;
                return true;
            }
            return false;
        }

        private MutablePair<Long, PacketBlockChange> blockChanges(IPosition pos) {
            int x = pos.getX();
            int y = pos.getY();
            int chunkY = y / 16;
            int z = pos.getZ();
            if (SquashFilter.this.registry.atLeast(ProtocolVersion.v1_17)) {
                int index = y << 10 | (x & 0xF) << 5 | z & 0xF;
                return this.allBlockChanges.computeIfAbsent(index, k -> MutablePair.of((Object)0L, null));
            }
            if (chunkY < 0 || chunkY >= this.blockChanges.length) {
                return null;
            }
            if (this.blockChanges[chunkY] == null) {
                this.blockChanges[chunkY] = new HashMap<Short, MutablePair<Long, PacketBlockChange>>();
            }
            short index = (short)((x & 0xF) << 10 | (y & 0xF) << 5 | z & 0xF);
            return this.blockChanges[chunkY].computeIfAbsent(index, k -> MutablePair.of((Object)0L, null));
        }

        void updateBlock(long time, PacketBlockChange change) {
            MutablePair<Long, PacketBlockChange> pair = this.blockChanges(change.getPosition());
            if (pair != null && (Long)pair.getLeft() <= time) {
                pair.setLeft((Object)time);
                pair.setRight((Object)change);
            }
        }
    }

    private static class Entity {
        private boolean complete;
        private boolean despawned;
        private List<PacketData> packets = new ArrayList<PacketData>();
        private long lastTimestamp = 0L;
        private Packet teleport;
        private long dx = 0L;
        private long dy = 0L;
        private long dz = 0L;
        private Float yaw = null;
        private Float pitch = null;
        private boolean onGround = false;

        private Entity() {
        }

        Entity copy() {
            Entity copy = new Entity();
            copy.complete = this.complete;
            copy.despawned = this.despawned;
            this.packets.forEach(it -> copy.packets.add(it.copy()));
            copy.lastTimestamp = this.lastTimestamp;
            copy.teleport = this.teleport != null ? this.teleport.copy() : null;
            copy.dx = this.dx;
            copy.dy = this.dy;
            copy.dz = this.dz;
            copy.yaw = this.yaw;
            copy.pitch = this.pitch;
            copy.onGround = this.onGround;
            return copy;
        }

        void release() {
            if (this.teleport != null) {
                this.teleport.release();
                this.teleport = null;
            }
            this.packets.forEach(PacketData::release);
            this.packets.clear();
        }
    }

    private static class Team {
        private final String name;
        private Packet create;
        private Packet update;
        private Packet remove;
        private final Set<String> added = new HashSet<String>();
        private final Set<String> removed = new HashSet<String>();

        private Team(String name) {
            this.name = name;
        }

        public Team copy() {
            Team copy = new Team(this.name);
            copy.create = this.create != null ? this.create.copy() : null;
            copy.update = this.update != null ? this.update.copy() : null;
            copy.remove = this.remove != null ? this.remove.copy() : null;
            copy.added.addAll(this.added);
            copy.removed.addAll(this.removed);
            return copy;
        }

        void release() {
            if (this.create != null) {
                this.create.release();
                this.create = null;
            }
            if (this.update != null) {
                this.update.release();
                this.update = null;
            }
            if (this.remove != null) {
                this.remove.release();
                this.remove = null;
            }
        }
    }
}

