/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.data;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.data.StructuredData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.data.StructuredDataKey;
import java.util.Objects;

final class FilledStructuredData<T>
implements StructuredData<T> {
    private final StructuredDataKey<T> key;
    private T value;
    private int id;

    FilledStructuredData(StructuredDataKey<T> key, T value, int id) {
        Preconditions.checkNotNull(key);
        this.key = key;
        this.value = value;
        this.id = id;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public void write(ByteBuf buffer) {
        this.key.type().write(buffer, this.value);
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public StructuredDataKey<T> key() {
        return this.key;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilledStructuredData that = (FilledStructuredData)o;
        if (this.id != that.id) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return FilledStructuredData.jvmdowngrader$concat$toString$1(this.key, this.value, this.id);
    }

    private static String jvmdowngrader$concat$toString$1(StructuredDataKey structuredDataKey, Object object, int n) {
        return "FilledStructuredData{key=" + structuredDataKey + ", value=" + object + ", id=" + n + "}";
    }
}

