/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.data;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={FilterableType.class})
public abstract class Filterable<T> {
    private final T raw;
    private final T filtered;

    protected Filterable(T raw, @Nullable T filtered) {
        this.raw = raw;
        this.filtered = filtered;
    }

    public T raw() {
        return this.raw;
    }

    public boolean isFiltered() {
        return this.filtered != null;
    }

    public @Nullable T filtered() {
        return this.filtered;
    }

    public T get() {
        return this.filtered != null ? this.filtered : this.raw;
    }

    @NestHost(value=Filterable.class)
    public static abstract class FilterableType<T, F extends Filterable<T>>
    extends Type<F> {
        private final Type<T> elementType;
        private final Type<T> optionalElementType;

        protected FilterableType(Type<T> elementType, Type<T> optionalElementType, Class<F> outputClass) {
            super(outputClass);
            this.elementType = elementType;
            this.optionalElementType = optionalElementType;
        }

        @Override
        public F read(ByteBuf buffer) {
            Object raw = this.elementType.read(buffer);
            Object filtered = this.optionalElementType.read(buffer);
            return this.create(raw, filtered);
        }

        @Override
        public void write(ByteBuf buffer, F value) {
            this.elementType.write(buffer, ((Filterable)value).raw());
            this.optionalElementType.write(buffer, ((Filterable)value).filtered());
        }

        protected abstract F create(T var1, T var2);
    }
}

