/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.data;

import Lcom.replaymod.replaystudio.lib.viaversion.api.minecraft.Holder;;
import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.Holder;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.SoundEvent;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.misc.HolderType;
import com.replaymod.replaystudio.lib.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import java.util.Arrays;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="soundEvent", type=Holder;.class), @RecordComponents.Value(name="useDuration", type=I.class), @RecordComponents.Value(name="range", type=F.class)})
@NestMembers(value={1.class})
public final class Instrument
extends J_L_Record {
    private final Holder<SoundEvent> soundEvent;
    private final int useDuration;
    private final float range;
    public static final HolderType<Instrument> TYPE = new HolderType<Instrument>(){

        @Override
        public Instrument readDirect(ByteBuf buffer) {
            Object soundEvent = Types.SOUND_EVENT.read(buffer);
            int useDuration = Types.VAR_INT.readPrimitive(buffer);
            float range = buffer.readFloat();
            return new Instrument((Holder<SoundEvent>)soundEvent, useDuration, range);
        }

        @Override
        public void writeDirect(ByteBuf buffer, Instrument value) {
            Types.SOUND_EVENT.write(buffer, value.soundEvent());
            Types.VAR_INT.writePrimitive(buffer, value.useDuration());
            buffer.writeFloat(value.range());
        }
    };

    public Instrument(Holder<SoundEvent> soundEvent, int useDuration, float range) {
        this.soundEvent = soundEvent;
        this.useDuration = useDuration;
        this.range = range;
    }

    @Override
    public final String toString() {
        return Instrument.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return Instrument.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return Instrument.jvmdowngrader$equals$equals(this, o);
    }

    public Holder<SoundEvent> soundEvent() {
        return this.soundEvent;
    }

    public int useDuration() {
        return this.useDuration;
    }

    public float range() {
        return this.range;
    }

    private static String jvmdowngrader$toString$toString(Instrument instrument) {
        Instrument instrument2 = instrument;
        return "Instrument[" + "soundEvent=" + instrument.soundEvent + ", " + "useDuration=" + instrument.useDuration + ", " + "range=" + instrument.range + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(Instrument instrument) {
        Object[] objectArray = new Object[]{instrument.soundEvent, instrument.useDuration, Float.valueOf(instrument.range)};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(Instrument instrument, Object object) {
        if (instrument == object) {
            return true;
        }
        if (object != null && object instanceof Instrument) {
            Instrument instrument2 = (Instrument)object;
            if (Objects.equals(instrument.soundEvent, instrument2.soundEvent) && instrument.useDuration == instrument2.useDuration && instrument.range == instrument2.range) {
                return true;
            }
        }
        return false;
    }
}

