/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import java.util.Arrays;
import java.util.BitSet;

public class BitSetType
extends Type<BitSet> {
    private final int length;
    private final int bytesLength;

    public BitSetType(int length) {
        super(BitSet.class);
        this.length = length;
        this.bytesLength = -Math.floorDiv(-length, 8);
    }

    @Override
    public BitSet read(ByteBuf buffer) {
        byte[] bytes = new byte[this.bytesLength];
        buffer.readBytes(bytes);
        return BitSet.valueOf(bytes);
    }

    @Override
    public void write(ByteBuf buffer, BitSet object) {
        Preconditions.checkArgument(object.length() <= this.length, BitSetType.jvmdowngrader$concat$write$1(object.length(), this.length));
        byte[] bytes = object.toByteArray();
        buffer.writeBytes(Arrays.copyOf(bytes, this.bytesLength));
    }

    private static String jvmdowngrader$concat$write$1(int n, int n2) {
        return "BitSet of length " + n + " larger than max length " + n2;
    }
}

