/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types.chunk;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.Chunk;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.ChunkSection;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.api.type.types.chunk.ChunkType1_8;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ChunkBulkSection.class})
public class BulkChunkType1_8
extends Type<Chunk[]> {
    public static final Type<Chunk[]> TYPE = new BulkChunkType1_8();
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int BLOCKS_BYTES = 8192;
    private static final int LIGHT_BYTES = 2048;
    private static final int BIOME_BYTES = 256;

    public BulkChunkType1_8() {
        super(Chunk[].class);
    }

    @Override
    public Chunk[] read(ByteBuf input) {
        int i;
        boolean skyLight = input.readBoolean();
        int count = Types.VAR_INT.readPrimitive(input);
        Chunk[] chunks = new Chunk[count];
        ChunkBulkSection[] chunkInfo = new ChunkBulkSection[count];
        for (i = 0; i < chunkInfo.length; ++i) {
            chunkInfo[i] = new ChunkBulkSection(input, skyLight);
        }
        for (i = 0; i < chunks.length; ++i) {
            ChunkBulkSection chunkBulkSection = chunkInfo[i];
            chunkBulkSection.readData(input);
            chunks[i] = ChunkType1_8.deserialize(chunkBulkSection.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$chunkX(), chunkBulkSection.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$chunkZ(), true, skyLight, chunkBulkSection.jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$bitmask(), chunkBulkSection.data());
        }
        return chunks;
    }

    @Override
    public void write(ByteBuf output, Chunk[] chunks) {
        boolean skyLight = false;
        block0: for (Chunk chunk : chunks) {
            for (ChunkSection section : chunk.getSections()) {
                if (section == null || !section.getLight().hasSkyLight()) continue;
                skyLight = true;
                break block0;
            }
        }
        output.writeBoolean(skyLight);
        Types.VAR_INT.writePrimitive(output, chunks.length);
        for (Chunk chunk : chunks) {
            output.writeInt(chunk.getX());
            output.writeInt(chunk.getZ());
            output.writeShort(chunk.getBitmask());
        }
        for (Chunk chunk : chunks) {
            output.writeBytes(ChunkType1_8.serialize(chunk));
        }
    }

    @NestHost(value=BulkChunkType1_8.class)
    public static final class ChunkBulkSection {
        private final int chunkX;
        private final int chunkZ;
        private final int bitmask;
        private final byte[] data;

        public ChunkBulkSection(ByteBuf input, boolean skyLight) {
            this.chunkX = input.readInt();
            this.chunkZ = input.readInt();
            this.bitmask = input.readUnsignedShort();
            int setSections = Integer.bitCount(this.bitmask);
            this.data = new byte[setSections * (8192 + (skyLight ? 4096 : 2048)) + 256];
        }

        public void readData(ByteBuf input) {
            input.readBytes(this.data);
        }

        public int chunkX() {
            return this.chunkX;
        }

        public int chunkZ() {
            return this.chunkZ;
        }

        public int bitmask() {
            return this.bitmask;
        }

        public byte[] data() {
            return this.data;
        }

        int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$chunkX() {
            return this.chunkX;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$set$chunkX(int n) {
            this.chunkX = n;
        }

        int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$bitmask() {
            return this.bitmask;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$set$bitmask(int n) {
            this.bitmask = n;
        }

        int jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$get$chunkZ() {
            return this.chunkZ;
        }

        void jvmdowngrader$nest$com_replaymod_replaystudio_lib_viaversion_api_type_types_chunk_BulkChunkType1_8$ChunkBulkSection$set$chunkZ(int n) {
            this.chunkZ = n;
        }
    }
}

