/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.base;

import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.ProtocolInfo;
import com.replaymod.replaystudio.lib.viaversion.api.platform.providers.ViaProviders;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.AbstractProtocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolManager;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolPathEntry;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolPipeline;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.Direction;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.provider.PacketTypesProvider;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.VersionProvider;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.VersionType;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.exception.CancelException;
import com.replaymod.replaystudio.lib.viaversion.exception.InformativeException;
import com.replaymod.replaystudio.lib.viaversion.protocol.version.BaseVersionProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.base.ServerboundHandshakePackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.base.packet.BaseClientboundPacket;
import com.replaymod.replaystudio.lib.viaversion.protocols.base.packet.BasePacketTypesProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.base.packet.BaseServerboundPacket;
import java.util.ArrayList;
import java.util.List;

public class BaseProtocol
extends AbstractProtocol<BaseClientboundPacket, BaseClientboundPacket, BaseServerboundPacket, BaseServerboundPacket> {
    private static final int STATUS_INTENT = 1;
    private static final int LOGIN_INTENT = 2;
    private static final int TRANSFER_INTENT = 3;

    public BaseProtocol() {
        super(BaseClientboundPacket.class, BaseClientboundPacket.class, BaseServerboundPacket.class, BaseServerboundPacket.class);
    }

    @Override
    protected void registerPackets() {
        this.registerServerbound(ServerboundHandshakePackets.CLIENT_INTENTION, wrapper -> {
            Protocol baseProtocol;
            ProtocolVersion serverProtocol;
            int protocolVersion = wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.STRING);
            wrapper.passthrough(Types.UNSIGNED_SHORT);
            int state = wrapper.passthrough(Types.VAR_INT);
            ProtocolInfo info = wrapper.user().getProtocolInfo();
            info.setProtocolVersion(ProtocolVersion.getProtocol(protocolVersion));
            VersionProvider versionProvider = Via.getManager().getProviders().get(VersionProvider.class);
            if (versionProvider == null) {
                wrapper.user().setActive(false);
                return;
            }
            try {
                serverProtocol = versionProvider.getClosestServerProtocol(wrapper.user());
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting server protocol", e);
            }
            info.setServerProtocolVersion(serverProtocol);
            ProtocolManager protocolManager = Via.getManager().getProtocolManager();
            List<ProtocolPathEntry> protocolPath = protocolManager.getProtocolPath(info.protocolVersion(), serverProtocol);
            ProtocolPipeline pipeline = info.getPipeline();
            if (serverProtocol.getVersionType() != VersionType.SPECIAL && (baseProtocol = protocolManager.getBaseProtocol(serverProtocol)) != null) {
                pipeline.add(baseProtocol);
            }
            if (protocolPath != null) {
                ArrayList<Protocol> protocols = new ArrayList<Protocol>(protocolPath.size());
                for (ProtocolPathEntry entry : protocolPath) {
                    protocols.add(entry.protocol());
                    protocolManager.completeMappingDataLoading(entry.protocol().getClass());
                }
                pipeline.add(protocols);
                wrapper.set(Types.VAR_INT, 0, serverProtocol.getOriginalVersion());
            }
            if (Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().info(BaseProtocol.jvmdowngrader$concat$lambda$registerPackets$0$1(info.protocolVersion(), info.serverProtocolVersion()));
                Via.getPlatform().getLogger().info(BaseProtocol.jvmdowngrader$concat$lambda$registerPackets$0$1(pipeline.pipes()));
            }
            if (state == 1) {
                info.setState(State.STATUS);
            } else if (state == 2) {
                info.setState(State.LOGIN);
            } else if (state == 3) {
                info.setState(State.LOGIN);
                if (serverProtocol.olderThan(ProtocolVersion.v1_20_5)) {
                    wrapper.set(Types.VAR_INT, 1, 2);
                }
            }
        });
    }

    @Override
    public boolean isBaseProtocol() {
        return true;
    }

    @Override
    public void register(ViaProviders providers) {
        providers.register(VersionProvider.class, new BaseVersionProvider());
    }

    @Override
    public void transform(Direction direction, State state, PacketWrapper packetWrapper) throws InformativeException, CancelException {
        super.transform(direction, state, packetWrapper);
        if (direction == Direction.SERVERBOUND && state == State.HANDSHAKE && packetWrapper.getId() != 0) {
            packetWrapper.user().setActive(false);
        }
    }

    @Override
    protected PacketTypesProvider<BaseClientboundPacket, BaseClientboundPacket, BaseServerboundPacket, BaseServerboundPacket> createPacketTypesProvider() {
        return BasePacketTypesProvider.INSTANCE;
    }

    private static String jvmdowngrader$concat$lambda$registerPackets$0$1(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
        return "User connected with protocol: " + protocolVersion + " and serverProtocol: " + protocolVersion2;
    }

    private static String jvmdowngrader$concat$lambda$registerPackets$0$1(List list) {
        return "Protocol pipeline: " + list;
    }
}

