/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.rewriter;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.data.Int2IntMapMappings;
import com.replaymod.replaystudio.lib.viaversion.api.data.Mappings;
import com.replaymod.replaystudio.lib.viaversion.api.data.ParticleMappings;
import com.replaymod.replaystudio.lib.viaversion.api.data.entity.DimensionData;
import com.replaymod.replaystudio.lib.viaversion.api.data.entity.TrackedEntity;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.Particle;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.RegistryEntry;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityData;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entitydata.EntityDataType;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.Item;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.ClientboundPacketType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandler;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.PacketHandlers;
import com.replaymod.replaystudio.lib.viaversion.api.rewriter.ItemRewriter;
import com.replaymod.replaystudio.lib.viaversion.api.rewriter.RewriterBase;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.api.type.Types;
import com.replaymod.replaystudio.lib.viaversion.data.entity.DimensionDataImpl;
import com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataFilter;
import com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataHandlerEvent;
import com.replaymod.replaystudio.lib.viaversion.rewriter.entitydata.EntityDataHandlerEventImpl;
import com.replaymod.replaystudio.lib.viaversion.util.Key;
import com.replaymod.replaystudio.lib.viaversion.util.TagUtil;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.NumberTag;
import com.viaversion.nbt.tag.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={4.class, 3.class, 2.class, 1.class})
public abstract class EntityRewriter<C extends ClientboundPacketType, T extends Protocol<C, ?, ?, ?>>
extends RewriterBase<T>
implements com.replaymod.replaystudio.lib.viaversion.api.rewriter.EntityRewriter<T> {
    private static final EntityData[] EMPTY_ARRAY = new EntityData[0];
    protected final List<EntityDataFilter> entityDataFilters = new ArrayList<EntityDataFilter>();
    protected final boolean trackMappedType;
    protected Mappings typeMappings;

    protected EntityRewriter(T protocol) {
        this(protocol, true);
    }

    protected EntityRewriter(T protocol, boolean trackMappedType) {
        super(protocol);
        this.trackMappedType = trackMappedType;
        protocol.put(this);
    }

    public EntityDataFilter.Builder filter() {
        return new EntityDataFilter.Builder(this);
    }

    public void registerFilter(EntityDataFilter filter) {
        Preconditions.checkArgument(!this.entityDataFilters.contains(filter));
        this.entityDataFilters.add(filter);
    }

    @Override
    public void handleEntityData(int entityId, List<EntityData> entityDataList, UserConnection connection) {
        TrackedEntity entity = this.tracker(connection).entity(entityId);
        EntityType type = entity != null ? entity.entityType() : null;
        for (EntityData entityData : entityDataList.toArray(EMPTY_ARRAY)) {
            EntityDataHandlerEvent event = null;
            for (EntityDataFilter filter : this.entityDataFilters) {
                if (!filter.isFiltered(type, entityData)) continue;
                if (event == null) {
                    event = new EntityDataHandlerEventImpl(connection, entity, entityId, entityData, entityDataList);
                }
                try {
                    filter.handler().handle(event, entityData);
                }
                catch (Exception e) {
                    this.logException(e, type, entityDataList, entityData);
                    entityDataList.remove(entityData);
                    break;
                }
                if (!event.cancelled()) continue;
                entityDataList.remove(entityData);
                break;
            }
            if (event == null || !event.hasExtraData()) continue;
            entityDataList.addAll(event.extraData());
        }
        if (entity != null) {
            entity.sentEntityData(true);
        }
    }

    @Override
    public int newEntityId(int id) {
        return this.typeMappings != null ? this.typeMappings.getNewIdOrDefault(id, id) : id;
    }

    public void mapEntityType(EntityType type, EntityType mappedType) {
        Preconditions.checkArgument(type.getClass() != mappedType.getClass(), "EntityTypes should not be of the same class/enum");
        this.mapEntityType(type.getId(), mappedType.getId());
    }

    protected void mapEntityType(int id, int mappedId) {
        if (this.typeMappings == null) {
            this.typeMappings = Int2IntMapMappings.of();
        }
        this.typeMappings.setNewId(id, mappedId);
    }

    public void mapTypes() {
        Preconditions.checkArgument(this.typeMappings == null, "Type mappings have already been set - manual type mappings should be set *after* this");
        Preconditions.checkNotNull(this.protocol.getMappingData().getEntityMappings(), "Protocol does not have entity mappings");
        this.typeMappings = this.protocol.getMappingData().getEntityMappings();
    }

    public void registerEntityDataTypeHandler(@Nullable EntityDataType itemType, @Nullable EntityDataType blockStateType, @Nullable EntityDataType particleType) {
        this.registerEntityDataTypeHandler(itemType, null, blockStateType, particleType, null);
    }

    public void registerEntityDataTypeHandler(@Nullable EntityDataType itemType, @Nullable EntityDataType blockStateType, @Nullable EntityDataType optionalBlockStateType, @Nullable EntityDataType particleType, @Nullable EntityDataType particlesType) {
        this.registerEntityDataTypeHandler(itemType, blockStateType, optionalBlockStateType, particleType, particlesType, null, null);
    }

    public void registerEntityDataTypeHandler(@Nullable EntityDataType itemType, @Nullable EntityDataType blockStateType, @Nullable EntityDataType optionalBlockStateType, @Nullable EntityDataType particleType, @Nullable EntityDataType particlesType, @Nullable EntityDataType componentType, @Nullable EntityDataType optionalComponentType) {
        this.filter().handler((event, data) -> {
            EntityDataType type = data.dataType();
            if (type == itemType) {
                data.setValue(this.protocol.getItemRewriter().handleItemToClient(event.user(), (Item)data.value()));
            } else if (type == blockStateType) {
                int value = (Integer)data.value();
                data.setValue(this.protocol.getMappingData().getNewBlockStateId(value));
            } else if (type == optionalBlockStateType) {
                int value = (Integer)data.value();
                if (value != 0) {
                    data.setValue(this.protocol.getMappingData().getNewBlockStateId(value));
                }
            } else if (type == particleType) {
                this.rewriteParticle(event.user(), (Particle)data.value());
            } else if (type == particlesType) {
                Particle[] particles;
                for (Particle particle : particles = (Particle[])data.value()) {
                    this.rewriteParticle(event.user(), particle);
                }
            } else if (type == componentType || type == optionalComponentType) {
                Tag component = (Tag)data.value();
                this.protocol.getComponentRewriter().processTag(event.user(), component);
            }
        });
    }

    public void registerBlockStateHandler(EntityType entityType, int index) {
        this.filter().type(entityType).index(index).handler((event, meta) -> {
            int data = (Integer)meta.getValue();
            meta.setValue(this.protocol.getMappingData().getNewBlockStateId(data));
        });
    }

    public void registerTracker(C packetType) {
        this.protocol.registerClientbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.map(Types.VAR_INT);
                this.handler(EntityRewriter.this.trackerHandler());
            }
        });
    }

    public void registerTrackerWithData(C packetType, final EntityType fallingBlockType) {
        this.protocol.registerClientbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.map(Types.VAR_INT);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.map(Types.INT);
                this.handler(EntityRewriter.this.trackerHandler());
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Types.VAR_INT, 0);
                    EntityType entityType = EntityRewriter.this.tracker(wrapper.user()).entityType(entityId);
                    if (entityType == fallingBlockType) {
                        wrapper.set(Types.INT, 0, EntityRewriter.this.protocol.getMappingData().getNewBlockStateId(wrapper.get(Types.INT, 0)));
                    }
                });
            }
        });
    }

    public void registerTrackerWithData1_19(C packetType, final EntityType fallingBlockType) {
        this.protocol.registerClientbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                this.map(Types.UUID);
                this.map(Types.VAR_INT);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.DOUBLE);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.map(Types.BYTE);
                this.map(Types.VAR_INT);
                this.handler(EntityRewriter.this.trackerHandler());
                this.handler(wrapper -> {
                    if (EntityRewriter.this.protocol.getMappingData() == null) {
                        return;
                    }
                    int entityId = wrapper.get(Types.VAR_INT, 0);
                    EntityType entityType = EntityRewriter.this.tracker(wrapper.user()).entityType(entityId);
                    if (entityType == fallingBlockType) {
                        wrapper.set(Types.VAR_INT, 2, EntityRewriter.this.protocol.getMappingData().getNewBlockStateId(wrapper.get(Types.VAR_INT, 2)));
                    }
                });
            }
        });
    }

    public void registerTracker(C packetType, EntityType entityType, Type<Integer> intType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            int entityId = (Integer)wrapper.passthrough(intType);
            this.tracker(wrapper.user()).addEntity(entityId, entityType);
        });
    }

    public void registerTracker(C packetType, EntityType entityType) {
        this.registerTracker(packetType, entityType, Types.VAR_INT);
    }

    public void registerRemoveEntities(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            int[] entityIds = wrapper.passthrough(Types.VAR_INT_ARRAY_PRIMITIVE);
            Object entityTracker = this.tracker(wrapper.user());
            for (int entity : entityIds) {
                entityTracker.removeEntity(entity);
            }
        });
    }

    public void registerRemoveEntity(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            int entityId = wrapper.passthrough(Types.VAR_INT);
            this.tracker(wrapper.user()).removeEntity(entityId);
        });
    }

    public void registerSetEntityData(C packetType, final @Nullable Type<List<EntityData>> dataType, final Type<List<EntityData>> mappedDataType) {
        this.protocol.registerClientbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.VAR_INT);
                if (dataType != null) {
                    this.map(dataType, mappedDataType);
                } else {
                    this.map(mappedDataType);
                }
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Types.VAR_INT, 0);
                    List entityData = (List)wrapper.get(mappedDataType, 0);
                    EntityRewriter.this.handleEntityData(entityId, entityData, wrapper.user());
                });
            }
        });
    }

    public void registerSetEntityData(C packetType, Type<List<EntityData>> dataType) {
        this.registerSetEntityData(packetType, null, dataType);
    }

    public PacketHandler trackerHandler() {
        return this.trackerAndRewriterHandler(null);
    }

    public PacketHandler playerTrackerHandler() {
        return wrapper -> {
            Object tracker = this.tracker(wrapper.user());
            int entityId = wrapper.get(Types.INT, 0);
            tracker.setClientEntityId(entityId);
            tracker.addEntity(entityId, tracker.playerType());
        };
    }

    public PacketHandler worldDataTrackerHandler(int nbtIndex) {
        return wrapper -> {
            Object tracker = this.tracker(wrapper.user());
            CompoundTag registryData = wrapper.get(Types.NAMED_COMPOUND_TAG, nbtIndex);
            NumberTag height = registryData.getNumberTag("height");
            if (height != null) {
                int blockHeight = height.asInt();
                tracker.setCurrentWorldSectionHeight(blockHeight >> 4);
            } else {
                this.protocol.getLogger().warning(EntityRewriter.jvmdowngrader$concat$lambda$worldDataTrackerHandler$6$1(registryData));
            }
            NumberTag minY = registryData.getNumberTag("min_y");
            if (minY != null) {
                tracker.setCurrentMinY(minY.asInt());
            } else {
                this.protocol.getLogger().warning(EntityRewriter.jvmdowngrader$concat$lambda$worldDataTrackerHandler$6$2(registryData));
            }
            String world = wrapper.get(Types.STRING, 0);
            if (tracker.currentWorld() != null && !tracker.currentWorld().equals(world)) {
                tracker.clearEntities();
                tracker.trackClientEntity();
            }
            tracker.setCurrentWorld(world);
        };
    }

    public PacketHandler worldDataTrackerHandlerByKey() {
        return wrapper -> {
            String dimensionKey;
            Object tracker = this.tracker(wrapper.user());
            DimensionData dimensionData = tracker.dimensionData(dimensionKey = wrapper.get(Types.STRING, 0));
            if (dimensionData == null) {
                this.protocol.getLogger().severe(EntityRewriter.jvmdowngrader$concat$lambda$worldDataTrackerHandlerByKey$7$1(dimensionKey));
                dimensionData = tracker.dimensionData("minecraft:overworld");
                Preconditions.checkNotNull(dimensionData, "Overworld data missing");
            }
            tracker.setCurrentWorldSectionHeight(dimensionData.height() >> 4);
            tracker.setCurrentMinY(dimensionData.minY());
            String world = wrapper.get(Types.STRING, 1);
            if (tracker.currentWorld() != null && !tracker.currentWorld().equals(world)) {
                tracker.clearEntities();
                tracker.trackClientEntity();
            }
            tracker.setCurrentWorld(world);
        };
    }

    public PacketHandler worldDataTrackerHandlerByKey1_20_5(int dimensionIdIndex) {
        return wrapper -> {
            int dimensionId = wrapper.get(Types.VAR_INT, dimensionIdIndex);
            String world = wrapper.get(Types.STRING, 0);
            this.trackWorldDataByKey1_20_5(wrapper.user(), dimensionId, world);
        };
    }

    public void trackWorldDataByKey1_20_5(UserConnection connection, int dimensionId, String world) {
        Object tracker = this.tracker(connection);
        DimensionData dimensionData = tracker.dimensionData(dimensionId);
        if (dimensionData == null) {
            this.protocol.getLogger().severe(EntityRewriter.jvmdowngrader$concat$trackWorldDataByKey1_20_5$1(dimensionId));
            dimensionData = tracker.dimensionData("overworld");
            Preconditions.checkNotNull(dimensionData, "Overworld data missing");
        }
        tracker.setCurrentWorldSectionHeight(dimensionData.height() >> 4);
        tracker.setCurrentMinY(dimensionData.minY());
        if (tracker.currentWorld() != null && !tracker.currentWorld().equals(world)) {
            tracker.clearEntities();
            tracker.trackClientEntity();
        }
        tracker.setCurrentWorld(world);
    }

    public PacketHandler biomeSizeTracker() {
        return wrapper -> this.trackBiomeSize(wrapper.user(), wrapper.get(Types.NAMED_COMPOUND_TAG, 0));
    }

    public PacketHandler configurationBiomeSizeTracker() {
        return wrapper -> this.trackBiomeSize(wrapper.user(), wrapper.get(Types.COMPOUND_TAG, 0));
    }

    public void trackBiomeSize(UserConnection connection, CompoundTag registry) {
        ListTag<CompoundTag> biomes = TagUtil.getRegistryEntries(registry, "worldgen/biome");
        this.tracker(connection).setBiomesSent(biomes.size());
    }

    public PacketHandler dimensionDataHandler() {
        return wrapper -> this.cacheDimensionData(wrapper.user(), wrapper.get(Types.NAMED_COMPOUND_TAG, 0));
    }

    public PacketHandler configurationDimensionDataHandler() {
        return wrapper -> this.cacheDimensionData(wrapper.user(), wrapper.get(Types.COMPOUND_TAG, 0));
    }

    public void cacheDimensionData(UserConnection connection, CompoundTag registry) {
        ListTag<CompoundTag> dimensions = TagUtil.getRegistryEntries(registry, "dimension_type");
        HashMap<String, DimensionData> dimensionDataMap = new HashMap<String, DimensionData>(dimensions.size());
        for (CompoundTag dimension : dimensions) {
            NumberTag idTag = dimension.getNumberTag("id");
            CompoundTag element = dimension.getCompoundTag("element");
            String name = dimension.getStringTag("name").getValue();
            dimensionDataMap.put(Key.stripMinecraftNamespace(name), new DimensionDataImpl(idTag.asInt(), element));
        }
        this.tracker(connection).setDimensions(dimensionDataMap);
    }

    public void handleRegistryData1_20_5(UserConnection connection, String registryKey, RegistryEntry[] entries) {
        if (registryKey.equals("worldgen/biome")) {
            this.tracker(connection).setBiomesSent(entries.length);
        } else if (registryKey.equals("dimension_type")) {
            HashMap<String, DimensionData> dimensionDataMap = new HashMap<String, DimensionData>(entries.length);
            for (int i = 0; i < entries.length; ++i) {
                RegistryEntry entry = entries[i];
                String key = Key.stripMinecraftNamespace(entry.key());
                DimensionData dimensionData = entry.tag() != null ? new DimensionDataImpl(i, (CompoundTag)entry.tag()) : DimensionDataImpl.withDefaultsFor(key, i);
                dimensionDataMap.put(key, dimensionData);
            }
            this.tracker(connection).setDimensions(dimensionDataMap);
        }
    }

    public PacketHandler trackerAndRewriterHandler(@Nullable Type<List<EntityData>> dataType) {
        return wrapper -> {
            int entityId = wrapper.get(Types.VAR_INT, 0);
            int type = wrapper.get(Types.VAR_INT, 1);
            int newType = this.newEntityId(type);
            if (newType != type) {
                wrapper.set(Types.VAR_INT, 1, newType);
            }
            EntityType entType = this.typeFromId(this.trackMappedType ? newType : type);
            this.tracker(wrapper.user()).addEntity(entityId, entType);
            if (dataType != null) {
                this.handleEntityData(entityId, (List)wrapper.get(dataType, 0), wrapper.user());
            }
        };
    }

    public PacketHandler trackerAndRewriterHandler(@Nullable Type<List<EntityData>> dataType, EntityType entityType) {
        return wrapper -> {
            int entityId = wrapper.get(Types.VAR_INT, 0);
            this.tracker(wrapper.user()).addEntity(entityId, entityType);
            if (dataType != null) {
                this.handleEntityData(entityId, (List)wrapper.get(dataType, 0), wrapper.user());
            }
        };
    }

    public PacketHandler objectTrackerHandler() {
        return wrapper -> {
            int entityId = wrapper.get(Types.VAR_INT, 0);
            byte type = wrapper.get(Types.BYTE, 0);
            EntityType entType = this.objectTypeFromId(type);
            this.tracker(wrapper.user()).addEntity(entityId, entType);
        };
    }

    public RegistryEntry[] addRegistryEntries(RegistryEntry[] entries, RegistryEntry ... toAdd) {
        int length = entries.length;
        RegistryEntry[] newEntries = Arrays.copyOf(entries, length + toAdd.length);
        System.arraycopy(toAdd, 0, newEntries, length, toAdd.length);
        return newEntries;
    }

    public void rewriteParticle(UserConnection connection, Particle particle) {
        int id;
        ParticleMappings mappings = this.protocol.getMappingData().getParticleMappings();
        if (mappings.isBlockParticle(id = particle.id())) {
            Particle.ParticleData<Integer> data = particle.getArgument(0);
            data.setValue(this.protocol.getMappingData().getNewBlockStateId((Integer)data.getValue()));
        } else if (mappings.isItemParticle(id) && this.protocol.getItemRewriter() != null) {
            Particle.ParticleData<Item> data = particle.getArgument(0);
            ItemRewriter<?> itemRewriter = this.protocol.getItemRewriter();
            Item item = itemRewriter.handleItemToClient(connection, (Item)data.getValue());
            if (itemRewriter.mappedItemType() != null && itemRewriter.itemType() != itemRewriter.mappedItemType()) {
                particle.set(0, itemRewriter.mappedItemType(), item);
            } else {
                data.setValue(item);
            }
        }
        particle.setId(this.protocol.getMappingData().getNewParticleId(id));
    }

    public void rewriteParticle(PacketWrapper wrapper, Type<Particle> from, Type<Particle> to) {
        Particle particle = wrapper.read(from);
        this.rewriteParticle(wrapper.user(), particle);
        wrapper.write(to, particle);
    }

    private void logException(Exception e, @Nullable EntityType type, List<EntityData> entityDataList, EntityData entityData) {
        if (!Via.getConfig().isSuppressMetadataErrors() || Via.getManager().isDebug()) {
            this.protocol.getLogger().severe(EntityRewriter.jvmdowngrader$concat$logException$1(this.getClass().getSimpleName(), type != null ? type.name() : "untracked", entityData));
            this.protocol.getLogger().severe(entityDataList.stream().sorted(Comparator.comparingInt(EntityData::id)).map(EntityData::toString).collect(Collectors.joining("\n", "Full entity data: ", "")));
            this.protocol.getLogger().log(Level.SEVERE, "Error: ", e);
        }
    }

    private static String jvmdowngrader$concat$trackWorldDataByKey1_20_5$1(int n) {
        return "Dimension data missing for dimension: " + n + ", falling back to overworld";
    }

    private static String jvmdowngrader$concat$logException$1(String string, String string2, EntityData entityData) {
        return "An error occurred in entity data handler " + string + " for " + string2 + " entity type: " + entityData;
    }

    private static String jvmdowngrader$concat$lambda$worldDataTrackerHandlerByKey$7$1(String string) {
        return "Dimension data missing for dimension: " + string + ", falling back to overworld";
    }

    private static String jvmdowngrader$concat$lambda$worldDataTrackerHandler$6$1(CompoundTag compoundTag) {
        return "Height missing in dimension data: " + compoundTag;
    }

    private static String jvmdowngrader$concat$lambda$worldDataTrackerHandler$6$2(CompoundTag compoundTag) {
        return "Min Y missing in dimension data: " + compoundTag;
    }
}

