/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.util;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.data.FullMappings;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.entities.EntityType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import java.util.ArrayList;
import java.util.Comparator;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={EntityIdSetter.class})
public final class EntityTypeUtil {
    private static final EntityType[] EMPTY_ARRAY = new EntityType[0];

    public static EntityType[] toOrderedArray(EntityType[] values) {
        ArrayList<EntityType> types = new ArrayList<EntityType>();
        for (EntityType type : values) {
            if (type.getId() == -1) continue;
            types.add(type);
        }
        types.sort(Comparator.comparingInt(EntityType::getId));
        return types.toArray(EMPTY_ARRAY);
    }

    public static <T extends EntityType> void initialize(T[] values, EntityType[] typesToFill, Protocol<?, ?, ?, ?> protocol, EntityIdSetter<T> idSetter) {
        FullMappings mappings = protocol.getMappingData().getEntityMappings();
        for (T type : values) {
            if (type.isAbstractType()) continue;
            int id = mappings.mappedId(type.identifier());
            Preconditions.checkArgument(id != -1, "Entity type %s has no id", type.identifier());
            idSetter.setId(type, id);
            typesToFill[id] = type;
        }
        if (typesToFill.length != mappings.mappedSize()) {
            throw new IllegalArgumentException(EntityTypeUtil.jvmdowngrader$concat$initialize$1(typesToFill.length, mappings.size()));
        }
    }

    public static EntityType[] createSizedArray(EntityType[] values) {
        int count = 0;
        for (EntityType type : values) {
            if (type.isAbstractType()) continue;
            ++count;
        }
        return new EntityType[count];
    }

    public static EntityType getTypeFromId(EntityType[] values, int typeId, EntityType fallback) {
        EntityType type;
        if (typeId < 0 || typeId >= values.length || (type = values[typeId]) == null) {
            Via.getPlatform().getLogger().severe(EntityTypeUtil.jvmdowngrader$concat$getTypeFromId$1(fallback.getClass().getSimpleName(), typeId));
            return fallback;
        }
        return type;
    }

    private static String jvmdowngrader$concat$initialize$1(int n, int n2) {
        return "typesToFill length doesn't match the amount of entity types: " + n + " != " + n2;
    }

    private static String jvmdowngrader$concat$getTypeFromId$1(String string, int n) {
        return "Could not find " + string + " type id " + n;
    }

    @FunctionalInterface
    @NestHost(value=EntityTypeUtil.class)
    public static interface EntityIdSetter<T extends EntityType> {
        public void setId(T var1, int var2);
    }
}

