/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.util;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.provider.PacketTypeMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProtocolUtil {
    @SafeVarargs
    public static <P extends PacketType> Map<State, PacketTypeMap<P>> packetTypeMap(@Nullable Class<P> parent, Class<? extends P> ... packetTypeClasses) {
        if (parent == null) {
            return Collections.emptyMap();
        }
        EnumMap<State, PacketTypeMap<P>> map = new EnumMap<State, PacketTypeMap<P>>(State.class);
        for (Class<P> clazz : packetTypeClasses) {
            PacketType[] types = (PacketType[])clazz.getEnumConstants();
            Preconditions.checkArgument(types != null, "%s not an enum", clazz);
            Preconditions.checkArgument(types.length > 0, "Enum %s has no types", clazz);
            State state = types[0].state();
            map.put(state, PacketTypeMap.of(clazz));
        }
        return map;
    }

    public static String toNiceHex(int id) {
        String hex = Integer.toHexString(id).toUpperCase(Locale.ROOT);
        return ProtocolUtil.jvmdowngrader$concat$toNiceHex$1(hex.length() == 1 ? "0x0" : "0x", hex);
    }

    public static String toNiceName(Class<? extends Protocol> protocol) {
        return protocol.getSimpleName().replace("Protocol", "").replace("To", "->").replace("_", ".");
    }

    private static String jvmdowngrader$concat$toNiceHex$1(String string, String string2) {
        return string + string2;
    }
}

