/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.change;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.path.Timeline;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import lombok.NonNull;

public class CombinedChange
implements Change {
    private final List<Change> changeList;
    private boolean applied;

    @NonNull
    public static CombinedChange create(Change ... changes) {
        return new CombinedChange(Arrays.asList(changes), false);
    }

    @NonNull
    public static CombinedChange createFromApplied(Change ... changes) {
        return new CombinedChange(Arrays.asList(changes), true);
    }

    CombinedChange(List<Change> changeList, boolean applied) {
        this.changeList = changeList;
        this.applied = applied;
    }

    @Override
    public void apply(Timeline timeline) {
        Preconditions.checkState(!this.applied, "Already applied!");
        for (Change change : this.changeList) {
            change.apply(timeline);
        }
        this.applied = true;
    }

    @Override
    public void undo(Timeline timeline) {
        Preconditions.checkState(this.applied, "Not yet applied!");
        ListIterator<Change> iterator = this.changeList.listIterator(this.changeList.size());
        while (iterator.hasPrevious()) {
            iterator.previous().undo(timeline);
        }
        this.applied = false;
    }
}

