/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.change;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import lombok.NonNull;

public final class RemoveInterpolatorProperty
implements Change {
    private final Interpolator interpolator;
    private final Property property;
    private boolean applied;

    @NonNull
    public static RemoveInterpolatorProperty create(Interpolator interpolator, Property property) {
        return new RemoveInterpolatorProperty(interpolator, property);
    }

    RemoveInterpolatorProperty(Interpolator interpolator, Property property) {
        this.interpolator = interpolator;
        this.property = property;
    }

    @Override
    public void apply(Timeline timeline) {
        Preconditions.checkState(!this.applied, "Already applied!");
        this.interpolator.unregisterProperty(this.property);
        this.applied = true;
    }

    @Override
    public void undo(Timeline timeline) {
        Preconditions.checkState(this.applied, "Not yet applied!");
        this.interpolator.registerProperty(this.property);
        this.applied = false;
    }
}

