/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.interpolation;

import com.replaymod.replaystudio.pathing.interpolation.AbstractInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.InterpolationParameters;
import com.replaymod.replaystudio.pathing.interpolation.PolynomialSplineInterpolator;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.property.PropertyPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CatmullRomSplineInterpolator
extends AbstractInterpolator {
    private final double alpha;
    private Map<PropertyPart<?>, PolynomialSplineInterpolator.Polynomial[]> cubicPolynomials = new HashMap();
    private Map<Property<?>, Set<Keyframe>> framesToProperty = new HashMap();

    private void addToMap(Property property, Keyframe keyframe) {
        Set<Keyframe> set = this.framesToProperty.get(property);
        if (set == null) {
            set = new LinkedHashSet<Keyframe>();
            this.framesToProperty.put(property, set);
        }
        set.add(keyframe);
    }

    @Override
    protected Map<PropertyPart, InterpolationParameters> bakeInterpolation(Map<PropertyPart, InterpolationParameters> parameters) {
        this.framesToProperty.clear();
        for (PathSegment segment : this.getSegments()) {
            for (Property property : this.getKeyframeProperties()) {
                if (segment.getStartKeyframe().getValue(property).isPresent()) {
                    this.addToMap(property, segment.getStartKeyframe());
                }
                if (!segment.getEndKeyframe().getValue(property).isPresent()) continue;
                this.addToMap(property, segment.getEndKeyframe());
            }
        }
        this.calcPolynomials();
        HashMap<PropertyPart, InterpolationParameters> lastParameters = new HashMap<PropertyPart, InterpolationParameters>();
        for (Property property : this.getKeyframeProperties()) {
            for (PropertyPart part : property.getParts()) {
                PolynomialSplineInterpolator.Polynomial[] polynomials = this.cubicPolynomials.get(part);
                PolynomialSplineInterpolator.Polynomial last = polynomials[polynomials.length - 1];
                double value = last.eval(1.0);
                double velocity = last.derivative().eval(1.0);
                double acceleration = last.derivative().derivative().eval(1.0);
                lastParameters.put(part, new InterpolationParameters(value, velocity, acceleration));
            }
        }
        return lastParameters;
    }

    protected void calcPolynomials() {
        for (Map.Entry<Property<?>, Set<Keyframe>> e : this.framesToProperty.entrySet()) {
            Property<?> property = e.getKey();
            Set<Keyframe> keyframes = e.getValue();
            for (PropertyPart<?> part : property.getParts()) {
                if (!part.isInterpolatable()) continue;
                ArrayList<Double> values = new ArrayList<Double>();
                if (Double.isNaN(part.getUpperBound())) {
                    for (Keyframe k : keyframes) {
                        values.add(this.getValueAsDouble(k, part));
                    }
                } else {
                    double bound = part.getUpperBound();
                    double halfBound = bound / 2.0;
                    Iterator<Keyframe> it = keyframes.iterator();
                    Double lastValue = null;
                    Integer offset = null;
                    while (it.hasNext()) {
                        Keyframe keyframe = it.next();
                        double value = this.mod(this.getValueAsDouble(keyframe, part), bound);
                        if (lastValue == null) {
                            lastValue = value;
                            offset = (int)Math.floor(value / bound);
                        }
                        if (Math.abs(value - lastValue) > halfBound) {
                            Integer n;
                            Integer n2;
                            if (lastValue < halfBound) {
                                n2 = offset;
                                n = offset = Integer.valueOf(offset - 1);
                            } else {
                                n2 = offset;
                                n = offset = Integer.valueOf(offset + 1);
                            }
                        }
                        values.add(value + (double)offset.intValue() * bound);
                        lastValue = value;
                    }
                }
                PolynomialSplineInterpolator.Polynomial[] polynomials = new PolynomialSplineInterpolator.Polynomial[values.size() - 1];
                for (int i = 0; i < values.size() - 1; ++i) {
                    double p1 = (Double)values.get(i);
                    double p2 = (Double)values.get(i + 1);
                    double p0 = i > 0 ? (Double)values.get(i - 1) : p1;
                    double p3 = i < keyframes.size() - 2 ? (Double)values.get(i + 2) : p2;
                    double t0 = this.alpha * (p2 - p0);
                    double t1 = this.alpha * (p3 - p1);
                    double[] c = new double[]{2.0 * p1 - 2.0 * p2 + t0 + t1, -3.0 * p1 + 3.0 * p2 - 2.0 * t0 - t1, t0, p1};
                    polynomials[i] = new PolynomialSplineInterpolator.Polynomial(c);
                }
                this.cubicPolynomials.put(part, polynomials);
            }
        }
    }

    private double mod(double val, double m) {
        double off = Math.floor(val / m);
        return val - off * m;
    }

    private <T> double getValueAsDouble(Keyframe keyframe, PropertyPart<T> part) {
        return part.toDouble(keyframe.getValue(part.getProperty()).get());
    }

    @Override
    public <T> Optional<T> getValue(Property<T> property, long time) {
        Set<Keyframe> kfSet = this.framesToProperty.get(property);
        if (kfSet == null) {
            return Optional.empty();
        }
        Object valueBefore = null;
        long timeBefore = -1L;
        long timeAfter = -1L;
        int index = 0;
        int i = 0;
        for (Keyframe keyframe : kfSet) {
            if (keyframe.getTime() == time) {
                return keyframe.getValue(property);
            }
            if (keyframe.getTime() < time) {
                index = i;
                timeBefore = keyframe.getTime();
                valueBefore = keyframe.getValue(property).get();
            } else if (keyframe.getTime() > time) {
                timeAfter = keyframe.getTime();
                break;
            }
            ++i;
        }
        if (timeBefore == -1L || timeAfter == -1L) {
            return Optional.empty();
        }
        double fraction = (double)(time - timeBefore) / (double)(timeAfter - timeBefore);
        Object interpolated = valueBefore;
        for (PropertyPart<Object> propertyPart : property.getParts()) {
            if (!propertyPart.isInterpolatable()) continue;
            PolynomialSplineInterpolator.Polynomial[] polynomials = this.cubicPolynomials.get(propertyPart);
            interpolated = propertyPart.fromDouble(interpolated, polynomials[index].eval(fraction));
        }
        return Optional.of(interpolated);
    }

    public CatmullRomSplineInterpolator(double alpha) {
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

