/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.serialize;

import com.google.gson.GsonBuilder;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.pathing.PathingRegistry;
import com.replaymod.replaystudio.pathing.interpolation.CubicSplineInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.LinearInterpolator;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.serialize.LegacyKeyframeSetAdapter;
import com.replaymod.replaystudio.replay.ReplayFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Triple;

public class LegacyTimelineConverter {
    public static Map<String, Timeline> convert(PathingRegistry registry, ReplayFile replayFile) throws IOException {
        KeyframeSet[] keyframeSets = LegacyTimelineConverter.readAndParse(replayFile);
        if (keyframeSets == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Timeline> timelines = new LinkedHashMap<String, Timeline>();
        for (KeyframeSet keyframeSet : keyframeSets) {
            timelines.put(keyframeSet.name, LegacyTimelineConverter.convert(registry, keyframeSet));
        }
        return timelines;
    }

    private static Optional<InputStream> read(ReplayFile replayFile) throws IOException {
        Optional<InputStream> in = replayFile.get("paths.json");
        if (!in.isPresent()) {
            in = replayFile.get("paths");
        }
        return in;
    }

    private static KeyframeSet[] parse(InputStream in) {
        return (KeyframeSet[])new GsonBuilder().registerTypeAdapter(KeyframeSet[].class, (Object)new LegacyKeyframeSetAdapter()).create().fromJson((Reader)new InputStreamReader(in), KeyframeSet[].class);
    }

    private static KeyframeSet[] readAndParse(ReplayFile replayFile) throws IOException {
        KeyframeSet[] keyframeSets;
        Optional<InputStream> optIn = LegacyTimelineConverter.read(replayFile);
        if (!optIn.isPresent()) {
            return null;
        }
        try (InputStream in = optIn.get();){
            keyframeSets = LegacyTimelineConverter.parse(in);
        }
        return keyframeSets;
    }

    private static Timeline convert(PathingRegistry registry, KeyframeSet keyframeSet) {
        com.replaymod.replaystudio.pathing.path.Keyframe keyframe;
        Object value;
        Timeline timeline = registry.createTimeline();
        Property timestamp = timeline.getProperty("timestamp");
        Property cameraPosition = timeline.getProperty("camera:position");
        Property cameraRotation = timeline.getProperty("camera:rotation");
        Path timePath = timeline.createPath();
        Path positionPath = timeline.createPath();
        for (Keyframe<AdvancedPosition> keyframe2 : keyframeSet.positionKeyframes) {
            value = (AdvancedPosition)keyframe2.value;
            keyframe = LegacyTimelineConverter.getKeyframe(positionPath, keyframe2.realTimestamp);
            keyframe.setValue(cameraPosition, Triple.of((Object)((AdvancedPosition)value).x, (Object)((AdvancedPosition)value).y, (Object)((AdvancedPosition)value).z));
            keyframe.setValue(cameraRotation, Triple.of((Object)Float.valueOf(((AdvancedPosition)value).yaw), (Object)Float.valueOf(((AdvancedPosition)value).pitch), (Object)Float.valueOf(((AdvancedPosition)value).roll)));
            if (!(value instanceof SpectatorData)) continue;
        }
        for (Keyframe<Object> keyframe3 : keyframeSet.timeKeyframes) {
            value = (TimestampValue)keyframe3.value;
            keyframe = LegacyTimelineConverter.getKeyframe(timePath, keyframe3.realTimestamp);
            keyframe.setValue(timestamp, (int)((TimestampValue)value).value);
        }
        LinearInterpolator timeInterpolator = new LinearInterpolator();
        timeInterpolator.registerProperty(timestamp);
        timePath.getSegments().forEach(s -> s.setInterpolator(timeInterpolator));
        CubicSplineInterpolator positionInterpolator = new CubicSplineInterpolator();
        positionInterpolator.registerProperty(cameraPosition);
        positionInterpolator.registerProperty(cameraRotation);
        positionPath.getSegments().forEach(s -> s.setInterpolator(positionInterpolator));
        return timeline;
    }

    private static com.replaymod.replaystudio.pathing.path.Keyframe getKeyframe(Path path, long time) {
        com.replaymod.replaystudio.pathing.path.Keyframe keyframe = path.getKeyframe(time);
        if (keyframe == null) {
            keyframe = path.insert(time);
        }
        return keyframe;
    }

    static class NumberValue {
        double value;

        NumberValue() {
        }
    }

    static class Transformations {
        Position defaultAnchor;
        Position defaultPosition;
        Position defaultOrientation;
        Position defaultScale;
        NumberValue defaultOpacity;
        List<Position> anchorKeyframes;
        List<Position> positionKeyframes;
        List<Position> orientationKeyframes;
        List<Position> scaleKeyframes;
        List<NumberValue> opacityKeyframes;

        Transformations() {
        }
    }

    static class CustomImageObject {
        String name;
        UUID linkedAsset;
        float width;
        float height;
        float textureWidth;
        float textureHeight;
        Transformations transformations = new Transformations();

        CustomImageObject() {
        }
    }

    static class TimestampValue {
        double value;

        TimestampValue() {
        }
    }

    static class SpectatorDataThirdPersonInfo {
        double shoulderCamDistance;
        double shoulderCamPitchOffset;
        double shoulderCamYawOffset;
        double shoulderCamSmoothness;

        SpectatorDataThirdPersonInfo() {
        }
    }

    static class SpectatorData
    extends AdvancedPosition {
        Integer spectatedEntityID;
        SpectatingMethod spectatingMethod;
        SpectatorDataThirdPersonInfo thirdPersonInfo;

        SpectatorData() {
        }

        static enum SpectatingMethod {
            FIRST_PERSON,
            SHOULDER_CAM;

        }
    }

    static class AdvancedPosition
    extends Position {
        float pitch;
        float yaw;
        float roll;

        AdvancedPosition() {
        }
    }

    static class Position {
        double x;
        double y;
        double z;

        Position() {
        }
    }

    static class Keyframe<T> {
        int realTimestamp;
        T value;

        Keyframe() {
        }
    }

    static class KeyframeSet {
        String name;
        Keyframe<AdvancedPosition>[] positionKeyframes;
        Keyframe<TimestampValue>[] timeKeyframes;
        CustomImageObject[] customObjects;

        KeyframeSet() {
        }
    }
}

